{ *********************************************************************** }
{                                                                         }
{ Delphi Visual Component Library                                         }
{                                                                         }
{ Copyright (c) 1995-2005 Borland Software Corporation                    }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.DBTables platform;

{$R-,T-,H+,X+}

interface

uses
  Windows, Contnrs, Variants, SysUtils, Classes, 
  DB, DBCommon, BDE, DBCommonTypes,
  System.ComponentModel.Design.Serialization {, SMINTF};

const

                                                                      

{ SQL Trace buffer size }

  //smTraceBufSize = 32767 + Marshal.SizeOf(TypeOf(TraceDesc));

{ TDBDataSet flags }

  dbfOpened     = 0;
  dbfPrepared   = 1;
  dbfExecSQL    = 2;
  dbfTable      = 3;
  dbfFieldList  = 4;
  dbfIndexList  = 5;
  dbfStoredProc = 6;
  dbfExecProc   = 7;
  dbfProcDesc   = 8;
  dbfDatabase   = 9;
  dbfProvider   = 10;

{ FieldType Mappings }

const
  FldTypeMap: TFieldMap = (
    fldUNKNOWN, fldZSTRING, fldINT16, fldINT32, fldUINT16, fldBOOL,
    fldFLOAT, fldFLOAT, fldBCD, fldDATE, fldTIME, fldTIMESTAMP, fldBYTES,
    fldVARBYTES, fldINT32, fldBLOB, fldBLOB, fldBLOB, fldBLOB, fldBLOB,
    fldBLOB, fldBLOB, fldCURSOR, fldZSTRING, fldZSTRING, fldINT64, fldADT,
    fldArray, fldREF, fldTABLE, fldBLOB, fldBLOB, fldUNKNOWN, fldUNKNOWN,
    fldUNKNOWN, fldZSTRING, fldDATETIME,fldBCD,
    fldZSTRING, fldBLOB, fldDATETIME, fldZSTRING);

  FldSubTypeMap: array[TFieldType] of Word = (
    0, 0, 0, 0, 0, 0, 0, fldstMONEY, 0, 0, 0, 0, 0, 0, fldstAUTOINC,
    fldstBINARY, fldstMEMO, fldstGRAPHIC, fldstFMTMEMO, fldstOLEOBJ,
    fldstDBSOLEOBJ, fldstTYPEDBINARY, 0, fldstFIXED, fldstUNICODE,
    0, 0, 0, 0, 0, fldstHBINARY, fldstHMEMO, 0, 0, 0, 0, 0, 0,
    fldstFIXED, fldstMEMO, 0, 0 );

  DataTypeMap: array[0..MAXLOGFLDTYPES - 1] of TFieldType = (
    ftUnknown, ftString, ftDate, ftBlob, ftBoolean, ftSmallint,
    ftInteger, ftFloat, ftBCD, ftBytes, ftTime, ftDateTime,
    ftWord, ftInteger, ftUnknown, ftVarBytes, ftUnknown, ftUnknown,
    ftLargeInt, ftLargeInt, ftADT, ftArray, ftReference, ftDataSet, 
    ftTimeStamp);

  BlobTypeMap: array[fldstMEMO..fldstBFILE] of TFieldType = (
    ftMemo, ftBlob, ftFmtMemo, ftParadoxOle, ftGraphic, ftDBaseOle,
    ftTypedBinary, ftBlob, ftBlob, ftBlob, ftBlob, ftOraClob, ftOraBlob,
    ftBlob, ftBlob);

type

{ Forward declarations }

  TDBError = class;
  TSession = class;
  TDatabase = class;
  TBDEDataSet = class;
  TDBDataSet = class;
  TTable = class;

{ Exception classes }

  EDBEngineError = class(EDatabaseError)
  private
    FErrors: TList;
    function GetError(Index: Integer): TDBError;
    function GetErrorCount: Integer;
  public
    constructor Create(ErrorCode: DBIResult);
    destructor Destroy; override;
    property ErrorCount: Integer read GetErrorCount;
    property Errors[Index: Integer]: TDBError read GetError;
  end;

  ENoResultSet = class(EDatabaseError);

{ BDE error information type }

  TDBError = class
  private
    FErrorCode: DBIResult;
    FNativeError: Longint;
    FMessage: string;
    function GetCategory: Byte;
    function GetSubCode: Byte;
  public
    constructor Create(Owner: EDBEngineError; ErrorCode: DBIResult;
      NativeError: Longint; Message: string);
    property Category: Byte read GetCategory;
    property ErrorCode: DBIResult read FErrorCode;
    property SubCode: Byte read GetSubCode;
    property Message: string read FMessage;
    property NativeError: Longint read FNativeError;
  end;

{ TLocale }

  TLocale = IntPtr;

{ TBDECallback }

  TBDECallbackEvent = function(CBInfo: IntPtr): CBRType of object;

  TBDECallback = class
  private
    FHandle: hDBICur;
    FOwner: TObject;
    FCBType: CBType;
    FOldCBData: Integer;
    FOldCBBuf: IntPtr;
    FOldCBBufLen: Word;
    FOldCBFunc: pfDBICallBack;
    FInstalled: Boolean;
    FCallbackEvent: TBDECallbackEvent;
    FCBBuf: IntPtr;
    FCallBackDelegate: pfDBICallBack;
    function CallBack(CallType: CBType; Data: Integer; CBInfo: IntPtr): CBRType;
  protected
    function Invoke(CallType: CBType; CBInfo: IntPtr): CBRType;
  public
    constructor Create(AOwner: TObject; Handle: hDBICur; CBType: CBType;
      CBBuf: IntPtr; CBBufSize: Integer; CallbackEvent: TBDECallbackEvent;
      Chain: Boolean);
    destructor Destroy; override;
  end;

{ TSessionList }

  TFinalizeNotifyKind = (fnBeforeFinalizeList, fnAfterFinalizeList);

  TFinalizeNotifyProc = procedure of object;

  TSessionList = class(TObject)
  private
    FBeforeFinalizeList: TList;
    FAfterFinalizeList: TList;
    FSessions: TThreadList;
    FSessionNumbers: TBits;
    procedure AddSession(ASession: TSession);
    procedure CloseAll;
    function GetCount: Integer;
    function GetSession(Index: Integer): TSession;
    function GetCurrentSession: TSession;
    function GetSessionByName(const SessionName: string): TSession;
    procedure SetCurrentSession(Value: TSession);
  strict protected
    procedure Finalize; override;
  public
    constructor Create;
    destructor Destroy; override;
    property CurrentSession: TSession read GetCurrentSession write SetCurrentSession;
    function FindSession(const SessionName: string): TSession;
    procedure GetSessionNames(List: TStrings);
    function OpenSession(const SessionName: string): TSession;
    procedure RegisterFinalizeNotify(NotifyProc: TFinalizeNotifyProc;
      Kind: TFinalizeNotifyKind);
    procedure UnregisterFinalizeNotify(NotifyProc: TFinalizeNotifyProc;
      Kind: TFinalizeNotifyKind);
    property Count: Integer read GetCount;
    property Sessions[Index: Integer]: TSession read GetSession; default;
    property List[const SessionName: string]: TSession read GetSessionByName;
  end;

{ TSession }

  TConfigModes = (cfmVirtual, cfmPersistent, cfmSession);
  TConfigMode = set of TConfigModes;

  TPasswordEvent = procedure(Sender: TObject; var Continue: Boolean) of Object;

  TDatabaseEvent = (dbOpen, dbClose, dbAdd, dbRemove, dbAddAlias, dbDeleteAlias,
    dbAddDriver, dbDeleteDriver);

  TDatabaseNotifyEvent = procedure(DBEvent: TDatabaseEvent; const Param) of object;

  TBDEInitProc = procedure(Session: TSession);

  TTraceFlag = (tfQPrepare, tfQExecute, tfError, tfStmt, tfConnect,
    tfTransact, tfBlob, tfMisc, tfVendor, tfDataIn, tfDataOut);

  TTraceFlags = set of TTraceFlag;

  TSessionFinalizer = class
  private
    FDefault: Boolean;    // Moved from TSession
    FDLLDetach: Boolean;  // Moved from TSession
    FFinalizeNotify: TFinalizeNotifyProc;
    FHandle: HDBISes;     // Moved from TSession
    FNotifyList: TList;
    FSessionList: TSessionList;
    procedure FreeHandle;
    procedure FinalizeNotify;
  strict protected
    procedure Finalize; override;
    procedure CallNotifyProcs;
  public
    constructor Create(SessionList: TSessionList);
    procedure RegisterFinalizeNotify(NotifyProc: TFinalizeNotifyProc);
    procedure UnregisterFinalizeNotify(NotifyProc: TFinalizeNotifyProc);
  end;

  [RootDesignerSerializerAttribute('', '', False)]
  TSession = class(TComponent, IDBSession)
  private
    FHandle: TSessionFinalizer;
    FDatabases: TList;
    FCallbacks: TList;
    FLocale: TLocale;
                              
    {FSMClient: ISMClient;
    FSMBuffer: PTraceDesc;}
    FTraceFlags: TTraceFlags;
    FSMLoadFailed: Boolean;
    FStreamedActive: Boolean;
    FKeepConnections: Boolean;
    FSQLHourGlass: Boolean;
    FAutoSessionName: Boolean;
    FUpdatingAutoSessionName: Boolean;
    FBDEOwnsLoginCbDb: Boolean;
    FSessionName: string;
    FSessionNumber: Integer;
    FNetFileDir: string;
    FPrivateDir: string;
    FCBSCType: CBSCType;
    FLockCount: Integer;
    FReserved: Integer;
    FCBDBLogin: TCBDBLogin;
    FServerCBDelegate: TBDECallbackEvent;
    FDBLoginCBDelegate: TBDECallbackEvent;
    FOnPassword: TPasswordEvent;
    FOnStartup: TNotifyEvent;
    FOnDBNotify: TDatabaseNotifyEvent;
    procedure AddDatabase(Value: TDatabase);
    procedure CallBDEInitProcs;
    procedure CheckInactive;
    procedure CheckConfigMode(CfgMode: TConfigMode);
    procedure CloseDatabaseHandle(Database: TDatabase);
    function DBLoginCallback(CBInfo: IntPtr): CBRType;
    procedure DBNotification(DBEvent: TDatabaseEvent; const Param);
    procedure DeleteConfigPath(const Path, Node: string);
    function DoFindDatabase(const DatabaseName: string; AOwner: TComponent): TDatabase;
    function DoOpenDatabase(const DatabaseName: string; AOwner: TComponent): TDatabase;
    function FindDatabaseHandle(const DatabaseName: string): HDBIDB;
    function GetActive: Boolean;
    function GetConfigMode: TConfigMode;
    function GetDatabase(Index: Integer): TDatabase;
    function GetDatabaseCount: Integer;
    function GetHandle: HDBISes;
    function GetNetFileDir: string;
    function GetPrivateDir: string;
    procedure InitializeBDE;
    procedure InternalAddAlias(const Name, Driver: string; List: TStrings;
      CfgMode: TConfigMode; RestoreMode: Boolean);
    procedure InternalDeleteAlias(const Name: string; CfgMode: TConfigMode;
      RestoreMode: Boolean);
    function SessionNameStored: Boolean;
    procedure LoadSMClient(DesignTime: Boolean);
    procedure LockSession;
    procedure MakeCurrent;
    procedure RegisterCallbacks(Value: Boolean);
    procedure RemoveDatabase(Value: TDatabase);
    function ServerCallback(CBInfo: IntPtr): CBRType;
    procedure SetActive(Value: Boolean);
    procedure SetAutoSessionName(Value: Boolean);
    procedure SetConfigMode(Value: TConfigMode);
    procedure SetConfigParams(const Path, Node: string; List: TStrings);
    procedure SetNetFileDir(const Value: string);
    procedure SetPrivateDir(const Value: string);
    procedure SetSessionName(const Value: string);
    procedure SetSessionNames;
    procedure SetTraceFlags(Value: TTraceFlags);
    procedure SMClientSignal(Sender: TObject; Data: Integer);
    function SqlTraceCallback(CBInfo: IntPtr): CBRType;
    procedure StartSession(Value: Boolean);
    procedure UnlockSession;
    procedure UpdateAutoSessionName;
    procedure ValidateAutoSession(AOwner: TComponent; AllSessions: Boolean);
  protected
    procedure Loaded; override;
    procedure ModifyConfigParams(const Path, Node: string; List: TStrings);
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    property OnDBNotify: TDatabaseNotifyEvent read FOnDBNotify write FOnDBNotify;
    property BDEOwnsLoginCbDb: Boolean read FBDEOwnsLoginCbDb write FBDEOwnsLoginCbDb;
    procedure SetName(const NewName: TComponentName); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure AddAlias(const Name, Driver: string; List: TStrings);
    procedure AddDriver(const Name: string; List: TStrings);
    procedure AddStandardAlias(const Name, Path, DefaultDriver: string);
    property ConfigMode: TConfigMode read GetConfigMode write SetConfigMode;
    procedure AddPassword(const Password: string);
    procedure Close;
    procedure CloseDatabase(Database: TDatabase);
    procedure DeleteAlias(const Name: string);
    procedure DeleteDriver(const Name: string);
    procedure DropConnections;
    function FindDatabase(const DatabaseName: string): TDatabase;
    procedure GetAliasNames(List: TStrings);
    procedure GetAliasParams(const AliasName: string; List: TStrings);
    function GetAliasDriverName(const AliasName: string): string;
    procedure GetConfigParams(const Path, Section: string; List: TStrings);
    procedure GetDatabaseNames(List: TStrings);
    procedure GetDriverNames(List: TStrings);
    procedure GetDriverParams(const DriverName: string; List: TStrings);
    procedure GetFieldNames(const DatabaseName, TableName: string;
      List: TStrings);
    function GetPassword: Boolean;
    procedure GetTableNames(const DatabaseName, Pattern: string;
      Extensions, SystemTables: Boolean; List: TStrings);
    procedure GetStoredProcNames(const DatabaseName: string; List: TStrings);
    function IsAlias(const Name: string): Boolean;
    procedure ModifyAlias(Name: string; List: TStrings);
    procedure ModifyDriver(Name: string; List: TStrings);
    procedure Open;
    function OpenDatabase(const DatabaseName: string): TDatabase;
    procedure RemoveAllPasswords;
    procedure RemovePassword(const Password: string);
    procedure SaveConfigFile;
    property DatabaseCount: Integer read GetDatabaseCount;
    property Databases[Index: Integer]: TDatabase read GetDatabase;
    property Handle: HDBISES read GetHandle;
    property Locale: TLocale read FLocale;
    property TraceFlags: TTraceFlags read FTraceFlags write SetTraceFlags;
  published
    property Active: Boolean read GetActive write SetActive default False;
    property AutoSessionName: Boolean read FAutoSessionName write SetAutoSessionName default False;
    property KeepConnections: Boolean read FKeepConnections write FKeepConnections default True;
    property NetFileDir: string read GetNetFileDir write SetNetFileDir;
    property PrivateDir: string read GetPrivateDir write SetPrivateDir;
    property SessionName: string read FSessionName write SetSessionName stored SessionNameStored;
    property SQLHourGlass: Boolean read FSQLHourGlass write FSQLHourGlass default True;
    property OnPassword: TPasswordEvent read FOnPassword write FOnPassword;
    property OnStartup: TNotifyEvent read FOnStartup write FOnStartup;
  end;

{ TParamList }

  TFieldDescList = array of BDEFLDDesc;

  TParamList = class(TObject)
  private
    FFieldCount: Integer;
    FFieldDescs: TFieldDescList;
    FBuffer: IntPtr;
    FBufSize: Word;
  public
    constructor Create(Params: TStrings);
    destructor Destroy; override;
    property Buffer: IntPtr read FBuffer;
    property FieldCount: Integer read FFieldCount;
    property FieldDescs: TFieldDescList read FFieldDescs;
  end;

{ TDatabase }

  TDatabaseFinalizer = class
  private
    FHandle: HDBIDB;
    FFinalizeNotify: TFinalizeNotifyProc;
    FSession: TSession;
    procedure FinalizeNotify;
    procedure FreeHandle;
  strict protected
    procedure Finalize; override;
  public
    constructor Create;
    procedure Register(ASession: TSession);
    procedure Unregister;
  end;

  TTransIsolation = (tiDirtyRead, tiReadCommitted, tiRepeatableRead);

  TDatabaseLoginEvent = procedure(Database: TDatabase;
    LoginParams: TStrings) of object;

  TDatabase = class(TCustomConnection)
  private
    FTransIsolation: TTransIsolation;
    FKeepConnection: Boolean;
    FTemporary: Boolean;
    FSessionAlias: Boolean;
    FLocaleLoaded: Boolean;
    FAliased: Boolean;
    FSQLBased: Boolean;
    FAcquiredHandle: Boolean;
    FPseudoIndexes: Boolean;
    FHandleShared: Boolean;
    FExclusive: Boolean;
    FReadOnly: Boolean;
    FRefCount: Integer;
    FHandle: TDatabaseFinalizer;
    FLocale: TLocale;
    FSession: TSession;
    FParams: TStrings;
    FStmtList: TList;
    FSessionName: string;
    FDatabaseName: string;
    FDatabaseType: string;
    FOnLogin: TDatabaseLoginEvent;
    procedure CheckActive;
    procedure CheckInactive;
    procedure CheckDatabaseName;
    procedure CheckDatabaseAlias(var Password: string);
    procedure CheckSessionName(Required: Boolean);
    procedure ClearStatements;
    procedure EndTransaction(TransEnd: EXEnd);
    function GetAliasName: string;
    function GetDirectory: string;
    function GetDriverName: string;
    function GetHandle: HDBIDB;
    function GetInTransaction: Boolean;
                                      
    //function GetObjectContext: IUnknown;
    function GetTraceFlags: TTraceFlags;
    procedure LoadLocale;
    procedure Login(LoginParams: TStrings);
    function OpenFromExistingDB: Boolean;
    procedure ParamsChanging(Sender: TObject);
    procedure SetAliasName(const Value: string);
    procedure SetDatabaseFlags;
    procedure SetDatabaseName(const Value: string);
    procedure SetDatabaseType(const Value: string; Aliased: Boolean);
    procedure SetDirectory(const Value: string);
    procedure SetDriverName(const Value: string);
    procedure SetExclusive(Value: Boolean);
    procedure SetHandle(Value: HDBIDB);
    procedure SetKeepConnection(Value: Boolean);
    procedure SetParams(Value: TStrings);
    procedure SetReadOnly(Value: Boolean);
    procedure SetTraceFlags(Value: TTraceFlags);
    procedure SetSessionName(const Value: string);
  protected
    procedure DoConnect; override;
    procedure DoDisconnect; override;
    function GetConnected: Boolean; override;
    function GetDataSet(Index: Integer): TDBDataSet; reintroduce;
    procedure Loaded; override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure RegisterClient(Client: TObject; Event: TConnectChangeEvent = nil); override;
    procedure UnRegisterClient(Client: TObject); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure ApplyUpdates(const DataSets: array of TDBDataSet);
    procedure CloseDataSets;
    procedure Commit;
    function Execute(const SQL: string; Params: TParams = nil;
      Cache: Boolean = False; Cursor: phDBICur = nil): Integer;
    procedure FlushSchemaCache(const TableName: string);
    procedure GetFieldNames(const TableName: string; List: TStrings);
    procedure GetTableNames(List: TStrings; SystemTables: Boolean = False);
    procedure Rollback;
    procedure StartTransaction;
    procedure ValidateName(const Name: string);
    property DataSets[Index: Integer]: TDBDataSet read GetDataSet;
    property Directory: string read GetDirectory write SetDirectory;
    property Handle: HDBIDB read GetHandle write SetHandle;
    property IsSQLBased: Boolean read FSQLBased;
    property InTransaction: Boolean read GetInTransaction;
    property Locale: TLocale read FLocale;
    property Session: TSession read FSession;
    property Temporary: Boolean read FTemporary write FTemporary;
    property SessionAlias: Boolean read FSessionAlias;
    property TraceFlags: TTraceFlags read GetTraceFlags write SetTraceFlags;
  published
    property AliasName: string read GetAliasName write SetAliasName;
    property Connected;
    property DatabaseName: string read FDatabaseName write SetDatabaseName;
    property DriverName: string read GetDriverName write SetDriverName;
    property Exclusive: Boolean read FExclusive write SetExclusive default False;
    property HandleShared: Boolean read FHandleShared write FHandleShared default False;
    property KeepConnection: Boolean read FKeepConnection write SetKeepConnection default True;
    property LoginPrompt default True;
    property Params: TStrings read FParams write SetParams;
    property ReadOnly: Boolean read FReadOnly write SetReadOnly default False;
    property SessionName: string read FSessionName write SetSessionName;
    property TransIsolation: TTransIsolation read FTransIsolation write FTransIsolation default tiReadCommitted;
    property AfterConnect;
    property AfterDisconnect;
    property BeforeConnect;
    property BeforeDisconnect;
    property OnLogin: TDatabaseLoginEvent read FOnLogin write FOnLogin;
  end;

{ TBDEDataSet }

  TRecNoStatus = (rnDbase, rnParadox, rnNotSupported);

  [RootDesignerSerializerAttribute('', '', False)]
  TDataSetUpdateObject = class(TComponent)
  protected
    function GetDataSet: TDataSet; virtual; abstract;
    procedure SetDataSet(ADataSet: TDataSet); virtual; abstract;
    property DataSet: TDataSet read GetDataSet write SetDataSet;
  public
    procedure Apply(UpdateKind: TUpdateKind); virtual; abstract;
  end;

  TSQLUpdateObject = class(TDataSetUpdateObject)
  protected
     function GetSQL(UpdateKind: TUpdateKind): TStrings; virtual; abstract;
  end;

  PKeyBuffer = IntPtr; { ^TBDEKeyBuffer }
  TBDEKeyBuffer = packed record
    Modified: Boolean;
    Exclusive: Boolean;
    FieldCount: Integer;
  end;

  TBDERecInfo = packed record
    RecordNumber: Longint;
    UpdateStatus: TUpdateStatus;
    BookmarkFlag: TBookmarkFlag;
  end;

  TBlobBytes = TBytes; // Use TBlobBytes instead of TBlobData to avoid
                       // excessive copying of data when converting
                       // between string and TBytes

  TFilterBuffer = IntPtr;

  TBlockReadBuffer = IntPtr;

  TBDEDataSet = class(TDataSet)
  private
    FHandle: HDBICur;
    FStmtHandle: HDBIStmt;
    FRecProps: RecProps;
    FLocale: TLocale;
    FExprFilter: HDBIFilter;
    FFuncFilter: HDBIFilter;
    FFuncFilterDelegate: pfGENFilter;
    FFilterBuffer: TFilterBuffer;
    FIndexFieldMap: DBIKey;
    FExpIndex: Boolean;
    FCaseInsIndex: Boolean;
    FCachedUpdates: Boolean;
    FCachedUpdateCBDelegate: TBDECallbackEvent;
    FInUpdateCallback: Boolean;
    FCanModify: Boolean;
    FCacheBlobs: Boolean;
    FKeySize: Word;
    FUpdateCBBuf: DELAYUPDCbDesc;
    FUpdateCallback: TBDECallback;
    FKeyBuffers: array[TKeyIndex] of PKeyBuffer;
    FKeyBuffer: PKeyBuffer;
    FRecNoStatus: TRecNoStatus;
    FIndexFieldCount: Integer;
    FConstDisableCount: Integer;
    FRecordSize: Word;
    FBookmarkOfs: Word;
    FRecInfoOfs: Word;
    FBlobCacheOfs: Word;
    FRecBufSize: Word;
    FConstraintLayer: Boolean;
    FConstraintCBDelegate: pfDataSourcesCallback;
    FBlockBufSize: Integer;
    FBlockBufOfs: Integer;
    FBlockBufCount: Integer;
    FBlockReadCount: Integer;
    FLastParentPos: Integer;
    FBlockReadBuf: TBlockReadBuffer;
    FParentDataSet: TBDEDataSet;
    FUpdateObject: TDataSetUpdateObject;
    FOnUpdateError: TUpdateErrorEvent;
    FOnUpdateRecord: TUpdateRecordEvent;
    procedure ClearBlobCache(Buffer: TRecordBuffer);
    procedure InitBlobCache(Buffer: TRecordBuffer);
    function GetActiveRecBuf(var RecBuf: TRecordBuffer): Boolean;
    function GetBlobData(Field: TField; Buffer: TRecordBuffer): TBlobBytes;
    function GetBlobDataSize(Field: TField; Buffer: TRecordBuffer): Integer;
    function GetOldRecord: TRecordBuffer;
    procedure InitBufferPointers(GetProps: Boolean);
    function IsBlobDataCached(Field: TField; Buffer: TRecordBuffer): Boolean;
    function RecordFilter(ulClientData: Longint;
      RecBuf: TRecordBuffer; RecNo: Integer): Smallint;
    procedure SetBlobData(Field: TField; Buffer: TRecordBuffer; Value: TBlobBytes);
    function HasConstraints: Boolean;
  protected
    { IProviderSupport }
    function PSGetUpdateException(E: Exception; Prev: EUpdateError): EUpdateError; override;
    function PSIsSQLSupported: Boolean; override;
    procedure PSReset; override;
    function PSUpdateRecord(UpdateKind: TUpdateKind; Delta: TDataSet): Boolean; override;
  protected
    procedure ActivateFilters;
    procedure AddFieldDesc(FieldDescs: TFieldDescList; var DescNo: Integer;
      var FieldID: Integer; RequiredFields: TBits; FieldDefs: TFieldDefs);
    procedure AllocCachedUpdateBuffers(Allocate: Boolean);
    procedure AllocKeyBuffers;
    function AllocRecordBuffer: TRecordBuffer; override;
    function CachedUpdateCallBack(CBInfo: IntPtr): CBRType;
    procedure CheckCachedUpdateMode;
    procedure CheckSetKeyMode;
    procedure ClearCalcFields(Buffer: TRecordBuffer); override;
    procedure CloseCursor; override;
    procedure CloseBlob(Field: TField); override;
    function CreateExprFilter(const Expr: string;
      Options: TFilterOptions; Priority: Integer): HDBIFilter;
    function CreateFuncFilter(FilterFunc: pfGENFilter;
      Priority: Integer): HDBIFilter;
    function CreateHandle: HDBICur; virtual;
    function CreateLookupFilter(Fields: TList; const Values: Variant;
      Options: TLocateOptions; Priority: Integer): HDBIFilter;
    procedure DataEvent(Event: TDataEvent; Info: TObject); override;
    procedure DeactivateFilters;
    procedure DestroyHandle; virtual;
    procedure DestroyLookupCursor; virtual;
    function FindRecord(Restart, GoForward: Boolean): Boolean; override;
    function ForceUpdateCallback: Boolean;
    procedure FreeKeyBuffers;
    procedure FreeRecordBuffer(var Buffer: TRecordBuffer); override;
    procedure GetBookmarkData(Buffer: TRecordBuffer; var Data: TBookmark); override;
    function GetBookmarkFlag(Buffer: TRecordBuffer): TBookmarkFlag; override;
    function GetCanModify: Boolean; override;
    function GetFieldFullName(Field: TField): string; override;
    function GetHandle: HDBICur;
    function GetIndexField(Index: Integer): TField;
    function GetIndexFieldCount: Integer;
    function GetIsIndexField(Field: TField): Boolean; override;
    function GetKeyBuffer(KeyIndex: TKeyIndex): PKeyBuffer;
    function GetKeyExclusive: Boolean;
    function GetKeyFieldCount: Integer;
    function GetLookupCursor(const KeyFields: string;
      CaseInsensitive: Boolean): HDBICur; virtual;
    function GetRecord(Buffer: TRecordBuffer; GetMode: TGetMode; DoCheck: Boolean): TGetResult; override;
    function GetRecordCount: Integer; override;
    function GetRecNo: Integer; override;
    function GetRecordSize: Word; override;
    function GetStateFieldValue(State: TDataSetState; Field: TField): Variant; override;
    procedure GetObjectTypeNames(Fields: TFields);
    function GetUpdatesPending: Boolean;
    function GetUpdateRecordSet: TUpdateRecordTypes;
    function InitKeyBuffer(Buffer: PKeyBuffer): PKeyBuffer;
    procedure InitRecord(Buffer: TRecordBuffer); override;
    procedure InternalAddRecord(Buffer: TRecordBuffer; Append: Boolean); override;
    procedure InternalCancel; override;
    procedure InternalClose; override;
    procedure InternalDelete; override;
    procedure InternalEdit; override;
    procedure InternalFirst; override;
    procedure InternalGotoBookmark(const Bookmark: TBookmark); override;
    procedure InternalHandleException; override;
    procedure InternalInitFieldDefs; override;
    procedure InternalInitRecord(Buffer: TRecordBuffer); override;
    procedure InternalInsert; override;
    procedure InternalLast; override;
    procedure InternalOpen; override;
    procedure InternalPost; override;
    procedure InternalRefresh; override;
    procedure InternalSetToRecord(Buffer: TRecordBuffer); override;
    function IsCursorOpen: Boolean; override;
    function LocateRecord(const KeyFields: string; const KeyValues: Variant;
      Options: TLocateOptions; SyncCursor: Boolean): Boolean;
    function MapsToIndex(Fields: TList; CaseInsensitive: Boolean): Boolean;
    procedure OpenCursor(InfoQuery: Boolean); override;
    procedure PostKeyBuffer(Commit: Boolean);
    procedure PrepareCursor; virtual;
    function ProcessUpdates(UpdCmd: DBIDelayedUpdCmd): DBIResult;
    function ResetCursorRange: Boolean;
    procedure BlockReadNext; override;
    procedure SetBookmarkData(Buffer: TRecordBuffer; const Data: TBookmark); override;
    procedure SetBookmarkFlag(Buffer: TRecordBuffer; Value: TBookmarkFlag); override;
    procedure SetCachedUpdates(Value: Boolean);
    function SetCursorRange: Boolean;
    procedure SetBlockReadSize(Value: Integer); override;
    procedure SetFieldData(Field: TField; Buffer: TValueBuffer); override;
    procedure SetFilterData(const Text: string; Options: TFilterOptions);
    procedure SetFilterHandle(var Filter: HDBIFilter; Value: HDBIFilter);
    procedure SetFiltered(Value: Boolean); override;
    procedure SetFilterOptions(Value: TFilterOptions); override;
    procedure SetFilterText(const Value: string); override;
    procedure SetIndexField(Index: Integer; Value: TField);
    procedure SetKeyBuffer(KeyIndex: TKeyIndex; Clear: Boolean);
    procedure SetKeyExclusive(Value: Boolean);
    procedure SetKeyFieldCount(Value: Integer);
    procedure SetKeyFields(KeyIndex: TKeyIndex; const Values: array of const);
    procedure SetLinkRanges(MasterFields: TList);
    procedure SetLocale(Value: TLocale);
    procedure SetStateFieldValue(State: TDataSetState; Field: TField; const Value: Variant); override;
    procedure SetOnFilterRecord(const Value: TFilterRecordEvent); override;
    procedure SetOnUpdateError(UpdateEvent: TUpdateErrorEvent);
    procedure SetRecNo(Value: Integer); override;
    procedure SetupCallBack(Value: Boolean);
    procedure SetUpdateRecordSet(RecordTypes: TUpdateRecordTypes);
    procedure SetUpdateObject(Value: TDataSetUpdateObject);
    procedure SwitchToIndex(const IndexName, TagName: string);
    function UpdateCallbackRequired: Boolean;
    property StmtHandle: HDBIStmt read FStmtHandle write FStmtHandle;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure ApplyUpdates;
    function BookmarkValid(const Bookmark: TBookmark): Boolean; override;
    procedure Cancel; override;
    procedure CancelUpdates;
    property CacheBlobs: Boolean read FCacheBlobs write FCacheBlobs default True;
    function CompareBookmarks(const Bookmark1, Bookmark2: TBookmark): Integer; override;
    procedure CommitUpdates;
    function ConstraintCallBack(lUserVal: Integer; Req: DsInfoReq;
      var ADataSources: DataSources): DBIResult;
    function ConstraintsDisabled: Boolean;
    function CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream; override;
    procedure DisableConstraints;
    procedure EnableConstraints;
    procedure FetchAll;
    procedure FlushBuffers;
    function GetCurrentRecord(Buffer: TRecordBuffer): Boolean; override;
    function GetBlobFieldData(FieldNo: Integer; var Buffer: TBlobByteData): Integer; override;
    function GetFieldData(Field: TField; Buffer: TValueBuffer): Boolean; overload; override;
    function GetFieldData(FieldNo: Integer; Buffer: TValueBuffer): Boolean; overload; override;
    procedure GetIndexInfo;
    function Locate(const KeyFields: string; const KeyValues: Variant;
      Options: TLocateOptions): Boolean; override;
    function Lookup(const KeyFields: string; const KeyValues: Variant;
      const ResultFields: string): Variant; override;
    function IsSequenced: Boolean; override;
    procedure Post; override;
    procedure RevertRecord;
    function UpdateStatus: TUpdateStatus; override;
    function Translate(const Src: string; var Dest: string; ToOem: Boolean): Integer;  override;
    property ExpIndex: Boolean read FExpIndex;
    property Handle: HDBICur read FHandle;
    property KeySize: Word read FKeySize;
    property Locale: TLocale read FLocale;
    property UpdateObject: TDataSetUpdateObject read FUpdateObject write SetUpdateObject;
    property UpdatesPending: Boolean read GetUpdatesPending;
    property UpdateRecordTypes: TUpdateRecordTypes read GetUpdateRecordSet write SetUpdateRecordSet;
  published
    property Active;
    property AutoCalcFields;
    property CachedUpdates: Boolean read FCachedUpdates write SetCachedUpdates default False;
    property ObjectView default False;
    property BeforeOpen;
    property AfterOpen;
    property BeforeClose;
    property AfterClose;
    property BeforeInsert;
    property AfterInsert;
    property BeforeEdit;
    property AfterEdit;
    property BeforePost;
    property AfterPost;
    property BeforeCancel;
    property AfterCancel;
    property BeforeDelete;
    property AfterDelete;
    property BeforeScroll;
    property AfterScroll;
    property BeforeRefresh;
    property AfterRefresh;
    property OnCalcFields;
    property OnDeleteError;
    property OnEditError;
    property OnNewRecord;
    property OnPostError;
    property OnUpdateError: TUpdateErrorEvent read FOnUpdateError write SetOnUpdateError;
    property OnUpdateRecord: TUpdateRecordEvent read FOnUpdateRecord write FOnUpdateRecord;
  end;

{ TNestedTable }

  TNestedTable = class(TBDEDataSet)
  protected
    function CreateHandle: HDBICur; override;
    procedure DoAfterPost; override;
    procedure DoBeforeInsert; override;
    procedure InternalPost; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property DataSetField;
    property ObjectView default True;
  end;

{ TDBDataSet }

  TDBFlags = set of 0..15;

  TDBDataSet = class(TBDEDataSet)
  private
    FAutoRefresh: Boolean;
    FDBFlags: TDBFlags;
    FUpdateMode: TUpdateMode;
    FDatabase: TDatabase;
    FDatabaseName: string;
    FSessionName: string;
    procedure CheckDBSessionName;
    function GetDBHandle: HDBIDB;
    function GetDBLocale: TLocale;
    function GetDBSession: TSession;
    procedure SetDatabaseName(const Value: string);
    procedure SetSessionName(const Value: string);
    procedure SetUpdateMode(const Value: TUpdateMode);
    procedure SetAutoRefresh(const Value: Boolean);
    procedure SetupAutoRefresh;
  protected
    { IProviderSupport }
    procedure PSEndTransaction(Commit: Boolean); override;
    function PSExecuteStatement(const ASQL: string; AParams: TParams;
      var ResultSet: TObject): Integer; override;
    procedure PSGetAttributes(List: TList); override;
    function PSGetQuoteChar: string; override;
    function PSInTransaction: Boolean; override;
    function PSIsSQLBased: Boolean; override;
    procedure PSStartTransaction; override;
    function PSUpdateRecord(UpdateKind: TUpdateKind; Delta: TDataSet): Boolean; override;
  protected
    procedure CloseCursor; override;
    function ConstraintsStored: Boolean;
    procedure Disconnect; virtual;
    procedure OpenCursor(InfoQuery: Boolean); override;
    function SetDBFlag(Flag: Integer; Value: Boolean): Boolean; virtual;
    procedure SetHandle(Value: HDBICur);
    property DBFlags: TDBFlags read FDBFlags;
    property UpdateMode: TUpdateMode read FUpdateMode write SetUpdateMode default upWhereAll;
  public
    constructor Create(AOwner: TComponent); override;
    function CheckOpen(Status: DBIResult): Boolean;
    procedure CloseDatabase(Database: TDatabase);
    function OpenDatabase: TDatabase;
    property Database: TDatabase read FDatabase;
    property DBHandle: HDBIDB read GetDBHandle;
    property DBLocale: TLocale read GetDBLocale;
    property DBSession: TSession read GetDBSession;
    property Handle: HDBICur read GetHandle write SetHandle;
  published
    property AutoRefresh: Boolean read FAutoRefresh write SetAutoRefresh default False;
    property DatabaseName: string read FDatabaseName write SetDatabaseName;
    property Filter;
    property Filtered;
    property FilterOptions;
    property SessionName: string read FSessionName write SetSessionName;
    property OnFilterRecord;
  end;

{ TTable }

  TBatchMode = (batAppend, batUpdate, batAppendUpdate, batDelete, batCopy);
  TTableType = (ttDefault, ttParadox, ttDBase, ttFoxPro, ttASCII);
  TLockType = (ltReadLock, ltWriteLock);
  TIndexName = type string;

  TIndexDescList = array of IDXDesc;

  TValCheckList = array of VCHKDesc;

  TIndexFiles = class(TStringList)
  private
    FOwner: TTable;
  public
    constructor Create(AOwner: TTable);
    function Add(const S: string): Integer; override;
    procedure Clear; override;
    procedure Delete(Index: Integer); override;
    procedure Insert(Index: Integer; const S: string); override;
  end;

  TTable = class(TDBDataSet)
  private
    FStoreDefs: Boolean;
    FIndexDefs: TIndexDefs;
    FMasterLink: TMasterDataLink;
    FDefaultIndex: Boolean;
    FExclusive: Boolean;
    FReadOnly: Boolean;
    FTableType: TTableType;
    FFieldsIndex: Boolean;
    FTableName: TFileName;
    FIndexName: TIndexName;
    FIndexFiles: TStrings;
    FLookupHandle: HDBICur;
    FLookupKeyFields: string;
    FTableLevel: Integer;
    FLookupCaseIns: Boolean;
    FNativeTableName: DBITBLNAME;
    FRanged: Boolean;
    procedure CheckMasterRange;
    procedure DecodeIndexDesc(const IndexDesc: IDXDesc;
      var Source, Name, FieldExpression, DescFields: string;
      var Options: TIndexOptions);
    function FieldDefsStored: Boolean;
    function GetDriverTypeName: string;
    function GetExists: Boolean;
    function GetIndexFieldNames: string;
    function GetIndexName: string;
    procedure GetIndexParams(const IndexName: string; FieldsIndex: Boolean;
      var IndexedName, IndexTag: string);
    function GetMasterFields: string;
    function GetTableTypeName: string;
    function GetTableLevel: Integer;
    function IndexDefsStored: Boolean;
    function IsXBaseTable: Boolean;
    procedure MasterChanged(Sender: TObject);
    procedure MasterDisabled(Sender: TObject);
    procedure SetDataSource(Value: TDataSource);
    procedure SetExclusive(Value: Boolean);
    procedure SetIndexDefs(Value: TIndexDefs);
    procedure SetIndex(const Value: string; FieldsIndex: Boolean);
    procedure SetIndexFieldNames(const Value: string);
    procedure SetIndexFiles(Value: TStrings);
    procedure SetIndexName(const Value: string);
    procedure SetMasterFields(const Value: string);
    procedure SetReadOnly(Value: Boolean);
    procedure SetTableLock(LockType: TLockType; Lock: Boolean);
    procedure SetTableName(const Value: TFileName);
    procedure SetTableType(Value: TTableType);
    function SetTempLocale(ActiveCheck: Boolean): TLocale;
    procedure RestoreLocale(LocaleSave: TLocale);
    procedure UpdateRange;
  protected
    { IProviderSupport }
    function PSGetCommandText: string; override;
    function PSGetCommandType: TPSCommandType; override;
    function PSGetDefaultOrder: TIndexDef; override;
    function PSGetKeyFields: string; override;
    function PSGetTableName: string; override;
    function PSGetIndexDefs(IndexTypes: TIndexOptions): TIndexDefs; override;
    procedure PSSetCommandText(const CommandText: string); override;
    procedure PSSetParams(AParams: TParams); override;
  protected
    function CreateHandle: HDBICur; override;
    procedure DataEvent(Event: TDataEvent; Info: TObject); override;
    procedure DefChanged(Sender: TObject); override;
    procedure DestroyHandle; override;
    procedure DestroyLookupCursor; override;
    procedure DoOnNewRecord; override;
    procedure EncodeFieldDesc(var FieldDesc: BDEFLDDesc;
      const Name: string; DataType: TFieldType; Size, Precision: Integer);
    procedure EncodeIndexDesc(var IndexDesc: IDXDesc;
      const Name, FieldExpression: string; Options: TIndexOptions;
      const DescFields: string = '');
    function GetCanModify: Boolean; override;
    function GetDataSource: TDataSource; override;
    function GetHandle(const IndexName, IndexTag: string): HDBICur;
    function GetLanguageDriverName: string;
    function GetLookupCursor(const KeyFields: string;
      CaseInsensitive: Boolean): HDBICur; override;
    procedure InitFieldDefs; override;
    function GetFileName: string;
    function GetTableType: TTableType;
    function IsProductionIndex(const IndexName: string): Boolean;
    function NativeTableName: string;
    procedure PrepareCursor; override;
    procedure UpdateIndexDefs; override;
    property MasterLink: TMasterDataLink read FMasterLink;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function BatchMove(ASource: TBDEDataSet; AMode: TBatchMode): Longint;
    procedure AddIndex(const Name, Fields: string; Options: TIndexOptions;
      const DescFields: string = '');
    procedure ApplyRange;
    procedure CancelRange;
    procedure CloseIndexFile(const IndexFileName: string);
    procedure CreateTable;
    procedure DeleteIndex(const Name: string);
    procedure DeleteTable;
    procedure EditKey;
    procedure EditRangeEnd;
    procedure EditRangeStart;
    procedure EmptyTable;
    function FindKey(const KeyValues: array of const): Boolean;
    procedure FindNearest(const KeyValues: array of const);
    procedure GetDetailLinkFields(MasterFields, DetailFields: TObjectList); override;
    procedure GetIndexNames(List: TStrings);
    procedure GotoCurrent(Table: TTable);
    function GotoKey: Boolean;
    procedure GotoNearest;
    procedure LockTable(LockType: TLockType);
    procedure OpenIndexFile(const IndexName: string);
    procedure RenameTable(const NewTableName: string);
    procedure SetKey;
    procedure SetRange(const StartValues, EndValues: array of const);
    procedure SetRangeEnd;
    procedure SetRangeStart;
    procedure UnlockTable(LockType: TLockType);
    property Exists: Boolean read GetExists;
    property IndexFieldCount: Integer read GetIndexFieldCount;
    property IndexFields[Index: Integer]: TField read GetIndexField write SetIndexField;
    property KeyExclusive: Boolean read GetKeyExclusive write SetKeyExclusive;
    property KeyFieldCount: Integer read GetKeyFieldCount write SetKeyFieldCount;
    property TableLevel: Integer read GetTableLevel write FTableLevel;
  published
    property Constraints stored ConstraintsStored;
    property DefaultIndex: Boolean read FDefaultIndex write FDefaultIndex default True;
    property Exclusive: Boolean read FExclusive write SetExclusive default False;
    property FieldDefs stored FieldDefsStored;
    property IndexDefs: TIndexDefs read FIndexDefs write SetIndexDefs stored IndexDefsStored;
    property IndexFieldNames: string read GetIndexFieldNames write SetIndexFieldNames;
    property IndexFiles: TStrings read FIndexFiles write SetIndexFiles;
    property IndexName: string read GetIndexName write SetIndexName;
    property MasterFields: string read GetMasterFields write SetMasterFields;
    property MasterSource: TDataSource read GetDataSource write SetDataSource;
    property ReadOnly: Boolean read FReadOnly write SetReadOnly default False;
    property StoreDefs: Boolean read FStoreDefs write FStoreDefs default False;
    property TableName: TFileName read FTableName write SetTableName;
    property TableType: TTableType read FTableType write SetTableType default ttDefault;
    property UpdateMode;
    property UpdateObject;
    property Ranged: Boolean read FRanged;
  end;

{ TBatchMove }

  [RootDesignerSerializerAttribute('', '', False)]
  TBatchMove = class(TComponent)
  private
    FDestination: TTable;
    FSource: TBDEDataSet;
    FMode: TBatchMode;
    FAbortOnKeyViol: Boolean;
    FAbortOnProblem: Boolean;
    FTransliterate: Boolean;
    FRecordCount: Longint;
    FMovedCount: Longint;
    FKeyViolCount: Longint;
    FProblemCount: Longint;
    FChangedCount: Longint;
    FMappings: TStrings;
    FKeyViolTableName: TFileName;
    FProblemTableName: TFileName;
    FChangedTableName: TFileName;
    FCommitCount: Integer;
    function ConvertName(const Name: string): string;
    procedure SetMappings(Value: TStrings);
    procedure SetSource(Value: TBDEDataSet);
  protected
    procedure Notification(AComponent: TComponent;
      Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Execute;
  public
    property ChangedCount: Longint read FChangedCount;
    property KeyViolCount: Longint read FKeyViolCount;
    property MovedCount: Longint read FMovedCount;
    property ProblemCount: Longint read FProblemCount;
  published
    property AbortOnKeyViol: Boolean read FAbortOnKeyViol write FAbortOnKeyViol default True;
    property AbortOnProblem: Boolean read FAbortOnProblem write FAbortOnProblem default True;
    property CommitCount: Integer read FCommitCount write FCommitCount default 0;
    property ChangedTableName: TFileName read FChangedTableName write FChangedTableName;
    property Destination: TTable read FDestination write FDestination;
    property KeyViolTableName: TFileName read FKeyViolTableName write FKeyViolTableName;
    property Mappings: TStrings read FMappings write SetMappings;
    property Mode: TBatchMode read FMode write FMode default batAppend;
    property ProblemTableName: TFileName read FProblemTableName write FProblemTableName;
    property RecordCount: Longint read FRecordCount write FRecordCount default 0;
    property Source: TBDEDataSet read FSource write SetSource;
    property Transliterate: Boolean read FTransliterate write FTransliterate default True;
  end;

{ TStoredProc }

  TParamBindMode = (pbByName, pbByNumber);

  TServerDesc = record
    ParamName: string[DBIMAXSPNAMELEN];
    BindType: TFieldType;
  end;

  TServerDescList = array of TServerDesc;
  TSPParamDescList = array of BDESPParamDesc;

  TStoredProc = class(TDBDataSet)
  private
    FProcName: string;
    FParams: TParams;
    FParamDescs: TSPParamDescList;
    FServerDescs: TServerDescList;
    FRecBufSize: Integer;
    FRecordBuffer: TRecordBuffer;
    FOverLoad: Word;
    FPrepared: Boolean;
    FQueryMode: Boolean;
    FBindMode: TParamBindMode;
    procedure BindParams;
    function CheckServerParams: Boolean;
    function CreateCursor(GenHandle: Boolean): HDBICur;
    procedure CreateParamDesc;
    procedure FreeStatement;
    function GetCursor(GenHandle: Boolean): HDBICur;
    procedure PrepareProc;
    procedure ReadParamData(Reader: TReader);
    procedure SetParamsList(Value: TParams);
    procedure SetServerParams;
    procedure WriteParamData(Writer: TWriter);
  protected
    { IProviderSupport }
    procedure PSExecute; override;
    function PSGetCommandText: string; override;
    function PSGetCommandType: TPSCommandType; override;
    function PSGetTableName: string; override;
    function PSGetParams: TParams; override;
    procedure PSSetCommandText(const CommandText: string); override;
    procedure PSSetParams(AParams: TParams); override;
  protected
    function CreateHandle: HDBICur; override;
    procedure DefineProperties(Filer: TFiler); override;
    procedure Disconnect; override;
    function GetParamsCount: Word;
    function SetDBFlag(Flag: Integer; Value: Boolean): Boolean; override;
    procedure SetOverLoad(Value: Word);
    procedure SetProcName(const Value: string);
    procedure SetPrepared(Value: Boolean);
    procedure SetPrepare(Value: Boolean);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure CopyParams(Value: TParams);
    function DescriptionsAvailable: Boolean;
    procedure ExecProc;
    function ParamByName(const Value: string): TParam;
    procedure Prepare;
    procedure GetResults;
    procedure UnPrepare;
    property Handle: HDBICur read GetHandle;
    property ParamCount: Word read GetParamsCount;
    property StmtHandle;
    property Prepared: Boolean read FPrepared write SetPrepare;
  published
    property StoredProcName: string read FProcName write SetProcName;
    property Overload: Word read FOverload write SetOverload default 0;
    property Params: TParams read FParams write SetParamsList stored False;
    property ParamBindMode: TParamBindMode read FBindMode write FBindMode default pbByName;
    property UpdateObject;
  end;

{ TQuery }

  TQuery = class(TDBDataSet)
  private
    FSQL: TStrings;
    FPrepared: Boolean;
    FParams: TParams;
    FText: string;
    FDataLink: TDataLink;
    FLocal: Boolean;
    FRowsAffected: Integer;
    FUniDirectional: Boolean;
    FRequestLive: Boolean;
    FSQLBinary: TBytes;
    FConstrained: Boolean;
    FParamCheck: Boolean;
    FExecSQL: Boolean;
    FCheckRowsAffected: Boolean;
    function CreateCursor(GenHandle: Boolean): HDBICur;
    function GetQueryCursor(GenHandle: Boolean): HDBICur;
    function GetRowsAffected: Integer;
    procedure PrepareSQL(Value: string);
    procedure QueryChanged(Sender: TObject);
    procedure ReadBinaryData(Stream: TStream);
    procedure ReadParamData(Reader: TReader);
    procedure RefreshParams;
    procedure SetDataSource(Value: TDataSource);
    procedure SetQuery(Value: TStrings);
    procedure SetParamsList(Value: TParams);
    procedure SetParamsFromCursor;
    procedure SetPrepared(Value: Boolean);
    procedure SetPrepare(Value: Boolean);
    procedure WriteBinaryData(Stream: TStream);
    procedure WriteParamData(Writer: TWriter);
  protected
    { IProviderSupport }
    procedure PSExecute; override;
    function PSGetCommandText: string; override;
    function PSGetCommandType: TPSCommandType; override;
    function PSGetDefaultOrder: TIndexDef; override;
    function PSGetParams: TParams; override;
    function PSGetTableName: string; override;
    procedure PSSetCommandText(const CommandText: string); override;
    procedure PSSetParams(AParams: TParams); override;
  protected
    function CreateHandle: HDBICur; override;
    procedure DefineProperties(Filer: TFiler); override;
    procedure Disconnect; override;
    procedure FreeStatement; virtual;
    function GetDataSource: TDataSource; override;
    function GetParamsCount: Word;
    function SetDBFlag(Flag: Integer; Value: Boolean): Boolean; override;
    procedure GetStatementHandle(SQLText: string); virtual;
    property DataLink: TDataLink read FDataLink;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure ExecSQL;
    procedure GetDetailLinkFields(MasterFields, DetailFields: TObjectList); override;
    function ParamByName(const Value: string): TParam;
    procedure Prepare;
    procedure UnPrepare;
    property Prepared: Boolean read FPrepared write SetPrepare;
    property ParamCount: Word read GetParamsCount;
    property Local: Boolean read FLocal;
    property StmtHandle;
    property Text: string read FText;
    property RowsAffected: Integer read GetRowsAffected;
    property SQLBinary: TBytes read FSQLBinary write FSQLBinary;
  published
    property Constrained: Boolean read FConstrained write FConstrained default False;
    property Constraints stored ConstraintsStored;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property ParamCheck: Boolean read FParamCheck write FParamCheck default True;
    property RequestLive: Boolean read FRequestLive write FRequestLive default False;
    property SQL: TStrings read FSQL write SetQuery;
    { This property must be listed after the SQL property for Delphi 1.0 compatibility }
    property Params: TParams read FParams write SetParamsList stored False;
    property UniDirectional: Boolean read FUniDirectional write FUniDirectional default False;
    property UpdateMode;
    property UpdateObject;
end;

{ TUpdateSQL }

  TUpdateSQL = class(TSQLUpdateObject)
  private
    FDataSet: TDataSet;
    FDatabaseName: string;
    FSessionName: string;
    FQueries: array[TUpdateKind] of TQuery;
    FSQLText: array[TUpdateKind] of TStrings;
    function GetQuery(UpdateKind: TUpdateKind): TQuery;
    function GetSQLIndex(Index: Integer): TStrings;
    procedure SetSQL(UpdateKind: TUpdateKind; Value: TStrings);
    procedure SetSQLIndex(Index: Integer; Value: TStrings);
  protected
    function GetSQL(UpdateKind: TUpdateKind): TStrings; override;
    function GetDataSet: TDataSet; override;
    procedure SetDataSet(ADataSet: TDataSet); override;
    procedure SQLChanged(Sender: TObject);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Apply(UpdateKind: TUpdateKind); overload; override;
    procedure Apply(ADataset: TDataset; UpdateKind: TUpdateKind); reintroduce; overload;
    procedure ExecSQL(UpdateKind: TUpdateKind); virtual;
    procedure SetParams(ADataset: TDataset; UpdateKind: TUpdateKind); overload; virtual;
    procedure SetParams(UpdateKind: TUpdateKind); overload; virtual;
    property DatabaseName: string read FDatabaseName write FDatabaseName;
    property DataSet;
    property Query[UpdateKind: TUpdateKind]: TQuery read GetQuery;
    property SQL[UpdateKind: TUpdateKind]: TStrings read GetSQL write SetSQL;
    property SessionName: string read FSessionName write FSessionName;
  published
    property ModifySQL: TStrings index 0 read GetSQLIndex write SetSQLIndex;
    property InsertSQL: TStrings index 1 read GetSQLIndex write SetSQLIndex;
    property DeleteSQL: TStrings index 2 read GetSQLIndex write SetSQLIndex;
  end;

{ TBlobStream }

  TBlobStream = class(TStream)
  private
    FField: TBlobField;
    FDataSet: TBDEDataSet;
    FBuffer: TRecordBuffer;
    FMode: TBlobStreamMode;
    FFieldNo: Integer;
    FOpened: Boolean;
    FModified: Boolean;
    FPosition: Longint;
    FBlobData: TBlobBytes;  
    FCached: Boolean;
    FCacheSize: Longint;
    function GetBlobSize: Longint;
  protected
    procedure SetSize(NewSize: Int64); override;
  public
    constructor Create(Field: TBlobField; Mode: TBlobStreamMode);
    destructor Destroy; override;
    function Read(var Buffer: array of Byte; Offset, Count: Longint): Longint; override;
    function Write(const Buffer: array of Byte; Offset, Count: Longint): Longint; override;
    function Seek(const Offset: Int64; Origin: TSeekOrigin): Int64; override;
    procedure Truncate;
  end;

function AnsiToNative(Locale: TLocale; const AnsiStr: string;
  var NativeStr: string; MaxLen: Integer): string; overload; deprecated;
function AnsiToNative(Locale: TLocale; const AnsiStr: string;
  MaxLen: Integer): string; overload;
procedure NativeToAnsi(Locale: TLocale; const NativeStr: string;
  var AnsiStr: string);

procedure AnsiToNativeBuf(Locale: TLocale; const Source: string;
  var Dest: string; Len: Integer); overload;
procedure AnsiToNativeBuf(Locale: TLocale; const Source: array of Byte;
  var Dest: array of Byte; Len: Integer); overload;

procedure NativeToAnsiBuf(Locale: TLocale; const Source: string;
  var Dest: string; Len: Integer); overload;
procedure NativeToAnsiBuf(Locale: TLocale; const Source: array of Byte;
  var Dest: array of Byte; Len: Integer); overload;
procedure NativeToAnsiBuf(Locale: TLocale; Source: IntPtr;
  Dest: IntPtr; Len: Integer); overload;

function NativeCompareStr(Locale: TLocale; const S1, S2: string; Len: Integer): Integer;
function NativeCompareStrBuf(Locale: TLocale; const S1, S2: string; Len: Integer): Integer;
function NativeCompareText(Locale: TLocale; const S1, S2: string; Len: Integer): Integer;
function NativeCompareTextBuf(Locale: TLocale; const S1, S2: string; Len: Integer): Integer;

function GetFieldSource(ADataSet: TDataSet; var ADataSources: DataSources): Boolean;

procedure DbiError(ErrorCode: DBIResult);
procedure Check(Status: DBIResult);
procedure RegisterBDEInitProc(const InitProc: TBDEInitProc);

const
  { Backward compatibility for TConfigMode }
  cmVirtual = [cfmVirtual];
  cmPersistent = [cfmPersistent];
  cmSession = [cfmSession];
  cmAll = [cfmVirtual, cfmPersistent, cfmSession];

var
  Session: TSession;
  Sessions: TSessionList;
  //GetObjectContextProc: function: IUnknown;

implementation

uses  System.Text, System.Runtime.InteropServices, System.Threading, System.IO,
  WinUtils, ActiveX, DBConsts, BDEConst;

const
  TableTypeDriverNames: array[TTableType] of AnsiString =
    (szPARADOX, szPARADOX, szDBASE, szFOXPRO, szASCII);
  OpenModes: array[Boolean] of DbiOpenMode = (dbiReadWrite, dbiReadOnly);
  ShareModes: array[Boolean] of DbiShareMode = (dbiOpenShared, dbiOpenExcl);

  // Place holders for support functions not yet implemented
  GDAL: LongWord = 0;                              

{ TBDEBufferList }

type
  TBDEBufferList = class(TDBBufferList)
  private
    FFinalizeNotify: TFinalizeNotifyProc;
    FSessionList: TSessionList;
    procedure FinalizeNotify;
  strict protected
    procedure Finalize; override;
  public
    constructor Create(SessionList: TSessionList);
  end;

constructor TBDEBufferList.Create(SessionList: TSessionList);
begin
  inherited Create;
  FSessionList := SessionList;
  FFinalizeNotify := @FinalizeNotify;
  FSessionList.RegisterFinalizeNotify(FFinalizeNotify, fnAfterFinalizeList);
end;

procedure TBDEBufferList.Finalize;
begin
  if Assigned(FSessionList) then
  begin
    FSessionList.UnregisterFinalizeNotify(FFinalizeNotify, fnAfterFinalizeList);
    FSessionList := nil;
  end;
  inherited;
end;

procedure TBDEBufferList.FinalizeNotify;
begin
  FreeList;
  FSessionList := nil;
end;

{ TTimerWrapper }

type
  TTimerWrapper = class(TObject)
  private
    FTimerID: Word;
  strict protected
    procedure Finalize; override;
  public
    property TimerID: Word read FTimerID write FTimerID;
  end;

procedure TTimerWrapper.Finalize;
begin
  if FTimerID <> 0 then KillTimer(0, FTimerID);
  inherited;
end;

var
  FCSect: TObject;
  CSNativeToAnsi: TObject;
  CSAnsiToNative: TObject;
  Timer: TTimerWrapper;
  SQLDelay: DWORD = 50;
  StartTime: DWORD = 0;
  BDEInitProcs: TList;
  BDEBuffers: TBDEBufferList;

procedure TimerCallBack(hWnd: HWND; Message, TimerID: UInt;
  SysTime: DWORD); forward;

const
  TimerCallBackDelegate: TFNTimerProc = TimerCallBack;

[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharToOemBuffA')]
function _CharToOemBuffA(lpszSrc, lpszDst: array of Byte; cchDstLength: DWORD): BOOL; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OemToCharBuffA')]
function _OemToCharBuffA(lpszSrc, lpszDst: array of Byte; cchDstLength: DWORD): BOOL; overload; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OemToCharBuffA')]
function _OemToCharBuffA(lpszSrc, lpszDst: IntPtr; cchDstLength: DWORD): BOOL; overload; external;
[DllImport(user32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CharToOemA')]
function _CharToOemA(lpszSrc, lpszDst: IntPtr): BOOL; external;

{ TQueryDataLink }

type
  TQueryDataLink = class(TDetailDataLink)
  private
    FQuery: TQuery;
  protected
    procedure ActiveChanged; override;
    procedure RecordChanged(Field: TField); override;
    function GetDetailDataSet: TDataSet; override;
    procedure CheckBrowseMode; override;
  public
    constructor Create(AQuery: TQuery);
  end;

{ Utility routines }

function DefaultSession: TSession;
begin
  Result := Borland.Vcl.DBTables.Session;
end;

procedure RegisterBDEInitProc(const InitProc: TBDEInitProc);
begin
  if not Assigned(BDEInitProcs) then
    BDEInitProcs := TList.Create;
  BDEInitProcs.Add(@InitProc);
end;

procedure CheckIndexOpen(Status: DBIResult);
begin
  if (Status <> 0) and (Status <> DBIERR_INDEXOPEN) then
    DbiError(Status);
end;

function GetFieldSource(ADataSet: TDataSet; var ADataSources: DataSources): Boolean;
var
  CurrentStr: string;
  Current: Integer;
  Field: TField;
  Values: array[0..4] of string;
  I: Integer;

  procedure Split(const S: string);
  begin
    CurrentStr := S + #0;
    Current := 1;
  end;

  function NextItem: string;
  var
    C: Integer;
    Terminator: AnsiChar;
    Ident: StringBuilder;
  begin
    Result := '';
    C := Current;
    Ident := StringBuilder.Create(1024);
    while (CurrentStr[C] in ['.',' ',#0]) do
      if CurrentStr[C] = #0 then
        Exit
      else
        Inc(C);
    Terminator := '.';
    if CurrentStr[C] = '"' then
    begin
      Terminator := '"';
      Inc(C);
    end;
    while not (CurrentStr[C] in [Terminator, #0]) do
    begin
                       
      {if CurrentStr[C] in LeadBytes then
      begin
        Ident.Append(CurrentStr[C]);
        Inc(C);
      end
      else }
        if CurrentStr[C] = '\' then
        begin
          Inc(C);
                           
          {if CurrentStr[C] in LeadBytes then
          begin
            Ident.Append(CurrentStr[C]);
            Inc(C);
          end; }
          if CurrentStr[C] = #0 then
            Dec(C);
        end;
      Ident.Append(CurrentStr[C]);
      Inc(C);
    end;
    Result := Ident.ToString;
    if (Terminator = '"') and (CurrentStr[C] <> #0) then
      Inc(C);
    Current := C;
  end;

  function PopValue: string;
  begin
    if I >= 0 then
    begin
      Result := Values[I];
      Dec(I);
    end
    else
      Result := '';
  end;

begin
  Result := False;
  Field := ADataSet.FindField(ADataSources.szSourceFldName);
  if (Field = nil) or (Field.Origin = '') then Exit;
  Split(Field.Origin);
  I := -1;
  repeat
    Inc(I);
    Values[I] := NextItem;
  until (Values[I] = '') or (I = High(Values));
  if I = High(Values) then Exit;
  Dec(I);
  ADataSources.szOrigFldName := PopValue;
  ADataSources.szTblName := PopValue;
  ADataSources.szDbName := PopValue;
  Result := (Length(ADataSources.szOrigFldName) <> 0) and
    (Length(ADataSources.szTblName) <> 0);
end;

procedure ApplicationHandleException(Sender: TObject);
begin
  if Assigned(Classes.ApplicationHandleException) then
    Classes.ApplicationHandleException(Sender);
end;

{ Parameter binding routines }

function GetParamDataSize(Param: TParam): Integer;
begin
  with Param do
    if ((DataType in [ftString, ftFixedChar]) and (Length(VarToStr(Value)) > 255)) or
       (DataType in [ftBlob..ftTypedBinary,ftOraBlob,ftOraClob]) then
      Result := Marshal.SizeOf(TypeOf(BlobParamDesc))
    else
      Result := GetDataSize;
end;

function GetParamData(Param: TParam; Buffer: TRecordBuffer;
  const DrvLocale: TLocale): IntPtr;
var
  LocaleBuf, NativeBuf: TBytes;
  I, Len: Integer;

  function GetNativeStr: string;
  begin
    Param.NativeStr := VarToStr(Param.Value);
    Result := Param.NativeStr;
    if DrvLocale <> nil then
      AnsiToNativeBuf(DrvLocale, Result, Result, Length(Result));
  end;

begin
  Result := nil;
  with Param do
    if DataType in [ftString, ftFixedChar, ftMemo]  then
    begin
      NativeStr := VarToStr(Value);
      NativeBuf := BytesOf(NativeStr);
      if (Length(NativeStr) > 255) or (DataType = ftMemo) then
      begin
        with Marshal do
        begin
          if DrvLocale <> nil then
          begin
            SetLength(LocaleBuf, Length(NativeBuf));
            AnsiToNativeBuf(DrvLocale, NativeBuf, LocaleBuf, Length(NativeBuf));
          end;
          Result := BDEBuffers.StringToHGlobalAnsi(StringOf(LocaleBuf));
          WriteIntPtr(Buffer, Result);
          WriteInt32(Buffer, 4, Length(LocaleBuf));
        end;
      end else
      begin
        if (DrvLocale <> nil) then
        begin
          SetLength(LocaleBuf, Length(NativeBuf));
          AnsiToNativeBuf(DrvLocale, NativeBuf, LocaleBuf, Length(NativeBuf) + 1);
          Len := Length(LocaleBuf);
          Marshal.Copy(LocaleBuf, 0, Buffer, Len);
          Marshal.WriteByte(Buffer, Len, 0); // add null terminator
        end
        else
          GetData(Buffer);
      end;
    end
    else if (DataType in [ftBlob..ftTypedBinary,ftOraBlob,ftOraClob]) then
    begin
      with Marshal do
      begin
        NativeStr := VarToStr(Value);
        Result := BDEBuffers.AllocHGlobal(Length(NativeStr));
        Copy(BytesOf(NativeStr), 0, Result, Length(NativeStr));
        WriteIntPtr(Buffer, Result);
        WriteInt32(Buffer, 4, Length(NativeStr));
      end;
    end else
      GetData(Buffer);
end;

function GetStatementLocale(StmtHandle: HDBIStmt): TLocale;
var
  DrvName: StringBuilder;
  NumBytes: Word;
begin
  Result := nil;
  DrvName := StringBuilder.Create(DBIMAXNAMELEN + 1);
  DbiGetProp(HDBIOBJ(StmtHandle), stmtLANGDRVNAME, DrvName, DrvName.Capacity, NumBytes);
  if DrvName.Length > 0 then OsLdLoadBySymbName(DrvName.ToString, Result);
end;

procedure FreeStatementLocale(var Value: TLocale);
begin
  if Value <> nil then OsLdUnloadObj(Value);
  Value := nil;
end;

{ Any fixes made to this utility procedure should also be investigated for the
  TStoredProcedure. }
procedure SetQueryParams(Sender: TComponent; StmtHandle: HDBIStmt; Params: TParams);
var
  I: Integer;
  NumBytes: Word;
  FieldDescs: TFieldDescList;
  FieldDescBuf: IntPtr;
  RecBuffer: TRecordBuffer;
  CurPtr, NullPtr: TRecordBuffer;
  DrvLocale: TLocale;
  ParamDataBuf: IntPtr;
begin
  SetLength(FieldDescs, Params.Count);
  NumBytes := SizeOf(SmallInt);
  for I := 0 to Params.Count - 1 do
    Inc(NumBytes, GetParamDataSize(Params[I]));
  RecBuffer := Marshal.AllocHGlobal(NumBytes);
  NullPtr := IntPtr(Longint(RecBuffer.ToInt32 + NumBytes - SizeOf(SmallInt)));
  Marshal.WriteInt16(NullPtr, -1);
  CurPtr := RecBuffer;
  try
    DrvLocale := GetStatementLocale(StmtHandle);
    try
      for I := 0 to Params.Count - 1 do
        with FieldDescs[I], Params[I] do
        begin
          iFldType := FldTypeMap[DataType];
          if iFldType in [fldBlob, fldZString] then
            iSubType := FldSubTypeMap[DataType]
          else if iFldType = fldUNKNOWN then
            DatabaseErrorFmt(SNoParameterValue, [Name], Sender);
          iFldNum := I + 1;
          iLen := GetParamDataSize(Params[I]);
          ParamDataBuf := GetParamData(Params[i], CurPtr, DrvLocale);
          iOffset := Longint(CurPtr) - Longint(RecBuffer);
          if IsNull then
            iNullOffset := Longint(NullPtr) - Longint(RecBuffer)
          else if iFldType = fldZString then
            iUnits1 := GetDataSize - 1 {Do not include null terminator}
          else if iFldType = fldBYTES then
            iUnits1 := GetDataSize
          else if iFldType = fldVARBYTES then
            iUnits1 := GetDataSize - 2
          else if iFldType = fldBlob then
            iSubType := FldSubTypeMap[DataType];
          CurPtr := IntPtr(Longint(CurPtr.ToInt32 + iLen));
        end;
      FieldDescBuf := ArrayToNativeBuf(FieldDescs);
      try
        Check(DbiQSetParams(StmtHandle, High(FieldDescs) + 1,
          FieldDescBuf, RecBuffer));
      finally
        Marshal.FreeHGlobal(FieldDescBuf);
      end;
    finally
      FreeStatementLocale(DrvLocale);
      if ParamDataBuf <> nil then
        Marshal.FreeHGlobal(ParamDataBuf);
    end;
  finally
    Marshal.FreeHGlobal(RecBuffer);
  end;
end;

{ Timer callback function }

procedure FreeTimer(ResetCursor, ForceKill: Boolean); overload;
begin
  if Assigned(Timer) then
    if (Timer.TimerID <> 0) and (ForceKill or (GetTickCount - StartTime > SQLDelay)) then
    begin
      KillTimer(0, Timer.TimerID);
      Timer.TimerID := 0;
      System.GC.SuppressFinalize(Timer);
      FreeAndNil(Timer);
      StartTime := 0;
      if ResetCursor and Assigned(DBScreen) then
        DBScreen.Cursor := dcrDefault;
    end;
end;

procedure FreeTimer(ForceKill: Boolean = False); overload;
begin
  FreeTimer(True, ForceKill);
end;

procedure TimerCallBack(hWnd: HWND; Message, TimerID: UInt; SysTime: DWORD);
begin
  FreeTimer;
end;

{ BdeCallbacks }

function DLLDetachCallBack(CallType: CBType; Data: Integer; CBInfo: IntPtr): CBRType;
begin
  Session.FHandle.FDLLDetach := True;
  Sessions.CloseAll;
  Result := cbrUSEDEF
end;

[DllImport('idapi32.dll', CharSet = CharSet.Ansi, EntryPoint = 'DbiGetCallBack')]
function _DbiGetCallBack(hCursor: hDBICur; ecbType: CBType;
  var piClientData: Integer; var piCbBufLen: Word; var ppCbBuf: IntPtr;
  var pfCb: IntPtr): DBIResult; external;

const
  DLLDetachCBDelegate: pfDBICallBack = DLLDetachCallBack;

constructor TBDECallback.Create(AOwner: TObject; Handle: hDBICur; CBType: CBType;
  CBBuf: IntPtr; CBBufSize: Integer; CallbackEvent: TBDECallbackEvent;
  Chain: Boolean);
var
  LOldCBFuncPtr: IntPtr;
begin
  inherited Create;
  FOwner := AOwner;
  FHandle := Handle;
  FCBType := CBType;
  FCBBuf := CBBuf;
  FCallbackEvent := CallbackEvent;
  FCallBackDelegate := CallBack;
  try
    DbiGetCallBack(Handle, FCBType, FOldCBData, FOldCBBufLen, FOldCBBuf, FOldCBFunc);
  except
    on System.ArgumentException do
    begin
      // At design time a callback may have been registered from the
      // native designer. It will cause an ArgumentException and we need
      // to retrieve the callback as an IntPtr instead of a delegate.
      _DbiGetCallBack(Handle, FCBType, FOldCBData, FOldCBBufLen, FOldCBBuf, LOldCBFuncPtr);
      if not Assigned(LOldCBFuncPtr) then
        raise;
    end;
  end;
  if (not Assigned(LOldCBFuncPtr)) and (not Assigned(FOldCBFunc) or Chain) then
  begin
    Check(DbiRegisterCallback(FHandle, FCBType, 0, CBBufSize, CBBuf, FCallBackDelegate));
    FInstalled := True;
  end;
end;

destructor TBDECallback.Destroy;
begin
  if FInstalled then
  begin
    if FCBBuf <> nil then
    begin
      BDEBuffers.FreeHGlobal(FCBBuf);
      FCBBuf := nil;
    end;
    if Assigned(FOldCBFunc) then
    try
      DbiRegisterCallback(FHandle, FCBType, FOldCBData, FOldCBBufLen,
        FOldCBBuf, FOldCBFunc);
    except
    end
    else
      DbiRegisterCallback(FHandle, FCBType, 0, 0, nil, nil);
  end;
end;

function TBDECallback.CallBack(CallType: CBType; Data: Integer; CBInfo: IntPtr): CBRType;
begin
  Result := Invoke(CallType, CBInfo);
end;

function TBDECallback.Invoke(CallType: CBType; CBInfo: IntPtr): CBRType;
begin
  if CallType = FCBType then
    Result := FCallbackEvent(CBInfo)
  else
    Result := cbrUSEDEF;
  if Assigned(FOldCBFunc) then
    Result := FOldCBFunc(CallType, FOldCBData, CBInfo);
end;

{ Utility routines }

function StrToOem(const AnsiStr: string): string;
var
  Len: Cardinal;
  Buffer: StringBuilder;
begin
  Len := Length(AnsiStr);
  if Len > 0 then
  begin
    Buffer := StringBuilder.Create(Len);
    CharToOemA(AnsiStr, Buffer);
    Result := Buffer.ToString;
  end;
end;

// This overload is provided for backwards compatibility only
function AnsiToNative(Locale: TLocale; const AnsiStr: string;
  var NativeStr: string; MaxLen: Integer): string;
begin
  NativeStr := AnsiToNative(Locale, AnsiStr, MaxLen);
  Result := NativeStr;
end;

function AnsiToNative(Locale: TLocale; const AnsiStr: string; MaxLen: Integer): string;
var
  Len: Integer;
begin
  Len := Length(AnsiStr);
  if Len > MaxLen then
  begin
    Len := MaxLen;
                    
    {if SysLocale.FarEast and (ByteType(AnsiStr, Len) = mbLeadByte) then
      Dec(Len);}
  end;
  if Len > 0 then
    AnsiToNativeBuf(Locale, AnsiStr, Result, Len);
end;

procedure NativeToAnsi(Locale: TLocale; const NativeStr: string;
  var AnsiStr: string);
var
  Len: Integer;
begin
  Len := Length(NativeStr);
  if Len > 0 then
    NativeToAnsiBuf(Locale, NativeStr, AnsiStr, Len);
end;

procedure AnsiToNativeBuf(Locale: TLocale; const Source: string;
  var Dest: string; Len: Integer);
var
  DataLoss: LongBool;
  Buffer: StringBuilder;
begin
  if Len > 0 then
  begin
    Buffer := StringBuilder.Create(Len + 1);
    if Locale <> nil then
    begin
      System.Threading.Monitor.Enter(CSAnsiToNative);
      try
        DbiAnsiToNative(Locale, Buffer, Source, Buffer.Capacity, DataLoss);
      finally
        System.Threading.Monitor.Exit(CSAnsiToNative);
      end;
    end
    else
      CharToOemBuffA(Source, Buffer, Buffer.Capacity);
    Dest := Buffer.ToString;
  end;
end;

procedure AnsiToNativeBuf(Locale: TLocale; const Source: array of Byte;
  var Dest: array of Byte; Len: Integer);
var
  DataLoss: LongBool;
begin
  if Len > 0 then
    if Locale <> nil then
    begin
      System.Threading.Monitor.Enter(CSAnsiToNative);
      try
        DbiAnsiToNative(Locale, Dest, Source, Len, DataLoss);
      finally
        System.Threading.Monitor.Exit(CSAnsiToNative);
      end;
    end
    else
      _CharToOemBuffA(Source, Dest, Len);
end;

procedure NativeToAnsiBuf(Locale: TLocale; const Source: string;
  var Dest: string; Len: Integer);
var
  DataLoss: LongBool;
  Buffer: StringBuilder;
begin
  if Len > 0 then
  begin
    Buffer := StringBuilder.Create(Len + 1);
    if Locale <> nil then
    begin
      System.Threading.Monitor.Enter(CSNativeToAnsi);
      try
        DbiNativeToAnsi(Locale, Buffer, Source, Buffer.Capacity, DataLoss);
      finally
        System.Threading.Monitor.Exit(CSNativeToAnsi);
      end;
    end
    else
      OemToCharBuffA(Source, Buffer, Buffer.Capacity);
    Dest := Buffer.ToString;
  end;
end;

procedure NativeToAnsiBuf(Locale: TLocale; const Source: array of Byte;
  var Dest: array of Byte; Len: Integer);
var
  DataLoss: LongBool;
begin
  if Len > 0 then
    if Locale <> nil then
    begin
      System.Threading.Monitor.Enter(CSNativeToAnsi);
      try
        DbiNativeToAnsi(Locale, Dest, Source, Len, DataLoss);
      finally
        System.Threading.Monitor.Exit(CSNativeToAnsi);
      end;
    end
    else
      _OemToCharBuffA(Source, Dest, Len);
end;

procedure NativeToAnsiBuf(Locale: TLocale; Source: IntPtr;
  Dest: IntPtr; Len: Integer);
var
  DataLoss: LongBool;
begin
  if Len > 0 then
    if Locale <> nil then
    begin
      System.Threading.Monitor.Enter(CSNativeToAnsi);
      try
        DbiNativeToAnsi(Locale, Dest, Source, Len, DataLoss);
      finally
        System.Threading.Monitor.Exit(CSNativeToAnsi);
      end;
    end
    else
      _OemToCharBuffA(Source, Dest, Len);
end;

function NativeCompareStr(Locale: TLocale; const S1, S2: string; Len: Integer): Integer;
begin
  Result := NativeCompareStrBuf(Locale, S1, S2, Len);
end;

function NativeCompareStrBuf(Locale: TLocale; const S1, S2: string; Len: Integer): Integer;
begin
  if Len > 0 then
    Result := OsLdStrnCmp(Locale, S1, S2, Len)
  else
    Result := OsLdStrCmp(Locale, S1, S2);
end;

function NativeCompareText(Locale: TLocale; const S1, S2: string; Len: Integer): Integer;
begin
  Result := NativeCompareTextBuf(Locale, S1, S2, Len);
end;

function NativeCompareTextBuf(Locale: TLocale; const S1, S2: string; Len: Integer): Integer;
begin
  if Len > 0 then
    Result := OsLdStrnCmpi(Locale, S1, S2, Len)
  else
    Result := OsLdStrCmpi(Locale, S1, S2);
end;

function IsDirectory(const DatabaseName: string): Boolean;
var
  I: Integer;
begin
  Result := True;
  if (DatabaseName = '') then Exit;
  I := 1;
  while I <= Length(DatabaseName) do
  begin
    if (DatabaseName[I] in [':','\']) then
      Exit;
                     
    {if DatabaseName[I] in LeadBytes then
      Inc(I, 2)
    else }
      Inc(I);
  end;
  Result := False;
end;

function IsStandardType(AType: string): Boolean;
begin
  Result := SameText(AType, szPARADOX) or SameText(AType, szDBASE) or
    SameText(AType, szFOXPRO);
    { Note: szASCII not included }
end;

function GetIntProp(const Handle: hDBIObj; PropName: Integer): Integer;
var
  Length: Word;
  Value: Integer;
begin
  Value := 0;
  if DbiGetProp(Handle, PropName, Value, SizeOf(Value), Length) = DBIERR_NONE then
    Result := Value
  else
    Result := 0;
end;

function SetBoolProp(const Handle: hDBIObj; PropName: Integer; Value: Bool): Boolean;
begin
  Result := DbiSetProp(Handle, PropName, Abs(Integer(Value))) = DBIERR_NONE;
end;

function StringListToParams(List: TStrings): string;
var
  S: String;
  P, I: Integer;
begin
  for I := 0 to List.Count - 1 do
  begin
    S := List[I];
    P := Pos('=', S);
    if (P >= 0) and (P < Length(S)) then
      Result := Format('%s%s:"%s";', [Result, Copy(S, 1, P-1), Copy(S, P+1, 255)]);
  end;
  Result := StrToOem(Result);
  SetLength(Result, Length(Result) - 1);
end;

procedure DbiError(ErrorCode: DBIResult);
begin
  raise EDBEngineError.Create(ErrorCode);
end;

procedure Check(Status: DBIResult);
begin
  if Status <> 0 then DbiError(Status);
end;

{ TDBError }

constructor TDBError.Create(Owner: EDBEngineError; ErrorCode: DBIResult;
  NativeError: Longint; Message: string);
begin
  inherited Create;
  Owner.FErrors.Add(Self);
  FErrorCode := ErrorCode;
  FNativeError := NativeError;
  FMessage := Message;
end;

function TDBError.GetCategory: Byte;
begin
  Result := Hi(FErrorCode);
end;

function TDBError.GetSubCode: Byte;
begin
  Result := Lo(FErrorCode);
end;

{ EDBEngineError }
type
  TDBErrorCodes = class
    FErrorCode: DBIResult;
    FNativeErr: Longint;
  end;

constructor EDBEngineError.Create(ErrorCode: DBIResult);
var
  ErrorIndex: Integer;
  EntryCode: DBIResult;
  NativeError: Longint;
  ContextBuf: StringBuilder; { DBIMSG }
  Messages: TStrings;
  I: Integer;
  ErrorMsg: string;
  ErrCodes: TDBErrorCodes;

  procedure AddMessage(const Msg: string; ErrorCode: DBIResult; NativeError: Longint);
  var
    ErrCodes: TDBErrorCodes;
  begin
    ErrCodes := TDBErrorCodes.Create;
    ErrCodes.FErrorCode := ErrorCode;
    ErrCodes.FNativeErr := NativeError;
    if (Msg <> '') and (Messages.IndexOf(Msg) = -1) then
      Messages.AddObject(Msg, ErrCodes)
    else if (ErrorCode <> 0) then
      Messages.AddObject('', ErrCodes);
  end;

  function GetErrorString(Code: DBIResult): string;
  var
    Msg: StringBuilder;
  begin
    Msg := StringBuilder.Create(DBIMAXMSGLEN);
    DbiGetErrorString(Code, Msg);
    Result := Trim(Msg.ToString);
  end;

begin
  FreeTimer(True);
  if not DefaultSession.Active and (ErrorCode <> DBIERR_INTERFACEVER) then
  begin
    ErrorMsg := Format(SInitError, [ErrorCode]);
    inherited Create(ErrorMsg);
    FErrors := TList.Create;
    TDBError.Create(Self, ErrorCode, 0, ErrorMsg);
  end
  else
  begin
    Messages := TStringList.Create;
    try
      if ErrorCode <> DBIERR_USERCONSTRERR then
        AddMessage(GetErrorString(ErrorCode), ErrorCode, 0);
      ErrorIndex := 1;
      ContextBuf := StringBuilder.Create(DBIMAXMSGLEN);
      while True do
      begin
        EntryCode := DbiGetErrorEntry(ErrorIndex, NativeError, ContextBuf);
        if (EntryCode = DBIERR_NONE) or (EntryCode = DBIERR_NOTINITIALIZED) then
          Break;
        if (NativeError = 0) and (ErrorCode <> DBIERR_USERCONSTRERR) then
          AddMessage(GetErrorString(EntryCode), 0, 0);
        AddMessage(Trim(ContextBuf.ToString), EntryCode, NativeError);
        ContextBuf.Remove(0, ContextBuf.Length); // clear the buffer
        Inc(ErrorIndex);
      end;
      for I := 0 to Messages.Count - 1 do
      begin
        if Messages.Strings[I] <> '' then
        begin
          ContextBuf.Append(Messages.Strings[I]);
          ContextBuf.Append(sLineBreak);
        end;
      end;
      ErrorMsg := ContextBuf.ToString;
      if ErrorMsg <> '' then
        inherited Create(Copy(ErrorMsg, 1, Length(ErrorMsg)-Length(sLineBreak)))
      else
        inherited Create(Format(SBDEError, [ErrorCode]));
       FErrors := TList.Create;
       for I := 0 to Messages.Count - 1 do
       begin
         ErrCodes := TDBErrorCodes(Messages.Objects[I]);
         if ErrCodes.FErrorCode <> 0 then
           TDBError.Create(self, ErrCodes.FErrorCode, ErrCodes.FNativeErr, Messages.Strings[I]);
       end;
    finally
      Messages.Free;
    end;
  end;
end;

destructor EDBEngineError.Destroy;
var
  I: Integer;
begin
  if FErrors <> nil then
  begin
    for I := FErrors.Count - 1 downto 0 do TDBError(FErrors[I]).Free;
    FErrors.Free;
  end;
  inherited Destroy;
end;

function EDBEngineError.GetError(Index: Integer): TDBError;
begin
  Result := TDBError(FErrors[Index]);
end;

function EDBEngineError.GetErrorCount: Integer;
begin
  Result := FErrors.Count;
end;

{ TSessionList }

constructor TSessionList.Create;
begin
  inherited Create;
  FSessions := TThreadList.Create;
  FSessionNumbers := TBits.Create;
  FCSect := TObject.Create;
end;

destructor TSessionList.Destroy;
begin
  CloseAll;
  FCSect.Free;
  FSessionNumbers.Free;
  FSessions.Free;
  System.GC.SuppressFinalize(Self);
  inherited Destroy;
end;

procedure TSessionList.AddSession(ASession: TSession);
var
  List: TList;
begin
  List := FSessions.LockList;
  try
    if List.Count = 0 then ASession.FHandle.FDefault := True;
    List.Add(ASession);
  finally
    FSessions.UnlockList;
  end;
end;

procedure TSessionList.CloseAll;
var
  I: Integer;
  List: TList;
begin
  List := FSessions.LockList;
  try
    for I := List.Count-1 downto 0 do
      TSession(List[I]).Free;
  finally
    FSessions.UnlockList;
  end;
end;

procedure TSessionList.Finalize;
var
  I: Integer;
begin
  if Assigned(FBeforeFinalizeList) then
  begin
    for I := 0 to FBeforeFinalizeList.Count - 1 do
      TFinalizeNotifyProc(FBeforeFinalizeList[I]);
    FreeAndNil(FBeforeFinalizeList);
  end;
  if Assigned(FAfterFinalizeList) then
  begin
    for I := 0 to FAfterFinalizeList.Count - 1 do
      TFinalizeNotifyProc(FAfterFinalizeList[I]);
    FreeAndNil(FAfterFinalizeList);
  end;
  inherited;
end;

function TSessionList.GetCount: Integer;
var
  List: TList;
begin
  List := FSessions.LockList;
  try
    Result := List.Count;
  finally
    FSessions.UnlockList;
  end;
end;

function TSessionList.GetCurrentSession: TSession;
var
  Handle: HDBISes;
  I: Integer;
  List: TList;
begin
  List := FSessions.LockList;
  try
    Check(DbiGetCurrSession(Handle));
    for I := 0 to List.Count - 1 do
      if TSession(List[I]).Handle = Handle then
      begin
        Result := TSession(List[I]);
        Exit;
      end;
    Result := nil;
  finally
    FSessions.UnlockList;
  end;
end;

function TSessionList.GetSession(Index: Integer): TSession;
var
  List: TList;
begin
  List := FSessions.LockList;
  try
    Result := TSession(List[Index]);
  finally
    FSessions.UnlockList;
  end;
end;

function TSessionList.GetSessionByName(const SessionName: string): TSession;
begin
  if SessionName = '' then
    Result := Session
  else
    Result := FindSession(SessionName);
  if Result = nil then
    DatabaseErrorFmt(SInvalidSessionName, [SessionName]);
end;

function TSessionList.FindSession(const SessionName: string): TSession;
var
  I: Integer;
  List: TList;
begin
  if SessionName = '' then
    Result := Session
  else
  begin
    List := FSessions.LockList;
    try
      for I := 0 to List.Count - 1 do
      begin
        Result := TSession(List[I]);
        if WideCompareText(Result.SessionName, SessionName) = 0 then Exit;
      end;
      Result := nil;
    finally
      FSessions.UnlockList;
    end;
  end;
end;

procedure TSessionList.GetSessionNames(List: TStrings);
var
  I: Integer;
  SList: TList;
begin
  List.BeginUpdate;
  try
    List.Clear;
    SList := FSessions.LockList;
    try
      for I := 0 to SList.Count - 1 do
        with TSession(SList[I]) do
          List.Add(SessionName);
    finally
      FSessions.UnlockList;
    end;
  finally
    List.EndUpdate;
  end;
end;

function TSessionList.OpenSession(const SessionName: string): TSession;
begin
  Result := FindSession(SessionName);
  if Result = nil then
  begin
    Result := TSession.Create(nil);
    Result.SessionName := SessionName;
  end;
  Result.SetActive(True);
end;

procedure TSessionList.RegisterFinalizeNotify(NotifyProc: TFinalizeNotifyProc;
  Kind: TFinalizeNotifyKind);
begin
  if Kind = fnBeforeFinalizeList then
  begin
    if not Assigned(FBeforeFinalizeList) then
      FBeforeFinalizeList := TList.Create;
    FBeforeFinalizeList.Add(@NotifyProc);
  end
  else
  begin
    if not Assigned(FAfterFinalizeList) then
      FAfterFinalizeList := TList.Create;
    FAfterFinalizeList.Add(@NotifyProc);
  end;
end;

procedure TSessionList.SetCurrentSession(Value: TSession);
begin
  Check(DbiSetCurrSession(Value.FHandle.FHandle))
end;

procedure TSessionList.UnregisterFinalizeNotify(NotifyProc: TFinalizeNotifyProc;
  Kind: TFinalizeNotifyKind);
begin
  if Kind = fnBeforeFinalizeList then
  begin
    if Assigned(FBeforeFinalizeList) then
      FBeforeFinalizeList.Remove(@NotifyProc);
  end
  else
  begin
    if Assigned(FAfterFinalizeList) then
      FAfterFinalizeList.Remove(@NotifyProc);
  end;
end;

{ TSessionFinalizer }

constructor TSessionFinalizer.Create(SessionList: TSessionList);
begin
  inherited Create;
  FFinalizeNotify := @FinalizeNotify;
  FSessionList := SessionList;
  FSessionList.RegisterFinalizeNotify(FFinalizeNotify, fnBeforeFinalizeList);
end;

procedure TSessionFinalizer.CallNotifyProcs;
var
  I: Integer;
begin
  if Assigned(FNotifyList) then
  begin
    for I := 0 to FNotifyList.Count - 1 do
      TFinalizeNotifyProc(FNotifyList[I]);
    FreeAndNil(FNotifyList);
  end;
end;

procedure TSessionFinalizer.Finalize;
begin
  if Assigned(FSessionList) then
  begin
    CallNotifyProcs;
    FreeHandle;
    FSessionList.UnregisterFinalizeNotify(FFinalizeNotify, fnBeforeFinalizeList);
    FSessionList := nil;
  end;
  inherited;
end;

procedure TSessionFinalizer.FinalizeNotify;
begin
  FreeHandle;
  FSessionList := nil;
end;

procedure TSessionFinalizer.FreeHandle;
begin
  if FHandle <> nil then
  begin
    if FDefault then
    begin
      if not FDLLDetach then
      begin
        if IsLibrary then
        begin
                                         
          DbiRegisterCallback(nil, cbDETACHNOTIFY, 0, 0, nil {DLLDetachCBDelegate}, nil);
          DbiDLLExit;
        end;
        DbiExit;
      end;
    end
    else
      Check(DbiCloseSession(FHandle));
    FHandle := nil;
  end;
end;

procedure TSessionFinalizer.RegisterFinalizeNotify(NotifyProc: TFinalizeNotifyProc);
begin
  if not Assigned(FNotifyList) then
    FNotifyList := TList.Create;
  FNotifyList.Add(@NotifyProc);
end;

procedure TSessionFinalizer.UnregisterFinalizeNotify(NotifyProc: TFinalizeNotifyProc);
begin
  if Assigned(FNotifyList) then
    FNotifyList.Remove(@NotifyProc);
end;

{ TSession }

constructor TSession.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ValidateAutoSession(AOwner, False);
  FDatabases := TList.Create;
  FCallbacks := TList.Create;
  FKeepConnections := True;
  FSQLHourGlass := True;
  // Must create FHandle before call to Sessions.AddSession
  FHandle := TSessionFinalizer.Create(Sessions);
  Sessions.AddSession(Self);
  FReserved := 0;
  FHandle.FHandle := nil;
end;

destructor TSession.Destroy;
begin
  if FHandle.FHandle <> nil then
    SetActive(False);
  Sessions.FSessions.Remove(Self);
  if Assigned(FHandle) then
  begin
    System.GC.SuppressFinalize(FHandle);
    FHandle.Free;
  end;
  inherited Destroy;
  FDatabases.Free;
  FCallbacks.Free;
end;

procedure TSession.AddAlias(const Name, Driver: string; List: TStrings);
begin
  InternalAddAlias(Name, Driver, List, ConfigMode, True);
end;

procedure TSession.AddDriver(const Name: string; List: TStrings);
var
  Params: string;
  CfgModeSave: TConfigMode;
begin
  Params := StringListToParams(List);
  LockSession;
  try
    CfgModeSave := ConfigMode;
    try
      CheckConfigMode(ConfigMode);
      Check(DbiAddDriver(nil, StrToOem(Name), Params, Bool(-1)));
    finally
      ConfigMode := cfgModeSave;
    end;
  finally
    UnlockSession;
  end;
  DBNotification(dbAddDriver, Name);
end;

procedure TSession.AddDatabase(Value: TDatabase);
begin
  FDatabases.Add(Value);
  DBNotification(dbAdd, Value);
end;

procedure TSession.AddStandardAlias(const Name, Path, DefaultDriver: string);
var
  AliasParams: TStringList;
begin
  AliasParams := TStringList.Create;
  try
    AliasParams.Add(Format('%s=%s', [szCFGDBPATH, Path]));
    AliasParams.Add(Format('%s=%s', [szCFGDBDEFAULTDRIVER, DefaultDriver]));
    AddAlias(Name, szCFGDBSTANDARD, AliasParams);
  finally
    AliasParams.Free;
  end;
end;

procedure TSession.AddPassword(const Password: string);
begin
  LockSession;
  try
    if Password <> '' then
      Check(DbiAddPassword(AnsiToNative(Locale, Password, 255)));
  finally
    UnlockSession;
  end;
end;

procedure TSession.CallBDEInitProcs;
var
  I: Integer;
begin
  if Assigned(BDEInitProcs) then
    for I := 0 to BDEInitProcs.Count - 1 do
      TBDEInitProc(BDEInitProcs[I])(Self);
end;

procedure TSession.CheckInactive;
begin
  if Active then
    DatabaseError(SSessionActive, Self);
end;

procedure TSession.CheckConfigMode(CfgMode: TConfigMode);
begin
  if CfgMode = cmAll then CfgMode := cmPersistent;
  ConfigMode := CfgMode;
end;

procedure TSession.Close;
begin
  SetActive(False);
end;

procedure TSession.CloseDatabase(Database: TDatabase);
begin
  with Database do
  begin
    if FRefCount <> 0 then Dec(FRefCount);
    if (FRefCount = 0) and not KeepConnection then
      if not Temporary then Close else
         if not (csDestroying in ComponentState) then Free;
  end;
end;

procedure TSession.CloseDatabaseHandle(Database: TDatabase);
var
  I: Integer;
  DB: TDatabase;
begin
  for I := 0 to FDatabases.Count - 1 do
  begin
    DB := TDatabase(FDatabases[I]);
    if (DB <> Database) and (DB.Handle <> nil) and
       (WideCompareText(DB.DatabaseName, Database.DatabaseName) = 0) then
      Exit;
  end;
  DbiCloseDatabase(Database.FHandle.FHandle);
end;

function TSession.DBLoginCallback(CBInfo: IntPtr): CBRType;
var
  Database: TDatabase;
  UserName, Password: string;
  AliasParams: TStringList;
  CBDBLogin: TCBDBLogin;
begin
  Result := cbrYES;
  CBDBLogin := TCBDBLogin(Marshal.PtrToStructure(CBInfo, TypeOf(TCBDBLogin)));
  with CBDBLogin do
  try
    if hDB = nil then
    begin
      if not FBDEOwnsLoginCbDb then
      begin
        Database := OpenDatabase(szDbName);
        if not Database.HandleShared then
        begin
          hDb := Database.Handle;
          bCallbackToClose := True;
          Marshal.StructureToPtr(TObject(CBDBLogin), CBInfo, True);
        end
        else
        begin
          CloseDatabase(Database);
          Result := cbrAbort;
        end;
      end
      else
      begin
        AliasParams := TStringList.Create;
        try
          GetAliasParams(szDbName, AliasParams);
          UserName := AliasParams.Values[szUSERNAME];
        finally
          AliasParams.Free;
        end;
        Password := '';
        if Assigned(LoginDialogExProc) then
          if LoginDialogExProc(szDbName, UserName, Password, True) then
          begin
            szPassword := AnsiToNative(Locale, Password, DBIMAXNAMELEN);
            bCallbackToClose := False;
            Marshal.StructureToPtr(TObject(CBDBLogin), CBInfo, True);
          end
          else
            Result := cbrAbort;
      end
    end else
    begin
      Database := FindDatabase(szDbName);
      if Assigned(Database) and (hDB = Database.Handle) then
        CloseDatabase(Database);
    end;
  except
    Result := cbrAbort;
  end;
end;

procedure TSession.DBNotification(DBEvent: TDatabaseEvent; const Param);
begin
  if Assigned(FOnDBNotify) then FOnDBNotify(DBEvent, Param);
end;

procedure TSession.DeleteAlias(const Name: string);
begin
  InternalDeleteAlias(Name, ConfigMode, True);
end;

procedure TSession.DeleteDriver(const Name: string);
begin
  DBNotification(dbDeleteDriver, Name);
  LockSession;
  try
    DbiDeleteDriver(nil, StrToOem(Name), False);
  finally
    UnlockSession;
  end;
end;

procedure TSession.DeleteConfigPath(const Path, Node: string);
var
  CfgPath: string;
begin
  CfgPath := Format(Path, [Node]);
  if DbiCfgPosition(nil, CfgPath) = 0 then
    Check(DbiCfgDropRecord(nil, CfgPath));
end;

procedure TSession.DropConnections;
var
  I: Integer;
begin
  for I := FDatabases.Count - 1 downto 0 do
    with TDatabase(FDatabases[I]) do
      if Temporary and (FRefCount = 0) then Free;
end;

function TSession.FindDatabase(const DatabaseName: string): TDatabase;
var
  I: Integer;
begin
  for I := 0 to FDatabases.Count - 1 do
  begin
    Result := TDatabase(FDatabases[I]);
    if ((Result.DatabaseName <> '') or Result.Temporary) and
      (WideCompareText(Result.DatabaseName, DatabaseName) = 0) then Exit;
  end;
  Result := nil;
end;

function TSession.DoFindDatabase(const DatabaseName: string;
  AOwner: TComponent): TDatabase;
var
  I: Integer;
begin
  if AOwner <> nil then
    for I := 0 to FDatabases.Count - 1 do
    begin
      Result := TDatabase(FDatabases[I]);
      if (Result.Owner = AOwner) and (Result.HandleShared) and
        (WideCompareText(Result.DatabaseName, DatabaseName) = 0) then Exit;
    end;
  Result := FindDatabase(DatabaseName);
end;

function TSession.FindDatabaseHandle(const DatabaseName: string): HDBIDB;
var
  I: Integer;
  DB: TDatabase;
begin
  for I := 0 to FDatabases.Count - 1 do
  begin
    DB := TDatabase(FDatabases[I]);
    if (DB.Handle <> nil) and
       (WideCompareText(DB.DatabaseName, DatabaseName) = 0) and
       DB.HandleShared then
    begin
      Result := DB.Handle;
      Exit;
    end;
  end;
  Result := nil;
end;

function TSession.GetActive: Boolean;
begin
  Result := FHandle.FHandle <> nil;
end;

function TSession.GetAliasDriverName(const AliasName: string): string;
var
  Desc: DBDesc;
  Buffer: StringBuilder;
begin
  LockSession;
  try
    if DbiGetDatabaseDesc(StrToOem(AliasName), Desc) <> 0 then
      DatabaseErrorFmt(SInvalidAliasName, [AliasName]);
  finally
    UnlockSession;
  end;
  Buffer := StringBuilder.Create(DBIMAXNAMELEN + 1);
  OemToCharA(Desc.szDBType, Buffer);
  Result := Buffer.ToString;
end;

procedure TSession.GetAliasNames(List: TStrings);
var
  Cursor: HDBICur;
  Desc: DBDesc;
  Buffer: StringBuilder;
begin
  List.BeginUpdate;
  try
    List.Clear;
    LockSession;
    try
      Check(DbiOpenDatabaseList(Cursor));
    finally
      UnlockSession;
    end;
    try
      Buffer := StringBuilder.Create(DBIMAXNAMELEN + 1);
      while DbiGetNextRecord(Cursor, dbiNOLOCK, Desc, nil) = 0 do
      begin
        OemToCharA(Desc.szName, Buffer);
        List.Add(Buffer.ToString);
      end;
    finally
      DbiCloseCursor(Cursor);
    end;
  finally
    List.EndUpdate;
  end;
end;

procedure TSession.GetAliasParams(const AliasName: string; List: TStrings);
var
  SAlias: DBIName;
  Desc: DBDesc;
  Buffer: StringBuilder;
begin
  List.BeginUpdate;
  try
    List.Clear;
    Buffer := StringBuilder.Create(DBIMAXNAMELEN + 1);
    CharToOemA(Copy(AliasName, 1, DBIMAXNAMELEN), Buffer);
    SAlias := Buffer.ToString;
    LockSession;
    try
      Check(DbiGetDatabaseDesc(SAlias, Desc));
    finally
      UnlockSession;
    end;
    if CompareText(Desc.szDbType, szCFGDBSTANDARD) = 0 then
    begin
      GetConfigParams('\DATABASES\%s\DB INFO', SAlias, List);
      List.Values[szCFGDBTYPE] := '';
    end
    else
      GetConfigParams('\DATABASES\%s\DB OPEN', SAlias, List); 
  finally
    List.EndUpdate;
  end;
end;

procedure TSession.GetConfigParams(const Path, Section: string; List: TStrings);
var
  Cursor: HDBICur;
  ConfigDesc: CFGDesc;
  Buffer: StringBuilder;
begin
  LockSession;
  try
    Check(DbiOpenCfgInfoList(nil, dbiREADONLY, cfgPERSISTENT, Format(Path,
      [Section]), Cursor));
  finally
    UnlockSession;
  end;
  try
    Buffer := StringBuilder.Create(DBIMAXSCFLDLEN);
    while DbiGetNextRecord(Cursor, dbiNOLOCK, ConfigDesc, nil) = 0 do
      with ConfigDesc do
      begin
        OemToCharA(szValue, Buffer);
        List.Add(Format('%s=%s', [szNodeName, Buffer.ToString]));
      end;
  finally
    DbiCloseCursor(Cursor);
  end;
end;

function TSession.GetDatabase(Index: Integer): TDatabase;
begin
  Result := TDatabase(FDatabases[Index]);
end;

function TSession.GetDatabaseCount: Integer;
begin
  Result := FDatabases.Count;
end;

procedure TSession.GetDatabaseNames(List: TStrings);
var
  I: Integer;
  Names: TStringList;
begin
  Names := TStringList.Create;
  try
    Names.Sorted := True;
    GetAliasNames(Names);
    for I := 0 to FDatabases.Count - 1 do
      with TDatabase(FDatabases[I]) do
        if not IsDirectory(DatabaseName) then Names.Add(DatabaseName);
    List.Assign(Names);
  finally
    Names.Free;
  end;
end;

procedure TSession.GetDriverNames(List: TStrings);
var
  Cursor: HDBICur;
  Name: StringBuilder;
begin
  List.BeginUpdate;
  try
    List.Clear;
    List.Add(szCFGDBSTANDARD);
    LockSession;
    try
      Check(DbiOpenDriverList(Cursor));
    finally
      UnlockSession;
    end;
    try
      Name := StringBuilder.Create(DBIMAXNAMELEN + 1);
      while DbiGetNextRecord(Cursor, dbiNOLOCK, Name, nil) = 0 do
        if not IsStandardType(Name.ToString) then
        begin
          OemToCharA(Name.ToString, Name);
          List.Add(Name.ToString);
        end;
    finally
      DbiCloseCursor(Cursor);
    end;
  finally
    List.EndUpdate;
  end;
end;

procedure TSession.GetDriverParams(const DriverName: string;
  List: TStrings);
begin
  List.BeginUpdate;
  try
    List.Clear;
    if CompareText(DriverName, szCFGDBSTANDARD) = 0 then
    begin
      List.Add(Format('%s=', [szCFGDBPATH]));
      List.Add(Format('%s=%s', [szCFGDBDEFAULTDRIVER, szPARADOX]));
      List.Add(Format('%s=%s', [szCFGDBENABLEBCD, szCFGFALSE]));
    end
    else
      GetConfigParams('\DRIVERS\%s\DB OPEN', StrToOem(DriverName), List); 
  finally
    List.EndUpdate;
  end;
end;

function TSession.GetHandle: HDBISes;
begin
  if FHandle.FHandle <> nil then
    Check(DbiSetCurrSession(FHandle.FHandle))
  else
    SetActive(True);
  Result := FHandle.FHandle;
end;

function TSession.GetNetFileDir: string;
var
  Length: Word;
  Buffer: StringBuilder; 
begin
  if Active and not (csWriting in ComponentState) then
  begin
    LockSession;
    try
      Buffer := StringBuilder.Create(DBIMAXPATHLEN + 1);
      Check(DbiGetProp(HDBIOBJ(FHandle.FHandle), sesNETFILE, Buffer, Buffer.Capacity,
        Length));
    finally
      UnLockSession;
    end;
    NativeToAnsi(nil, Buffer.ToString, Result);
  end else
    Result := FNetFileDir;
  Result := AnsiUpperCaseFileName(Result);
end;

function TSession.GetPrivateDir: string;
var
  SessionInfo: SESInfo;
begin
  if Active and not (csWriting in ComponentState) then
  begin
    LockSession;
    try
      Check(DbiGetSesInfo(SessionInfo));
    finally
      UnlockSession;
    end;
    NativeToAnsi(nil, SessionInfo.szPrivDir, Result);
  end else
    Result := FPrivateDir;
  Result := AnsiUpperCaseFileName(Result);
end;

function TSession.GetPassword: Boolean;
begin
  if Assigned(FOnPassword) then
  begin
    Result := False;
    FOnPassword(Self, Result)
  end else if Assigned(DB.PasswordDialog) then
    Result := DB.PasswordDialog(Self as IDBSession)
  else
    Result := False;
end;

procedure TSession.GetTableNames(const DatabaseName, Pattern: string;
  Extensions, SystemTables: Boolean; List: TStrings);
var
  Database: TDatabase;
  Cursor: HDBICur;
  WildCard: string;
  Name: string;
  Desc: TBLBaseDesc;
begin
  List.BeginUpdate;
  try
    List.Clear;
    Database := OpenDatabase(DatabaseName);
    try
      if Pattern <> '' then
        WildCard := AnsiToNative(Database.Locale, Pattern, DBIMAXTBLNAMELEN);
      Check(DbiOpenTableList(Database.Handle, False, SystemTables,
        WildCard, Cursor));
      try
        while DbiGetNextRecord(Cursor, dbiNOLOCK, Desc, nil) = 0 do
          with Desc do
          begin
            if Extensions and (Length(szExt) <> 0) then
              NativeToAnsi(Database.Locale, szName + '.' + szExt, Name)
            else
              NativeToAnsi(Database.Locale, szName, Name);
            List.Add(Name);
          end;
      finally
        DbiCloseCursor(Cursor);
      end;
    finally
      CloseDatabase(Database);
    end;
  finally
    List.EndUpdate;
  end;
end;

procedure TSession.GetFieldNames(const DatabaseName, TableName: string;
  List: TStrings);
var
  Database: TDatabase;
  Cursor: HDBICur;
  Name: string;
  Desc: BDEFLDDesc;
begin
  List.BeginUpdate;
  try
    List.Clear;
    Database := OpenDatabase(DatabaseName);
    try
      Check(DbiOpenFieldList(Database.Handle, TableName, '', False, Cursor));
      try
        while DbiGetNextRecord(Cursor, dbiNOLOCK, Desc, nil) = 0 do
          with Desc do
          begin
            NativeToAnsi(Database.Locale, szName, Name);
            List.Add(Name);
          end;
      finally
        DbiCloseCursor(Cursor);
      end;
    finally
      CloseDatabase(Database);
    end;
  finally
    List.EndUpdate;
  end;
end;

procedure TSession.GetStoredProcNames(const DatabaseName: string; List: TStrings);
var
  Database: TDatabase;
  Cursor: HDBICur;
  Name: string;
  Desc: SPDesc;
begin
  List.BeginUpdate;
  try
    List.Clear;
    Database := OpenDatabase(DatabaseName);
    try
      Check(DbiOpenSPList(Database.Handle, False, True, nil, Cursor));
      try
        while DbiGetNextRecord(Cursor, dbiNOLOCK, Desc, nil) = 0 do
          with Desc do
          begin
            NativeToAnsi(Database.Locale, szName, Name);
            List.Add(Name);
          end;
      finally
        DbiCloseCursor(Cursor);
      end;
    finally
      CloseDatabase(Database);
    end;
  finally
    List.EndUpdate;
  end;
end;

procedure TSession.InitializeBDE;
var
  Status: DBIResult;
  Env: DbiEnv;
  ClientHandle: hDBIObj;
  SetCursor: Boolean;
begin
  SetCursor := (Thread.CurrentThread = MainThread) and (DBScreen.Cursor = dcrDefault);
  if SetCursor then
    DBScreen.Cursor := dcrHourGlass;
  try
    Env.szLang := SIDAPILangID;
    Status := DbiInit(Env);
    if (Status <> DBIERR_NONE) and (Status <> DBIERR_MULTIPLEINIT) then
      Check(Status);
    Check(DbiGetCurrSession(FHandle.FHandle));
    if DbiGetObjFromName(objCLIENT, nil, ClientHandle) = 0 then
      DbiSetProp(ClientHandle, Integer(clSQLRESTRICT), GDAL);
    if IsLibrary then
      DbiRegisterCallback(nil, cbDETACHNOTIFY, 0, 0, nil, DLLDetachCBDelegate);
  finally
   if SetCursor and (DBScreen.Cursor = dcrHourGlass) then
      DBScreen.Cursor := dcrDefault;
  end;
end;

procedure TSession.InternalAddAlias(const Name, Driver: string; List: TStrings;
  CfgMode: TConfigMode; RestoreMode: Boolean);
var
  Params: string;
  DrvName: string;
  CfgModeSave: TConfigMode;
begin
  Params := StringListToParams(List);
  DrvName := List.Values[szCFGDBDEFAULTDRIVER];
  if (DrvName = '') then
  begin
    if (CompareText(Driver, szCFGDBSTANDARD) = 0) then
      DrvName := szPARADOX else
      DrvName := Driver;
  end;
  LockSession;
  try
    CfgModeSave := ConfigMode;
    try
      CheckConfigMode(CfgMode);
      Check(DbiAddAlias(nil, StrToOem(Name), StrToOem(DrvName), Params, Bool(-1)));
    finally
      if RestoreMode then ConfigMode := CfgModeSave;
    end;
  finally
    UnlockSession;
  end;
  DBNotification(dbAddAlias, Name);
end;

procedure TSession.InternalDeleteAlias(const Name: string;
  CfgMode: TConfigMode; RestoreMode: Boolean);
var
  CfgModeSave: TConfigMode;
begin
  DBNotification(dbDeleteAlias, Name);
  LockSession;
  try
    CfgModeSave := ConfigMode;
    try
      CheckConfigMode(CfgMode);
      DeleteConfigPath('\DATABASES\%s', StrToOem(Name));
    finally
      if RestoreMode then ConfigMode := cfgModeSave;
    end;
  finally
    UnlockSession;
  end;
end;

function TSession.IsAlias(const Name: string): Boolean;
begin
  LockSession;
  try
    Result := (Name <> '') and
      (DbiCfgPosition(nil, Format('\DATABASES\%s', [StrToOem(Name)])) = 0);
  finally
    UnlockSession;
  end;
end;

procedure TSession.Loaded;
begin
  inherited Loaded;
  try
    if AutoSessionName then SetSessionNames;
    if FStreamedActive then SetActive(True);
  except
    if csDesigning in ComponentState then
      ApplicationHandleException(Self)
    else
      raise;
  end;
end;

procedure TSession.LockSession;
begin
  if FLockCount = 0 then
  begin
    System.Threading.Monitor.Enter(FCSect);
    Inc(FLockCount);
    MakeCurrent;
  end
  else
    Inc(FLockCount);
end;

procedure TSession.UnLockSession;
begin
  Dec(FLockCount);
  if FLockCount = 0 then
    System.Threading.Monitor.Exit(FCSect);
end;

procedure TSession.MakeCurrent;
begin
  if FHandle.FHandle <> nil then
    Check(DbiSetCurrSession(FHandle.FHandle))
  else
    SetActive(True);
end;

procedure TSession.ModifyAlias(Name: string; List: TStrings);
var
  DriverName: string;
  OemName: string;
  CfgModeSave: TConfigMode;
begin
  LockSession;
  try
    CfgModeSave := ConfigMode;
    try
      CheckConfigMode(ConfigMode);
      DriverName := GetAliasDriverName(Name);
      OemName := StrToOem(Name);
      ModifyConfigParams('\DATABASES\%s\DB INFO', OemName, List);
      if CompareText(DriverName, szCFGDBSTANDARD) <> 0 then
        ModifyConfigParams('\DATABASES\%s\DB OPEN', OemName, List);
    finally
      ConfigMode := CfgModeSave;
    end;
  finally
    UnLockSession;
  end;
end;

procedure TSession.ModifyDriver(Name: string; List: TStrings);
var
  CfgModeSave: TConfigMode;
  OemName: string;
begin
  LockSession;
  try
    CfgModeSave := ConfigMode;
    try
      CheckConfigMode(ConfigMode);
      OemName := StrToOem(Name);
      ModifyConfigParams('\DRIVERS\%s\INIT', OemName, List);
      if IsStandardType(Name) then
        ModifyConfigParams('\DRIVERS\%s\TABLE CREATE', OemName, List) else
        ModifyConfigParams('\DRIVERS\%s\DB OPEN', OemName, List);
    finally
      ConfigMode := CfgModeSave;
    end;
  finally
    UnLockSession;
  end;
end;

procedure TSession.ModifyConfigParams(const Path, Node: string; List: TStrings);
var
  I, J, C: Integer;
  Params: TStrings;
begin
  Params := TStringList.Create;
  try
    GetConfigParams(Path, Node, Params);
    C := 0;
    for I := 0 to Params.Count - 1 do
    begin
      J := List.IndexOfName(Params.Names[I]);
      if J >= 0 then
      begin
        Params[I] := List[J];
        Inc(C);
      end;
    end;
    if C > 0 then SetConfigParams(Path, Node, Params);
  finally
    Params.Free;
  end;
end;

procedure TSession.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if AutoSessionName and (Operation = opInsert) then
    if AComponent is TDBDataSet then
      TDBDataSet(AComponent).FSessionName := Self.SessionName
    else if AComponent is TDatabase then
      TDatabase(AComponent).FSession := Self;
end;

procedure TSession.Open;
begin
  SetActive(True);
end;

function TSession.DoOpenDatabase(const DatabaseName: string; AOwner: TComponent): TDatabase;
var
  TempDatabase: TDatabase;
begin
  Result := nil;
  LockSession;
  try
    TempDatabase := nil;
    try
      Result := DoFindDatabase(DatabaseName, AOwner);
      if Result = nil then
      begin
        TempDatabase := TDatabase.Create(Self);
        TempDatabase.DatabaseName := DatabaseName;
        TempDatabase.KeepConnection := FKeepConnections;
        TempDatabase.Temporary := True;
        Result := TempDatabase;
      end;
      Result.Open;
      Inc(Result.FRefCount);
    except
      TempDatabase.Free;
      raise;
    end;
  finally
    UnLockSession;
  end;
end;

function TSession.OpenDatabase(const DatabaseName: string): TDatabase;
begin
  Result := DoOpenDatabase(DatabaseName, nil);
end;

function TSession.SessionNameStored: Boolean;
begin
  Result := not FAutoSessionName;
end;

                                                           
procedure TSession.LoadSMClient(DesignTime: Boolean);
{var
  FM: THandle;
  ClientName: string;
  FOldCBFunc: pfDBICallBack; }
begin
(*  try
    if Assigned(FSMClient) or (DbiGetCallBack(nil, cbTrace, nil, nil, nil,
      FOldCBFunc) = DBIERR_NONE) or FSMLoadFailed then Exit;
    if not DesignTime then
    begin
      FM := OpenFileMapping(FILE_MAP_READ, False, 'SMBuffer'); { Do not localize }
      if FM = 0 then Exit;
      CloseHandle(FM);
    end;
    if not Assigned(FSMClient) then
    begin
      if not Assigned(DefaultSession.FSMClient) then
        CoCreateInstance(Class_SMClient, nil, CLSCTX_INPROC_SERVER, ISMClient,
          DefaultSession.FSMClient);
      if not FDefault then
        FSMClient := DefaultSession.FSMClient;
    end;
    if Assigned(FSMClient) then
    begin
      ClientName := DBApplication.Title;
      if ClientName = '' then  ClientName := SUntitled;
      if not FDefault then
        ClientName := Format('%s.%s', [ClientName, SessionName]);
      if FSMClient.RegisterClient(Integer(FHandle), PChar(ClientName), Self,
         @TSession.SMClientSignal) then
      begin
        GetMem(FSMBuffer, smTraceBufSize);
        //TODO: Add delegate for SQLTraceCallBack
        FCallbacks.Add(TBDECallback.Create(Self, nil, cbTRACE,
          FSMBuffer, smTraceBufSize, SqlTraceCallBack, False));
      end else
        FSMClient := nil;
      FSMLoadFailed := FSMClient = nil;;
    end;
  except
    FSMLoadFailed := True;
  end;  *)
end;

procedure TSession.RegisterCallbacks(Value: Boolean);
var
  I: Integer;
  CBSCTypeBuf: IntPtr;
  CBDBLoginBuf: IntPtr;
begin
  if Value then
  begin
    { Do not register any callbacks if we are not in the MainThread }
    if (Thread.CurrentThread <> MainThread) then Exit;
    if FSQLHourGlass then
    begin
      FServerCBDelegate := ServerCallback;
      CBSCTypeBuf := BDEBuffers.AllocHGlobal(SizeOf(CBSCType));
      Marshal.WriteByte(CBSCTypeBuf, Byte(FCBSCType));
      FCallbacks.Add(TBDECallback.Create(Self, nil, cbSERVERCALL,
        CBSCTypeBuf, SizeOf(CBSCType), FServerCBDelegate, False));
    end;

    FDBLoginCBDelegate := DBLoginCallBack;
    CBDBLoginBuf := BDEBuffers.AllocHGlobal(Marshal.SizeOf(TypeOf(TCBDBLogin)));
    Marshal.StructureToPtr(TObject(FCBDBLogin), CBDBLoginBuf, False);
    FCallbacks.Add(TBDECallback.Create(Self, nil, cbDBLOGIN,
      CBDBLoginBuf, Marshal.SizeOf(TypeOf(TCBDBLogin)), FDBloginCBDelegate, False));
  end else
  begin
    for I := FCallbacks.Count - 1 downto 0 do
      TBDECallback(FCallbacks[I]).Free;
    FCallbacks.Clear;
                              
    {if Assigned(FSMClient) then
    try
      FreeMem(FSMBuffer, smTraceBufSize);
      FSMClient := nil;
    except
    end;}
  end;
end;

procedure TSession.RemoveDatabase(Value: TDatabase);
begin
  FDatabases.Remove(Value);
  DBNotification(dbRemove, Value);
end;

procedure TSession.RemoveAllPasswords;
begin
  LockSession;
  try
    DbiDropPassword(nil);
  finally
    UnlockSession;
  end;
end;

procedure TSession.RemovePassword(const Password: string);
begin
  LockSession;
  try
    if Password <> '' then
      DbiDropPassword(AnsiToNative(Locale, Password, 255));
  finally
    UnlockSession;
  end;
end;

procedure TSession.SaveConfigFile;
var
  CfgModeSave: TConfigMode;
begin
  CfgModeSave := ConfigMode;
  try
    ConfigMode := cmPersistent;
    Check(DbiCfgSave(nil, nil, Bool(-1)));
  finally
    ConfigMode := CfgModeSave;
  end;
end;

function TSession.ServerCallBack(CBInfo: IntPtr): CBRType;
begin
  Result := cbrUSEDEF;
  if (Thread.CurrentThread <> MainThread) then Exit;
  FCBSCType := CBSCType(Marshal.ReadByte(CBInfo));
  if (FCBSCType = cbscSQL) then
  begin
    if not Assigned(Timer) then
      Timer := TTimerWrapper.Create;
    if Timer.TimerID = 0 then
      Timer.TimerID := SetTimer(0, 0, SQLDelay, TimerCallBackDelegate);
    if Assigned(DBScreen) and (DBScreen.Cursor <> dcrSQLWait) then
      DBScreen.Cursor := dcrSQLWait;
    StartTime := GetTickCount;
  end;
end;

procedure TSession.SetActive(Value: Boolean);
begin
  if csReading in ComponentState then
    FStreamedActive := Value
  else
    if Active <> Value then
      StartSession(Value);
end;

procedure TSession.SetAutoSessionName(Value: Boolean);
begin
  if Value <> FAutoSessionName then
  begin
    if Value then
    begin
      CheckInActive;
      ValidateAutoSession(Owner, True);
      FSessionNumber := -1;
      System.Threading.Monitor.Enter(FCSect);
      try
        with Sessions do
        begin
          FSessionNumber := FSessionNumbers.OpenBit;
          FSessionNumbers[FSessionNumber] := True;
        end;
      finally
        System.Threading.Monitor.Exit(FCSect);
      end;
      UpdateAutoSessionName;
    end
    else
    begin
      if FSessionNumber > -1 then
      begin
        System.Threading.Monitor.Enter(FCSect);
        try
          Sessions.FSessionNumbers[FSessionNumber] := False;
        finally
          System.Threading.Monitor.Exit(FCSect);
        end;
      end;
    end;
    FAutoSessionName := Value;
  end;
end;

function TSession.GetConfigMode: TConfigMode;
begin
  LockSession;
  try
    Result := TConfigMode(Byte(GetIntProp(FHandle.FHandle, sesCFGMODE2)));
  finally
    UnlockSession;
  end;
end;

procedure TSession.SetConfigMode(Value: TConfigMode);
begin
  LockSession;
  try
    Check(DbiSetProp(hDBIObj(FHandle.FHandle), sesCFGMODE2, Longint(Byte(Value))));
  finally
    UnlockSession;
  end;
end;

procedure TSession.SetConfigParams(const Path, Node: string; List: TStrings);
var
  FieldDescBuf: IntPtr;
  ParamList: TParamList;
begin
  ParamList := TParamList.Create(List);
  try
    with ParamList do
    begin
      FieldDescBuf := ArrayToNativeBuf(FieldDescs);
      try
        Check(DbiCfgModifyRecord(nil, Format(Path, [Node]), FieldCount,
          FieldDescBuf, Buffer));
      finally
        Marshal.FreeHGlobal(FieldDescBuf);
      end;
    end;
  finally
    ParamList.Free;
  end; 
end;

procedure TSession.SetName(const NewName: TComponentName);
begin
  inherited SetName(NewName);
  if FAutoSessionName then UpdateAutoSessionName;
end;

procedure TSession.SetNetFileDir(const Value: string);
begin
  if Active then
  begin
    LockSession;
    try
      Check(DbiSetProp(HDBIOBJ(Handle), sesNETFILE, AnsiToNative(nil,
        Value, DBIMAXPATHLEN)));
    finally
      UnLockSession;
    end;
  end;
  FNetFileDir := Value;
end;

procedure TSession.SetPrivateDir(const Value: string);
begin
  if Active then
  begin
    LockSession;
    try
      Check(DbiSetPrivateDir(AnsiToNative(nil, Value, DBIMAXPATHLEN)));
    finally
      UnlockSession;
    end;
  end;
  FPrivateDir := Value;
end;

procedure TSession.SetSessionName(const Value: string);
var
  Ses: TSession;
begin
  if FAutoSessionName and not FUpdatingAutoSessionName then
    DatabaseError(SAutoSessionActive, Self);
  CheckInActive;
  if Value <> '' then
  begin
    Ses := Sessions.FindSession(Value);
    if not ((Ses = nil) or (Ses = Self)) then
      DatabaseErrorFmt(SDuplicateSessionName, [Value], Self);
  end;
  FSessionName := Value
end;

procedure TSession.SetSessionNames;
var
  I: Integer;
  Component: TComponent;
begin
  if Owner <> nil then
    for I := 0 to Owner.ComponentCount - 1 do
    begin
      Component := Owner.Components[I];
      if (Component is TDBDataSet) and
        (WideCompareText(TDBDataSet(Component).SessionName, Self.SessionName) <> 0) then
        TDBDataSet(Component).SessionName := Self.SessionName
      else if (Component is TDataBase) and
        (WideCompareText(TDatabase(Component).SessionName, Self.SessionName) <> 0) then
        TDataBase(Component).SessionName := Self.SessionName
    end;
end;

procedure TSession.SetTraceFlags(Value: TTraceFlags);
var
  I: Integer;
begin
  FTraceFlags := Value;
  for I := FDatabases.Count - 1 downto 0 do
    with TDatabase(FDatabases[I]) do
      TraceFlags := FTraceFlags;
end;

procedure TSession.SMClientSignal(Sender: TObject; Data: Integer);
begin
  SetTraceFlags(TTraceFlags(Word(Data)));
end;

                                                
function TSession.SqlTraceCallBack(CBInfo: IntPtr): CBRType;
//var
//  Data: IntPtr;
begin
{  try
    Data := @PTraceDesc(CBInfo).pszTrace;
    FSMClient.AddStatement(Data, StrLen(Data));
  except
    SetTraceFlags([]);
  end; }
  Result := cbrUSEDEF;
end;

procedure TSession.StartSession(Value: Boolean);
var
  I: Integer;
begin
  System.Threading.Monitor.Enter(FCSect);
  try
    if Value then
    begin
      if Assigned(FOnStartup) then FOnStartup(Self);
      if FSessionName = '' then DatabaseError(SSessionNameMissing, Self);
      if (DefaultSession <> Self) then DefaultSession.Active := True;
      if FHandle.FDefault then
        InitializeBDE
      else
        Check(DbiStartSession(nil, FHandle.FHandle, nil));
      try
        RegisterCallbacks(True);
        if FNetFileDir <> '' then SetNetFileDir(FNetFileDir);
        if FPrivateDir <> '' then SetPrivateDir(FPrivateDir);
        ConfigMode := cmAll;
        CallBDEInitProcs;
      except
        StartSession(False);
        raise;
      end;
    end
    else
    begin
      DbiSetCurrSession(FHandle.FHandle);
      for I := FDatabases.Count - 1 downto 0 do
        with TDatabase(FDatabases[I]) do
          if Temporary then Free else Close;
      RegisterCallbacks(False);
      if FHandle.FDefault then
      begin
        if not FHandle.FDLLDetach then
        begin
          if IsLibrary then
          begin
                                           
            DbiRegisterCallback(nil, cbDETACHNOTIFY, 0, 0, nil {DLLDetachCBDelegate}, nil);
            DbiDLLExit;
          end;
          DbiExit;
        end;
      end
      else
      begin
        Check(DbiCloseSession(FHandle.FHandle));
        DbiSetCurrSession(DefaultSession.FHandle.FHandle);
      end;
      FHandle.FHandle := nil;
    end;
  finally
    System.Threading.Monitor.Exit(FCSect);
  end;
end;

procedure TSession.UpdateAutoSessionName;
begin
  FUpdatingAutoSessionName := True;
  try
    SessionName := Format('%s_%d', [Name, FSessionNumber + 1]);
  finally
    FUpdatingAutoSessionName := False;
  end;
  SetSessionNames;
end;

procedure TSession.ValidateAutoSession(AOwner: TComponent; AllSessions: Boolean);
var
  I: Integer;
  Component: TComponent;
begin
  if AOwner <> nil then
    for I := 0 to AOwner.ComponentCount - 1 do
    begin
      Component := AOwner.Components[I];
      if (Component <> Self) and (Component is TSession) then
        if AllSessions then DatabaseError(SAutoSessionExclusive, Self)
        else if TSession(Component).AutoSessionName then
          DatabaseErrorFmt(SAutoSessionExists, [Component.Name]);
    end;
end;

{ TParamList }

constructor TParamList.Create(Params: TStrings);
var
  I, P, FieldNo: Integer;
  BufPtr: IntPtr;
  TempBuf: TBytes;
  S: string;
begin
  inherited Create;
  for I := 0 to Params.Count - 1 do
  begin
    S := Params[I];
    P := Pos('=', S);
    if P <> 0 then
    begin
      Inc(FFieldCount);
      Inc(FBufSize, Length(S) - P + 1);
    end;
  end;
  if FFieldCount > 0 then
  begin
    SetLength(FFieldDescs, FFieldCount);
    FBuffer := BDEBuffers.AllocHGlobal(FBufSize);
    FieldNo := 0;
    BufPtr := FBuffer;
    for I := 0 to Params.Count - 1 do
    begin
      S := Params[I];
      P := Pos('=', S);
      if P <> 0 then
        with FFieldDescs[FieldNo] do
        begin
          Inc(FieldNo);
          iFldNum := FieldNo;
          szName := Copy(S, 1, P - 1);
          iFldType := fldZSTRING;
          iOffset := Longint(BufPtr) - Longint(FBuffer);
          iLen := Length(S) - P + 1;
          TempBuf := BytesOf(Copy(S, P + 1, 255));
          Marshal.Copy(TempBuf, 0, BufPtr, Length(TempBuf));
          _CharToOemA(BufPtr, BufPtr);
          BufPtr := IntPtr(LongInt(BufPtr.ToInt32 + iLen));
        end;
    end;
  end;
end;

destructor TParamList.Destroy;
begin
  BDEBuffers.FreeHGlobal(FBuffer);
end;

{ TDatabaseFinalizer }

constructor TDatabaseFinalizer.Create;
begin
  inherited Create;
  FFinalizeNotify := @FinalizeNotify;
end;

procedure TDatabaseFinalizer.Finalize;
begin
  if FHandle <> nil then
  begin
    FreeHandle;
    if Assigned(FSession) then Unregister;
  end;
  inherited;
end;

procedure TDatabaseFinalizer.FinalizeNotify;
begin
  FreeHandle;
  FSession := nil;
end;

procedure TDatabaseFinalizer.FreeHandle;
begin
  if FHandle <> nil then
  begin
    DbiCloseDatabase(FHandle);
    FHandle := nil;
  end;
end;

procedure TDatabaseFinalizer.Register(ASession: TSession);
begin
  FSession := ASession;
  FSession.FHandle.RegisterFinalizeNotify(FFinalizeNotify);
end;

procedure TDatabaseFinalizer.Unregister;
begin
  FSession.FHandle.UnregisterFinalizeNotify(FFinalizeNotify);
  FSession := nil;
end;

{ TDatabase }

constructor TDatabase.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  if FSession = nil then
    if AOwner is TSession then
      FSession := TSession(AOwner) else
      FSession := DefaultSession;
  FHandle := TDatabaseFinalizer.Create;
  SessionName := FSession.SessionName;
  FSession.AddDatabase(Self);
  FParams := TStringList.Create;
  TStringList(FParams).OnChanging := ParamsChanging;
  LoginPrompt := True;
  FKeepConnection := True;
  FLocale := FSession.Locale;
  FTransIsolation := tiReadCommitted;
end;

destructor TDatabase.Destroy;
begin
  Destroying;
  Close;
  if FSession <> nil then
    FSession.RemoveDatabase(Self);
  System.GC.SuppressFinalize(FHandle);
  inherited Destroy;
  FParams.Free;
  FStmtList.Free;
end;

procedure TDatabase.ApplyUpdates(const DataSets: array of TDBDataSet);
var
  I: Integer;
  DS: TDBDataSet;
begin
  StartTransaction;
  try
    for I := 0 to High(DataSets) do
    begin
      DS := DataSets[I];
      if DS.Database <> Self then
        DatabaseError(Format(SUpdateWrongDB, [DS.Name, Name]));
      DataSets[I].ApplyUpdates;
    end;
    Commit;
  except
    Rollback;
    raise;
  end;
  for I := 0 to High(DataSets) do
    DataSets[I].CommitUpdates;
end;

type
  TStmtInfo = packed record
    HashCode: Integer;
    StmtHandle: HDBIStmt;
    SQLText: string;
  end;

procedure TDatabase.ClearStatements;
var
  i: Integer;
  LStmtHandle: hDBIStmt;
begin
  if Assigned(FStmtList) then
  begin
    for i := 0 to FStmtList.Count - 1 do
    begin
      LStmtHandle := TStmtInfo(FStmtList[i]).StmtHandle;
      DbiQFree(LStmtHandle);
    end;
    FStmtList.Clear;
  end;
end;

function TDatabase.Execute(const SQL: string; Params: TParams = nil;
  Cache: Boolean = False; Cursor: phDBICur = nil): Integer;

  function GetHashCode(Str: string): Integer;
  var
    Off, Len, Skip, I: Integer;
  begin
    Result := 0;
    Off := 1;
    Len := Length(Str);
    if Len < 16 then
      for I := (Len - 1) downto 0 do
      begin
        Result := (Result * 37) + Ord(Str[Off]);
        Inc(Off);
      end
    else
    begin
      { Only sample some characters }
      Skip := Len div 8;
      I := Len - 1;
      while I >= 0 do
      begin
        Result := (Result * 39) + Ord(Str[Off]);
        Dec(I, Skip);
        Inc(Off, Skip);
      end;
    end;
  end;

  function GetStmtInfo(SQL: string): Integer;
  var
    HashCode, i: Integer;
    Info: TStmtInfo;
    IsAssigned: Boolean;
  begin
    Result := -1;
    if not Assigned(FStmtList) then
      FStmtList := TList.Create;
    IsAssigned := False;
    HashCode := GetHashCode(SQL);
    for i := 0 to FStmtList.Count - 1 do
    begin
      Info := TStmtInfo(FStmtList[i]);
      if (Info.HashCode = HashCode) and
         (WideCompareText(Info.SQLText, SQL) = 0) then
      begin
        Result := I;
        IsAssigned := True;
        Break;
      end;
    end;
    if not IsAssigned then
    begin
      Info.HashCode := HashCode;
      Info.StmtHandle := nil;
      Info.SQLText := '';
      Result := FStmtList.Add(TObject(Info));
    end;
  end;

  function GetStatementHandle: HDBIStmt;
  var
    Info: TStmtInfo;
    IndexOfStmt: Integer;
    Status: DBIResult;
    IsAssigned: Boolean;
  begin
    IndexOfStmt := -1;
    IsAssigned := False;
    Result := nil;
    if Cache then
    begin
      IndexOfStmt := GetStmtInfo(SQL);
      Info := TStmtInfo(FStmtList[IndexOfStmt]);
      Result := Info.StmtHandle;
      IsAssigned := True;
    end;
    if not Assigned(Result) then
    begin
      Check(DbiQAlloc(Handle, qrylangSQL, Result));
      if Cursor <> nil then
        Check(DbiSetProp(hDbiObj(Result), stmtLIVENESS, Ord(wantCanned)));
      if not IsSQLBased then
      begin
        SetBoolProp(Result, stmtAUXTBLS, False);
        SetBoolProp(Result, stmtCANNEDREADONLY, True);
      end else
        SetBoolProp(Result, stmtUNIDIRECTIONAL, True);
      while True do
      begin
        Status := DbiQPrepare(Result, SQL);
        case Status of
          DBIERR_NONE: break;
          DBIERR_NOTSUFFTABLERIGHTS:
            if not FSession.GetPassword then DbiError(Status);
          else
            DbiError(Status);
        end;
      end;
      if IsAssigned then
      begin
        Info.SQLText := SQL;
        Info.StmtHandle := Result;
        FStmtList[IndexOfStmt] := TObject(Info);
      end;
    end;
  end;

var
  StmtHandle: HDBIStmt;
  Len: Word;
begin
  Open;
  if Assigned(Params) and (Params.Count > 0) then
  begin
    StmtHandle := GetStatementHandle;
    try
      SetQueryParams(Self, StmtHandle, Params);
      Check(DbiQExec(StmtHandle, Cursor));
    finally
      if not Cache then DbiQFree(StmtHandle);
    end;
  end else
    Check(DbiQExecDirect(Handle, qrylangSQL, SQL, Cursor));
  if (Cursor = nil) and (DbiGetProp(hDBIObj(StmtHandle), stmtROWCOUNT,
                          Result, SizeOf(Result), Len) <> 0) then
    Result := 0;
end;

procedure TDatabase.CheckActive;
begin
  if FHandle.FHandle = nil then DatabaseError(SDatabaseClosed, Self);
end;

procedure TDatabase.CheckInactive;
begin
  if FHandle.FHandle <> nil then
    if csDesigning in ComponentState then
      Close else
      DatabaseError(SDatabaseOpen, Self);
end;

procedure TDatabase.CheckDatabaseName;
begin
  if (FDatabaseName = '') and not Temporary then
    DatabaseError(SDatabaseNameMissing, Self);
end;

procedure TDatabase.CheckSessionName(Required: Boolean);
var
  NewSession: TSession;
begin
  if Required then
    NewSession := Sessions.List[FSessionName]
  else
    NewSession := Sessions.FindSession(FSessionName);
  if (NewSession <> nil) and (NewSession <> FSession) then
  begin
    if (FSession <> nil) then FSession.RemoveDatabase(Self);
    FSession := NewSession;
    FSession.FreeNotification(Self);
    FSession.AddDatabase(Self);
    try
      ValidateName(FDatabaseName);
    except
      FDatabaseName := '';
      raise;
    end;
  end;
  if Required then FSession.Active := True;
end;

procedure TDatabase.DoDisconnect;
begin
  if FHandle.FHandle <> nil then
  begin
    ClearStatements;
    Session.DBNotification(dbClose, Self);
    CloseDataSets;
    if FLocaleLoaded then OsLdUnloadObj(FLocale);
    FLocaleLoaded := False;
    FLocale := DefaultSession.Locale;
    if not FAcquiredHandle then
      FSession.CloseDatabaseHandle(Self)
    else
      FAcquiredHandle := False;
    FSQLBased := False;
    FHandle.FHandle := nil;
    FHandle.Unregister;
    FRefCount := 0;
    if FSessionAlias then
    begin
      FSession.InternalDeleteAlias(FDatabaseName, cmSession, True);
      FSessionAlias := False;
    end;
  end;
end;

procedure TDatabase.CloseDataSets;
begin
  while DataSetCount <> 0 do TDBDataSet(DataSets[DataSetCount-1]).Disconnect;
end;

procedure TDatabase.Commit;
begin
  CheckActive;
  EndTransaction(xendCOMMIT);
end;

procedure TDatabase.EndTransaction(TransEnd: EXEnd);
begin
  Check(DbiEndTran(FHandle.FHandle, nil, TransEnd));
end;

function TDatabase.GetAliasName: string;
begin
  if FAliased then Result := FDatabaseType else Result := '';
end;

function TDatabase.GetConnected: Boolean;
begin
  Result := FHandle.FHandle <> nil;
end;

function TDatabase.GetDataSet(Index: Integer): TDBDataSet;
begin
  Result := inherited GetDataSet(Index) as TDBDataSet;
end;

function TDatabase.GetDirectory: string;
var
  SDirectory: StringBuilder;
begin
  if Handle <> nil then
  begin
    SDirectory := StringBuilder.Create(DBIMAXPATHLEN + 1);
    Check(DbiGetDirectory(Handle, False, SDirectory));
    //SetLength(Result, StrLen(SDirectory));
    OemToCharA(SDirectory.ToString, SDirectory);
    Result := SDirectory.ToString;
  end
  else
    Result := '';
end;

procedure TDatabase.GetFieldNames(const TableName: string; List: TStrings);
begin
  if Assigned(FSession) then
    FSession.GetFieldNames(Self.DatabaseName, TableName, List);
end;

procedure TDatabase.GetTableNames(List: TStrings; SystemTables: Boolean = False);
begin
  if Assigned(FSession) then
    FSession.GetTableNames(Self.DatabaseName, '', False, SystemTables, List);
end;

function TDatabase.GetDriverName: string;
begin
  if FAliased then Result := '' else Result := FDatabaseType;
end;

function TDatabase.GetHandle: HDBIDB;
begin
  Result := FHandle.FHandle;
end;

procedure TDatabase.SetDatabaseFlags;
var
  Length: Word;
  Buffer: StringBuilder; 
  SupportsPseudoIndexes: Bool;
begin
  Buffer := StringBuilder.Create(DBIMAXNAMELEN + 1);
  Check(DbiGetProp(HDBIOBJ(FHandle.FHandle), dbDATABASETYPE, Buffer,
    Buffer.Capacity, Length));
  FSQLBased := CompareText(Buffer.ToString, szCFGDBSTANDARD) <> 0;
  FPseudoIndexes := (DbiGetProp(HDBIOBJ(FHandle.FHandle), Integer(drvPSEUDOINDEX),
    SupportsPseudoIndexes, SizeOf(SupportsPseudoIndexes),
    Length) = DBIERR_NONE) and SupportsPseudoIndexes;
end;

function TDatabase.GetTraceFlags: TTraceFlags;
begin
  if Connected and IsSQLBased then
    Result := TTraceFlags(Word(GetIntProp(FHandle.FHandle, dbTraceMode)))
  else
    Result := [];
end;

                                  
{function TDatabase.GetObjectContext: IUnknown;
begin
  if Assigned(GetObjectContextProc) then
    Result := GetObjectContextProc
  else
    Result := nil;
end;}

function TDatabase.GetInTransaction: Boolean;
var
  X: XInfo;
begin
  Result := (Handle <> nil) and (DbiGetTranInfo(Handle, nil, X) = DBIERR_NONE)
    and (X.exState = xsActive);
end;

procedure TDatabase.Loaded;
begin
  inherited Loaded;
  if not StreamedConnected then CheckSessionName(False);
end;

procedure TDatabase.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = FSession) and
    (FSession <> DefaultSession) then
  begin
    Close;
    SessionName := '';
  end;
end;

procedure TDatabase.RegisterClient(Client: TObject; Event: TConnectChangeEvent = nil);
begin
  inherited; 
end;

procedure TDatabase.UnRegisterClient(Client: TObject);
begin
  inherited; 
end;

procedure TDatabase.LoadLocale;
var
  LName: StringBuilder; 
  DBLocale: TLocale;
begin
  LName := StringBuilder.Create(DBIMAXNAMELEN + 1);
  if IsSQLBased and (DbiGetLdNameFromDB(FHandle.FHandle, nil, LName) = 0) and
    (OsLdLoadBySymbName(LName.ToString, DBLocale) = 0) then
  begin
    FLocale := DBLocale;
    FLocaleLoaded := True;
  end;
end;

procedure TDatabase.Login(LoginParams: TStrings);
var
  UserName, Password: string;
begin
  if Assigned(FOnLogin) then FOnLogin(Self, LoginParams) else
  begin
    UserName := LoginParams.Values[szUSERNAME];
    if Assigned(LoginDialogExProc) then
      if not LoginDialogExProc(DatabaseName, UserName, Password, False) then
        DatabaseErrorFmt(SLoginError, [DatabaseName]);
    LoginParams.Values[szUSERNAME] := UserName;
    LoginParams.Values[szPASSWORD] := Password;
  end;
end;

procedure TDatabase.CheckDatabaseAlias(var Password: string);
var
  Desc: DBDesc;
  Aliased: Boolean;
  DBName: string;
  DriverType: string;
  AliasParams: TStringList;
  LoginParams: TStringList;
  Buffer: StringBuilder;

  function NeedsDBAlias: Boolean;
  var
    I: Integer;
    PName: String;
  begin
    Result := not Aliased or ((FDatabaseType <> '') and
      (FDatabaseName <> FDatabaseType));
    for I := 0 to FParams.Count - 1 do
    begin
      if AliasParams.IndexOf(FParams[I]) > -1 then continue;
      PName := FParams.Names[I];
      if (CompareText(PName, szPASSWORD) = 0) then continue;
      if AliasParams.IndexOfName(PName) > -1 then
      begin
        Result := True;
        AliasParams.Values[PName] := FParams.Values[PName];
      end;
    end;
  end;

begin
  Password := '';
  FSessionAlias := False;
  AliasParams := TStringList.Create;
  try
    begin
      if FDatabaseType <> '' then
      begin
        DBName := FDatabaseType;
        Aliased := FAliased;
      end else
      begin
        DBName := FDatabaseName;
        Aliased := True;
      end;
      if Aliased then
      begin
        if DbiGetDatabaseDesc(StrToOem(DBName), Desc) <> 0 then Exit;
        Buffer := StringBuilder.Create(DBIMAXNAMELEN + 1);
        OemToCharA(Desc.szDbType, Buffer);
        DriverType := Buffer.ToString;
        FSession.GetAliasParams(DBName, AliasParams);
      end else
      begin
        FSession.GetDriverParams(DBName, AliasParams);
        DriverType := FDatabaseType;
      end;
      if AliasParams.IndexOfName(szUSERNAME) <> -1 then
      begin
        if LoginPrompt then
        begin
          LoginParams := TStringList.Create;
          try
            if FParams.Values[szUSERNAME] = '' then
              FParams.Values[szUSERNAME] := AliasParams.Values[szUSERNAME];
            LoginParams.Values[szUSERNAME] := FParams.Values[szUSERNAME];
            Login(LoginParams);
            Password := LoginParams.Values[szPASSWORD];
            FParams.Values[szUSERNAME] := LoginParams.Values[szUSERNAME];
          finally
            LoginParams.Free;
          end;
        end else
          Password := FParams.Values[szPASSWORD];
      end;
    end;
    if NeedsDBAlias then
    begin
      FSession.InternalAddAlias(FDatabaseName, DriverType, AliasParams,
        cmSession, False);
      FSessionAlias := True;
    end;
  finally
    AliasParams.Free;
  end;
end;

function TDatabase.OpenFromExistingDB: Boolean;
begin
  Handle := FSession.FindDatabaseHandle(DatabaseName);
  FAcquiredHandle := False;
  Result := (Handle <> nil);
end;

procedure TDatabase.DoConnect;
var
  DBName: string;
  DBPassword: string;
  CfgModeSave: TConfigMode;
  OptParam: IntPtr;  { Pointer }
  OptFldDesc: IntPtr; { pFldDesc }
  OptParamCount: Integer;
  ObjectContextDesc: BDEFldDesc;
  OpenModeFlag: Word;
begin
  if FHandle.FHandle = nil then
  begin
    CheckDatabaseName;
    CheckSessionName(True);
    if not (HandleShared and OpenFromExistingDB) then
    begin
      FSession.LockSession;
      try
        CfgModeSave := FSession.ConfigMode;
        try
          CheckDatabaseAlias(DBPassword);
          try
            if (FDatabaseType = '') and IsDirectory(FDatabaseName) then
              DBName := '' else
              DBName := StrToOem(FDatabaseName);
            //OptParam := Pointer(GetObjectContext);
            OpenModeFlag := 0;
                                                         
            // Need TDatabase.GetObjectContext
            (*if Assigned(OptParam) then
            begin
              OptParamCount := 1;
              ObjectContextDesc.iLen := sizeof(Pointer);
              ObjectContextDesc.iOffset := 0;
              StrCopy(ObjectContextDesc.szName, szMTXCONTEXTOBJ);
              OptFldDesc := @ObjectContextDesc;
              { Set a flag to indicate how bde will handle transactions started
               under MTS.  BDE will handle the case of
               (TransIsolation <> tiDirtyRead) and not IsSQLBased. }
              case TransIsolation of
                tiDirtyRead:      OpenModeFlag := OPENMODEFLAG_DIRTYREAD;
                tiReadCommitted:  OpenModeFlag := OPENMODEFLAG_READCOMMITTED;
                tiRepeatableRead: OpenModeFlag := OPENMODEFLAG_REPEATABLEREAD;
              end
            end
            else *)
            begin
              OptParamCount := 0;
              OptFldDesc := nil;
            end;
            Check(DbiOpenDatabase(DBName, nil,
              DBIOpenMode(Integer(OpenModes[FReadOnly]) or OpenModeFlag),
              ShareModes[FExclusive], StrToOem(DBPassword), OptParamCount, OptFldDesc,
              OptParam, FHandle.FHandle));
            if DBName = '' then SetDirectory(FDatabaseName);
            SetBoolProp(FHandle.FHandle, dbUSESCHEMAFILE, True);
            SetBoolProp(FHandle.FHandle, dbPARAMFMTQMARK, True);
            SetBoolProp(FHandle.FHandle, dbCOMPRESSARRAYFLDDESC, True);
            SetDatabaseFlags;
            LoadLocale;
            if IsSQLBased then FSession.LoadSMClient(csDesigning in ComponentState);
            TraceFlags := FSession.FTraceFlags;
            Session.DBNotification(dbOpen, Self);
            FHandle.Register(Session);
          except
            if FSessionAlias then
              FSession.InternalDeleteAlias(FDatabaseName, cmSession, False);
            raise;
          end;
        finally
          FSession.ConfigMode := CfgModeSave;
        end;
      finally
        FSession.UnlockSession;
      end;
    end;
  end;
end;

procedure TDatabase.ParamsChanging(Sender: TObject);
begin
  CheckInactive;
end;

procedure TDatabase.Rollback;
begin
  CheckActive;
  EndTransaction(xendABORT);
end;

procedure TDatabase.SetAliasName(const Value: string);
begin
  SetDatabaseType(Value, True);
end;

procedure TDatabase.SetDatabaseName(const Value: string);
begin
  if csReading in ComponentState then
    FDatabaseName := Value else
  if FDatabaseName <> Value then
  begin
    CheckInactive;
    ValidateName(Value);
    FDatabaseName := Value;
  end;
end;

procedure TDatabase.SetDatabaseType(const Value: string;
  Aliased: Boolean);
begin
  CheckInactive;
  FDatabaseType := Value;
  FAliased := Aliased;
end;

procedure TDatabase.SetDirectory(const Value: string);
begin
  if Handle <> nil then
    Check(DbiSetDirectory(Handle, StrToOem(Value)));
end;

procedure TDatabase.SetDriverName(const Value: string);
begin
  SetDatabaseType(Value, False);
end;

procedure TDatabase.SetHandle(Value: HDBIDB);
var
  DBSession: HDBISes;
begin
  if Connected then Close;
  if Value <> nil then
  begin
    Check(DbiGetObjFromObj(HDBIObj(Value), objSESSION, DBSession));
    CheckDatabaseName;
    CheckSessionName(True);
    if FSession.Handle <> DBSession then
      DatabaseError(SDatabaseHandleSet, Self);
    FHandle.FHandle := Value;
    SetDatabaseFlags;
    LoadLocale;
    Session.DBNotification(dbOpen, Self);
    FAcquiredHandle := True;
  end;
end;

procedure TDatabase.SetKeepConnection(Value: Boolean);
begin
  if FKeepConnection <> Value then
  begin
    FKeepConnection := Value;
    if not Value and (FRefCount = 0) then Close;
  end;
end;

procedure TDatabase.SetParams(Value: TStrings);
begin
  CheckInactive;
  FParams.Assign(Value);
end;

procedure TDatabase.SetSessionName(const Value: string);
begin
  if csReading in ComponentState then
    FSessionName := Value
  else
  begin
    CheckInactive;
    if FSessionName <> Value then
    begin
      FSessionName := Value;
      if not (csDestroying in ComponentState) then
        CheckSessionName(False);
    end;
  end;
end;

procedure TDatabase.SetTraceFlags(Value: TTraceFlags);
begin
  if Connected and IsSQLBased then
    DbiSetProp(hDBIObj(FHandle.FHandle), dbTraceMode, Integer(Word(Value)));
end;

procedure TDatabase.SetExclusive(Value: Boolean);
begin
  CheckInactive;
  FExclusive := Value;
end;

procedure TDatabase.SetReadOnly(Value: Boolean);
begin
  CheckInactive;
  FReadOnly := Value;
end;

procedure TDatabase.StartTransaction;
var
  TransHandle:  HDBIXAct;
begin
  CheckActive;
  if not IsSQLBased and (TransIsolation <> tiDirtyRead) then
    DatabaseError(SLocalTransDirty, Self);
  Check(DbiBeginTran(FHandle.FHandle, EXILType(FTransIsolation), TransHandle));
end;

procedure TDatabase.ValidateName(const Name: string);
var
  Database: TDatabase;
begin
  if (Name <> '') and (FSession <> nil) then
  begin
    Database := FSession.FindDatabase(Name);
    if (Database <> nil) and (Database <> Self) and
      not (Database.HandleShared and HandleShared) then
    begin
      if not Database.Temporary or (Database.FRefCount <> 0) then
        DatabaseErrorFmt(SDuplicateDatabaseName, [Name]);
      Database.Free;
    end;
  end;
end;

procedure TDatabase.FlushSchemaCache(const TableName: string);
begin
  if Connected and IsSQLBased then
    Check(DbiSchemaCacheFlush(FHandle.FHandle, TableName));
end;

{ TBDEDataSet }

constructor TBDEDataSet.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  SetLocale(DefaultSession.Locale);
  FCacheBlobs := True;
  NestedDataSetClass := TNestedTable;
end;

destructor TBDEDataSet.Destroy;
begin
  inherited Destroy;
  if FBlockReadBuf <> nil then
  begin
    BDEBuffers.FreeHGlobal(FBlockReadBuf);
    FBlockReadBuf := nil;
  end;
  SetUpdateObject(nil);
end;

procedure TBDEDataSet.OpenCursor(InfoQuery: Boolean);
var
  CursorLocale: TLocale;
begin
  if FHandle = nil then
    FHandle := CreateHandle;
  if FHandle = nil then
  begin
    FreeTimer(True);
    raise ENoResultSet.Create(SHandleError);
  end;
  if DbiGetLdObj(FHandle, CursorLocale) = 0 then SetLocale(CursorLocale);
  inherited OpenCursor(InfoQuery);
end;

procedure TBDEDataSet.CloseCursor;
begin
  inherited CloseCursor;
  SetLocale(DefaultSession.Locale);
  if FHandle <> nil then
  begin
    DestroyHandle;
    FHandle := nil;
  end;
  FParentDataSet := nil;
end;

function TBDEDataSet.CreateHandle: HDBICur;
begin
  Result := nil;
end;

procedure TBDEDataSet.DestroyHandle;
begin
  DbiRelRecordLock(FHandle, False);
  DbiCloseCursor(FHandle);
end;

function TBDEDataSet.GetHandle: HDBICur;
begin
  Result := FHandle;
end;

procedure TBDEDataSet.InternalInitFieldDefs;
var
  Size: Integer;
  I, FieldID: Integer;
  FieldDescs: TFieldDescList;
  FieldDescsBuf: IntPtr;
  ValCheckDesc: VCHKDesc;
  RequiredFields: TBits;
  CursorProps: CurProps;
  FldDescCount,
  MaxFieldID,
  HiddenFieldCount: Integer;
begin
  DbiGetCursorProps(FHandle, CursorProps);
  FldDescCount := CursorProps.iFields;
  HiddenFieldCount := 0;
  if FieldDefs.HiddenFields then
  begin
    if SetBoolProp(Handle, curGETHIDDENCOLUMNS, True) then
    begin
      DbiGetCursorProps(FHandle, CursorProps);
      HiddenFieldCount := CursorProps.iFields - FldDescCount;
      FldDescCount := CursorProps.iFields;
    end;
  end;
  RequiredFields := TBits.Create;
  try
    MaxFieldID := GetIntProp(Handle, curMAXFIELDID);
    if MaxFieldID > 0 then
      RequiredFields.Size := MaxFieldID + 1 else
      RequiredFields.Size := FldDescCount + 1;
    for I := 1 to CursorProps.iValChecks do
    begin
      DbiGetVChkDesc(FHandle, I, ValCheckDesc);
      if ValCheckDesc.bRequired and not ValCheckDesc.bHasDefVal then
        RequiredFields[ValCheckDesc.iFldNum] := True;
    end;

    SetLength(FieldDescs, FldDescCount);
    with Marshal do
    begin
      Size := Sizeof(TypeOf(BDEFLDDesc));
      FieldDescsBuf := AllocHGlobal(FldDescCount * Size);
      try
        DbiGetFieldDescs(FHandle, FieldDescsBuf);
        FieldDescs := TFieldDescList(NativeBufToArray(FieldDescsBuf, FieldDescs));
      finally
        FreeHGlobal(FieldDescsBuf);
      end;
    end;

    FieldID := FieldNoOfs;
    I := FieldID - 1;
    FieldDefs.Clear;
    while I < FldDescCount do
      AddFieldDesc(FieldDescs, I, FieldID, RequiredFields, FieldDefs);
    if FieldDefs.HiddenFields then
    begin
      SetBoolProp(Handle, curGETHIDDENCOLUMNS, False);
      if HiddenFieldCount > 0 then
        for I := FldDescCount - HiddenFieldCount to FldDescCount - 1 do
          FieldDefs[I].Attributes := FieldDefs[I].Attributes + [faHiddenCol];
    end;
  finally
    RequiredFields.Free;
  end;
end;

procedure TBDEDataSet.GetObjectTypeNames(Fields: TFields);
var
  Len: Word;
  I: Integer;
  TypeDesc: BDEObjTypeDesc;
  ObjectField: TObjectField;
begin
  for I := 0 to Fields.Count - 1 do
    if Fields[I] is TObjectField then
    begin
      ObjectField := TObjectField(Fields[I]);
      TypeDesc.iFldNum := ObjectField.FieldNo;
      if (DbiGetProp(hDBIObj(Handle), curFIELDTYPENAME, TypeDesc,
        Marshal.SizeOf(TypeOf(TypeDesc)), Len) = DBIERR_NONE) and (Len > 0) then
        ObjectField.ObjectType := TypeDesc.szTypeName;
      with ObjectField do
        if DataType in [ftADT, ftArray] then
        begin
          if (DataType = ftArray) and SparseArrays and
             (Fields[0].DataType = ftADT) then
            GetObjectTypeNames(TObjectField(Fields[0]).Fields) else
            GetObjectTypeNames(Fields);
        end;
    end
end;

procedure TBDEDataSet.InternalOpen;
var
  CursorProps: CurProps;
begin
  if CachedUpdates then Check(DbiBeginDelayedUpdates(FHandle));
  DbiGetCursorProps(FHandle, CursorProps);
  FRecordSize := CursorProps.iRecBufSize;
  BookmarkSize := CursorProps.iBookmarkSize;
  FCanModify := (CursorProps.eOpenMode = dbiReadWrite)
    and not CursorProps.bTempTable;
  FConstraintLayer := HasConstraints and CanModify;
  FConstraintCBDelegate := ConstraintCallBack;
  if FConstraintLayer then
    Check(DbiBeginConstraintLayer(nil, FHandle, FConstraintCBDelegate, 0));
  FRecNoStatus := TRecNoStatus(CursorProps.ISeqNums);
  FieldDefs.Updated := False;
  FieldDefs.Update;
  GetIndexInfo;
  if DefaultFields then CreateFields;
  BindFields(True);
  if ObjectView then GetObjectTypeNames(Fields);
  InitBufferPointers(False);
  if CachedUpdates then
  begin
    AllocCachedUpdateBuffers(True);
    SetupCallBack(UpdateCallBackRequired);
  end;
  AllocKeyBuffers;
  DbiSetToBegin(FHandle);
  PrepareCursor;
  if Filter <> '' then
    FExprFilter := CreateExprFilter(Filter, FilterOptions, 0);
  if Assigned(OnFilterRecord) then
  begin
    FFuncFilterDelegate := RecordFilter;
    FFuncFilter := CreateFuncFilter(FFuncFilterDelegate, 1);
  end;
  if Filtered then ActivateFilters;
end;

procedure TBDEDataSet.InternalClose;
begin
  FFuncFilter := nil;
  FExprFilter := nil;
  FreeKeyBuffers;
  if CachedUpdates then
  begin
    SetupCallBack(False);
    AllocCachedUpdateBuffers(False);
    if FConstraintLayer then DbiEndConstraintLayer(FHandle);
    if FHandle <> nil then
      DbiEndDelayedUpdates(FHandle);
  end;
  BindFields(False);
  if DefaultFields then DestroyFields;
  FIndexFieldCount := 0;
  FKeySize := 0;
  FExpIndex := False;
  FCaseInsIndex := False;
  FCanModify := False;
end;

procedure TBDEDataSet.PrepareCursor;
begin
end;

function TBDEDataSet.IsCursorOpen: Boolean;
begin
  Result := Handle <> nil;
end;

procedure TBDEDataSet.InternalHandleException;
begin
  ApplicationHandleException(Self)
end;

procedure TBDEDataSet.SetLocale(Value: TLocale);
begin
  FLocale := Value;
end;

{ Record Functions }

procedure TBDEDataSet.InitBufferPointers(GetProps: Boolean);
var
  CursorProps: CurProps;
begin
  if GetProps then
  begin
    Check(DbiGetCursorProps(FHandle, CursorProps));
    BookmarkSize := CursorProps.iBookmarkSize;
    FRecordSize := CursorProps.iRecBufSize;
  end;
  FBlobCacheOfs := FRecordSize + CalcFieldsSize;
  FRecInfoOfs := FBlobCacheOfs + BlobFieldCount * SizeOf(IntPtr);
  FBookmarkOfs := FRecInfoOfs + Marshal.SizeOf(TypeOf(TBDERecInfo));
  FRecBufSize := FBookmarkOfs + BookmarkSize;
end;

function TBDEDataSet.AllocRecordBuffer: TRecordBuffer;
begin
  Result := BDEBuffers.AllocHGlobal(FRecBufSize);
  InitBlobCache(Result); // Ensure blob cache array is null
end;

procedure TBDEDataSet.FreeRecordBuffer(var Buffer: TRecordBuffer);
begin
  ClearBlobCache(Buffer);
  BDEBuffers.FreeHGlobal(Buffer);
end;

procedure TBDEDataSet.InternalInitRecord(Buffer: TRecordBuffer);
begin
  DbiInitRecord(FHandle, Buffer);
end;

procedure TBDEDataSet.ClearBlobCache(Buffer: TRecordBuffer);
var
  Buf: IntPtr;
  I, Ofs: Integer;
  LHandle: GCHandle;
begin
  if FCacheBlobs then
    for I := 0 to BlobFieldCount - 1 do
    begin
      Ofs := I * SizeOf(IntPtr);
      Buf := Marshal.ReadIntPtr(Buffer, FBlobCacheOfs + Ofs);
      if Buf <> nil then
      begin
        LHandle := GCHandle(Buf);
        if LHandle.IsAllocated then
          LHandle.Free;
        Marshal.WriteIntPtr(Buffer, FBlobCacheOfs + Ofs, 0);
      end;
    end;
end;

procedure TBDEDataSet.InitBlobCache(Buffer: TRecordBuffer);
var
  I: Integer;
begin
  if FCacheBlobs then
    for I := 0 to BlobFieldCount - 1 do
      Marshal.WriteInt32(Buffer, FBlobCacheOfs + (I * SizeOf(IntPtr)), 0);
end;

procedure TBDEDataSet.ClearCalcFields(Buffer: TRecordBuffer);
var
  I: Integer;
begin
  for I := 0 to CalcFieldsSize - 1 do
    Marshal.WriteByte(Buffer, I + RecordSize, 0);
end;

procedure TBDEDataSet.InitRecord(Buffer: TRecordBuffer);
begin
  inherited InitRecord(Buffer);
  ClearBlobCache(Buffer);

  // FRecInfoOfs bytes into Buffer holds a TBDERecInfo record
  // with additional information about the record.
  with Marshal do
  begin
    WriteInt32(Buffer, FRecInfoOfs, Longint(-1));         // RecordNumber := -1
    WriteByte(Buffer, FRecInfoOfs + 4, Byte(usInserted)); // UpdateStatus := usInserted
    WriteByte(Buffer, FRecInfoOfs + 5, Byte(bfInserted)); // BookMarkFlag := bfInserted
  end;
end;

function TBDEDataSet.GetRecord(Buffer: TRecordBuffer; GetMode: TGetMode;
  DoCheck: Boolean): TGetResult;
var
  Status: DBIResult;
  RecordNumber: Longint;
begin
  case GetMode of
    gmCurrent:
      Status := DbiGetRecord(FHandle, dbiNoLock, Buffer, FRecProps);
    gmNext:
      Status := DbiGetNextRecord(FHandle, dbiNoLock, Buffer, FRecProps);
    gmPrior:
      Status := DbiGetPriorRecord(FHandle, dbiNoLock, Buffer, FRecProps);
  else
    Status := DBIERR_NONE;
  end;
  case Status of
    DBIERR_NONE:
      begin
        case FRecNoStatus of
          rnParadox: RecordNumber := FRecProps.iSeqNum;
          rnDBase: RecordNumber := FRecProps.iPhyRecNum;
        else
          RecordNumber := -1;
        end;

        // FRecInfoOfs bytes into Buffer holds a TBDERecInfo record
        // with additional information about the record.
        with Marshal do
        begin
          WriteInt32(Buffer, FRecInfoOfs, RecordNumber);                  // RecordNumber
          WriteByte(Buffer, FRecInfoOfs + 4, Byte(FRecProps.iRecStatus)); // UpdateStatus
          WriteByte(Buffer, FRecInfoOfs + 5, Byte(bfCurrent));            // BookMarkFlag
        end;

        ClearBlobCache(Buffer);
        GetCalcFields(Buffer);
        Check(DbiGetBookmark(FHandle, TRecordBuffer(Longint(Buffer) + FBookmarkOfs)));
        Result := grOK;
      end;
    DBIERR_BOF: Result := grBOF;
    DBIERR_EOF: Result := grEOF;
  else
    Result := grError;
    if DoCheck then Check(Status);
  end;
end;

function TBDEDataSet.GetCurrentRecord(Buffer: TRecordBuffer): Boolean;
begin
  if not IsEmpty and (GetBookmarkFlag(ActiveBuffer) = bfCurrent) then
  begin
    UpdateCursorPos;
    Result := (DbiGetRecord(FHandle, dbiNoLock, Buffer, nil) = DBIERR_NONE);
  end else
    Result := False;
end;

function TBDEDataSet.GetOldRecord: TRecordBuffer;
begin
  UpdateCursorPos;
  if SetBoolProp(Handle, curDELAYUPDGETOLDRECORD, True) then
  try
    Check(DbiGetRecord(FHandle, dbiNoLock, FUpdateCBBuf.pOldRecBuf, nil));
    Result := FUpdateCBBuf.pOldRecBuf;
  finally
    SetBoolProp(Handle, curDELAYUPDGETOLDRECORD, False);
  end
  else
    Result := nil;
end;

procedure TBDEDataSet.FetchAll;
begin
  if not EOF then
  begin
    CheckBrowseMode;
    Check(DbiSetToEnd(Handle));
    Check(DbiGetPriorRecord(FHandle, dbiNoLock, nil, nil));
    CursorPosChanged;
  end;
end;

procedure TBDEDataSet.FlushBuffers;
begin
  CheckBrowseMode;
  Check(DbiSaveChanges(Handle));
end;

function TBDEDataSet.GetRecordCount: Integer;
begin
  CheckActive;
  if (DbiGetExactRecordCount(FHandle, Result) <> DBIERR_NONE) and
     (DbiGetRecordCount(FHandle, Result) <> DBIERR_NONE) then
    Result := -1;
end;

function TBDEDataSet.GetRecNo: Integer;
var
  BufPtr: TRecordBuffer;
begin
  CheckActive;
  if State = dsCalcFields then
    BufPtr := CalcBuffer
  else
    BufPtr := ActiveBuffer;
  Result := Marshal.ReadInt32(BufPtr, FRecInfoOfs); // TBDERecInfo.RecordNumber
end;

procedure TBDEDataSet.SetRecNo(Value: Integer);
begin
  CheckBrowseMode;
  if (FRecNoStatus = rnParadox) and (Value <> RecNo) then
  begin
    DoBeforeScroll;
    if DbiSetToSeqNo(Handle, Value) = DBIERR_NONE then
    begin
      Resync([rmCenter]);
      DoAfterScroll;
    end;
  end;
end;

function TBDEDataSet.GetRecordSize: Word;
begin
  Result := FRecordSize;
end;

function TBDEDataSet.GetActiveRecBuf(var RecBuf: TRecordBuffer): Boolean;
begin
  case State of
    dsBlockRead: RecBuf := TRecordBuffer(Longint(FBlockReadBuf) + (FBlockBufOfs * FRecordSize));
    dsBrowse: if IsEmpty then RecBuf := nil else RecBuf := ActiveBuffer;
    dsEdit, dsInsert: RecBuf := ActiveBuffer;
    dsSetKey: RecBuf := TRecordBuffer(Longint(FKeyBuffer) + Marshal.SizeOf(TypeOf(TBDEKeyBuffer)));
    dsCalcFields: RecBuf := CalcBuffer;
    dsFilter: RecBuf := FFilterBuffer;
    dsNewValue: if FInUpdateCallback then
                  RecBuf := FUpdateCBBuf.pNewRecBuf else
                  RecBuf := ActiveBuffer;
    dsOldValue: if FInUpdateCallback then
                  RecBuf := FUpdateCBBuf.pOldRecBuf else
                  RecBuf := GetOldRecord;
  else
    RecBuf := nil;
  end;
  Result := RecBuf <> nil;
end;

{ Field Related }

procedure TBDEDataSet.AddFieldDesc(FieldDescs: TFieldDescList; var DescNo: Integer;
  var FieldID: Integer; RequiredFields: TBits; FieldDefs: TFieldDefs);
var
  FType: TFieldType;
  FSize: Word;
  FRequired: Boolean;
  FPrecision, I: Integer;
  FieldName, FName: string;
  FieldDesc: BDEFLDDesc;
begin
  FieldDesc := FieldDescs[DescNo];
  Inc(DescNo);
  with FieldDesc do
  begin
    NativeToAnsi(Locale, szName, FieldName);
    I := 0;
    FName := FieldName;
    while FieldDefs.IndexOf(FName) >= 0 do
    begin
      Inc(I);
      FName := Format('%s_%d', [FieldName, I]);
    end;
    if iFldType < MAXLOGFLDTYPES then
      FType := DataTypeMap[iFldType] else
      FType := ftUnknown;
    FSize := 0;
    FPrecision := 0;
    if RequiredFields.Size > FieldID then
      FRequired := RequiredFields[FieldID] else
      FRequired := False;
    case iFldType of
      fldZSTRING, fldBYTES, fldVARBYTES, fldADT, fldArray, fldRef:
        begin
          if iUnits1 = 0 then { Ignore MLSLABEL field type on Oracle }
            FType := ftUnknown else
            FSize := iUnits1;
        end;
      fldINT16, fldUINT16:
        if iLen <> 2 then FType := ftUnknown;
      fldINT32:
        if iSubType = fldstAUTOINC then
        begin
          FType := ftAutoInc;
          FRequired := False;
        end;
      fldFLOAT:
        if iSubType = fldstMONEY then FType := ftCurrency;
      fldBCD:
        begin
          FSize := Abs(iUnits2);
          FPrecision := iUnits1;
        end;
      fldBLOB:
        begin
          FSize := iUnits1;
          if (iSubType >= fldstMEMO) and (iSubType <= fldstBFILE) then
            FType := BlobTypeMap[iSubType];
        end;
    end;
    with FieldDefs.AddFieldDef do
    begin
      FieldNo := FieldID;
      Inc(FieldID);
      Name := FName;
      DataType := FType;
      Size := FSize;
      Precision := FPrecision;
      if FRequired then
        Attributes := [faRequired];
      if efldrRights = fldrREADONLY then
        Attributes := Attributes + [faReadonly];
      if iSubType = fldstFIXED then
        Attributes := Attributes + [faFixed];
      InternalCalcField := bCalcField;
      case FType of
        ftADT:
          begin
            if iSubType = fldstADTNestedTable then
              Attributes := Attributes + [faUnNamed];
            for I := 0 to iUnits1 - 1 do
              AddFieldDesc(FieldDescs, DescNo, FieldID, RequiredFields, ChildDefs);
          end;
        ftArray:
          begin
            I := FieldID;
            FieldDescs[DescNo].szName := FieldDesc.szName + '[0]';
            AddFieldDesc(FieldDescs, DescNo, I, RequiredFields, ChildDefs);
            Inc(FieldID, iUnits2);
          end;
      end;
    end;
  end;
end;

function TBDEDataSet.GetBlobFieldData(FieldNo: Integer; var Buffer: TBlobByteData): Integer;
var
  RecBuf: TRecordBuffer;
  Status: DBIResult;
  DoCheck: Boolean;
begin
  Result := 0;
  DoCheck := BlockReadSize = 0;
  if BlockReadSize > 0 then
    RecBuf := TRecordBuffer(Longint(FBlockReadBuf) + (FBlockBufOfs * FRecordSize))
  else
    if not GetActiveRecBuf(RecBuf) then Exit;
  Status := DbiOpenBlob(FHandle, RecBuf, FieldNo, dbiReadOnly);
  if Status <> DBIERR_NONE then Exit;
  try
    Status := DbiGetBlobSize(FHandle, RecBuf, FieldNo, Result);
    if (Status <> DBIERR_NONE) or (Result = 0) then Exit;
    if Length(Buffer) <= Result then
      SetLength(Buffer, Result + Result div 4);
    Status := DbiGetBlob(FHandle, RecBuf, FieldNo, 0, Result, Buffer, Result);
  finally
    if Status <> DBIERR_NONE then Result := 0;
    DbiFreeBlob(FHandle, RecBuf, FieldNo);
    if DoCheck then Check(Status)
  end;
end;

function TBDEDataSet.GetFieldData(FieldNo: Integer; Buffer: TValueBuffer): Boolean;
var
  IsBlank: LongBool;
  RecBuf: TRecordBuffer;
  Status: DBIResult;
begin
  if BlockReadSize > 0 then
  begin
    { Optimized for speed.  If error, just return false }
    Status := DbiGetField(FHandle, FieldNo, TValueBuffer(Longint(FBlockReadBuf) +
      (FBlockBufOfs * FRecordSize)), Buffer, IsBlank);
    Result := (Status = DBIERR_NONE) and not IsBlank;
  end else
  begin
    Result := GetActiveRecBuf(RecBuf);
    if Result then
    begin
      Check(DbiGetField(FHandle, FieldNo, RecBuf, Buffer, IsBlank));
      Result := not IsBlank;
    end
  end;
end;

function TBDEDataSet.GetFieldData(Field: TField; Buffer: TValueBuffer): Boolean;
var
  RecBuf: TRecordBuffer;
begin
  if Field.FieldNo > 0 then
    Result := GetFieldData(Field.FieldNo, Buffer)
  else
  begin
    if State = dsBlockRead then
    begin
      RecBuf := TempBuffer;
      Result := True;
    end else
      Result := GetActiveRecBuf(RecBuf);
    if Result and (State in [dsBrowse, dsEdit, dsInsert, dsCalcFields, dsBlockRead]) then
    begin
      RecBuf := TRecordBuffer(Longint(RecBuf) + FRecordSize + Field.Offset);
      Result := Boolean(Marshal.ReadByte(RecBuf));
      if Result and (Buffer <> nil) then
        CopyBuffer(IntPtr(Longint(RecBuf.ToInt32 + 1)), Buffer, Field.DataSize);
    end;
  end;
end;

procedure TBDEDataSet.SetFieldData(Field: TField; Buffer: TValueBuffer);
var
  RecBuf: TRecordBuffer;
  Blank: LongBool;
begin
  with Field do
  begin
    if not (State in dsWriteModes) then DatabaseError(SNotEditing, Self);
    if (State = dsSetKey) and ((FieldNo < 0) or (FIndexFieldCount > 0) and
      not IsIndexField) then DatabaseErrorFmt(SNotIndexField, [DisplayName]);
    GetActiveRecBuf(RecBuf);
    if FieldNo > 0 then
    begin
      if State = dsCalcFields then DatabaseError(SNotEditing, Self);
      if ReadOnly and not (State in [dsSetKey, dsFilter]) then
        DatabaseErrorFmt(SFieldReadOnly, [DisplayName]);
      Validate(Buffer);
      if FieldKind <> fkInternalCalc then
      begin
        if FConstraintLayer and Field.HasConstraints and (State in [dsEdit, dsInsert]) then
          Check(DbiVerifyField(FHandle, FieldNo, Buffer, Blank));
        Check(DbiPutField(FHandle, FieldNo, RecBuf, Buffer));
      end;
    end else {fkCalculated, fkLookup}
    begin
      RecBuf := IntPtr(Longint(RecBuf.ToInt32 + FRecordSize + Offset));
      Marshal.WriteByte(RecBuf, Byte(Buffer <> nil));
      if Buffer <> nil then
        CopyBuffer(Buffer, IntPtr(Longint(RecBuf.ToInt32 + 1)), DataSize);
    end;
    if not (State in [dsCalcFields, dsFilter, dsNewValue]) then
      DataEvent(deFieldChange, Field);
  end;
end;

// The record buffer pointed to by "Buffer" contains an array of
// GCHandles at "FBlobCacheOfs" that hold references to the Blob data.
// Field.Offset is the index into the array. Each GCHandle references
// a byte array with the actual blob data.
//
// Note: Do not use TBDEDataSet.GetBlobData to determine the size
// of the cached Blob (as done in Win32). Instead, use
// TBDEDataSet.GetBlobDataSize.

function TBDEDataSet.GetBlobData(Field: TField; Buffer: TRecordBuffer): TBlobBytes;
var
  Buf: IntPtr;
  LHandle: GCHandle;
begin
  Result := nil;
  Buf := Marshal.ReadIntPtr(Buffer, FBlobCacheOfs + (Field.Offset * SizeOf(IntPtr)));
  if Buf <> nil then
  begin
    LHandle := GCHandle(Buf);
    if LHandle.IsAllocated then
      Result := TBlobBytes(LHandle.Target); // Retrieve Blob data
  end;
end;

function TBDEDataSet.GetBlobDataSize(Field: TField; Buffer: TRecordBuffer): Integer;
var
  Buf: IntPtr;
  LHandle: GCHandle;
begin
  Result := 0;
  Buf := Marshal.ReadIntPtr(Buffer, FBlobCacheOfs + (Field.Offset * SizeOf(IntPtr)));
  if Buf <> nil then
    LHandle := GCHandle(Buf);
    if LHandle.IsAllocated then
      Result := Length(TBytes(LHandle.Target)); // Retrieve length of Blob data
end;

function TBDEDataSet.IsBlobDataCached(Field: TField; Buffer: TRecordBuffer): Boolean;
var
  Buf: IntPtr;
begin
  Buf := Marshal.ReadIntPtr(Buffer, FBlobCacheOfs + (Field.Offset * SizeOf(IntPtr)));
  Result := Buf <> nil; // If no buffer is allocated, the Blob is not cached
end;

procedure TBDEDataSet.SetBlobData(Field: TField; Buffer: TRecordBuffer; Value: TBlobBytes);
var
  Buf: IntPtr;
  LHandle: GCHandle;
begin
  if Buffer = ActiveBuffer then
    with Marshal do
    begin
      Buf := ReadIntPtr(Buffer, FBlobCacheOfs + (Field.Offset * Borland.Delphi.System.SizeOf(IntPtr)));
      if Buf <> nil then
      begin
        LHandle := GCHandle(Buf);
        if LHandle.IsAllocated then
          LHandle.Free; // If a Blob is already cached, free the memory
      end;
      // Write the pointer to the Blob cache (GCHandle) to the record buffer
      WriteIntPtr(Buffer, FBlobCacheOfs + (Field.Offset * Borland.Delphi.System.SizeOf(IntPtr)),
        IntPtr(GCHandle.Alloc(Value)));
    end;
end;

function TBDEDataSet.CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream;
begin
  Result := TBlobStream.Create(Field as TBlobField, Mode);
end;

procedure TBDEDataSet.CloseBlob(Field: TField);
begin
  DbiFreeBlob(Handle, ActiveBuffer, Field.FieldNo);
end;

function TBDEDataSet.GetStateFieldValue(State: TDataSetState; Field: TField): Variant;
begin
  CheckCachedUpdateMode;
  Result := inherited GetStateFieldValue(State, Field);
end;

procedure TBDEDataSet.SetStateFieldValue(State: TDataSetState; Field: TField; const Value: Variant);
begin
  CheckCachedUpdateMode;
  inherited SetStateFieldValue(State, Field, Value);
end;

function TBDEDataSet.Translate(const Src: string; var Dest: string; ToOem: Boolean): Integer;
begin
  Result := Length(BytesOf(Src));
  if ToOem then
    AnsiToNativeBuf(Locale, Src, Dest, Result) else
    NativeToAnsiBuf(Locale, Src, Dest, Result);
  if Src <> Dest then
    Dest := Dest + #0;
end;

function TBDEDataSet.GetFieldFullName(Field: TField): string;
var
  Len: Word;
  AttrDesc: BDEObjAttrDesc;
  Buffer: string;
begin
  if Field.FieldNo > 0 then
  begin
    AttrDesc.iFldNum := Field.FieldNo;
    AttrDesc.pszAttributeName := Marshal.AllocHGlobal(1025);
    try
      Check(DbiGetProp(HDBIOBJ(Handle), curFIELDFULLNAME, AttrDesc, 1025, Len));
      Buffer := Marshal.PtrToStringAnsi(AttrDesc.pszAttributeName);
      NativeToAnsi(Locale, Buffer, Result);
    finally
      Marshal.FreeHGlobal(AttrDesc.pszAttributeName);
    end;
  end else
    Result := inherited GetFieldFullName(Field);
end;

{ Navigation / Editing }

procedure TBDEDataSet.InternalFirst;
begin
  Check(DbiSetToBegin(FHandle));
end;

procedure TBDEDataSet.InternalLast;
begin
  Check(DbiSetToEnd(FHandle));
end;

procedure TBDEDataSet.InternalEdit;
begin
  Check(DbiGetRecord(FHandle, dbiWriteLock, ActiveBuffer, nil));
  ClearBlobCache(ActiveBuffer);
end;

procedure TBDEDataSet.InternalInsert;
begin
  SetBoolProp(Handle, curMAKECRACK, True);
  CursorPosChanged;
end;

procedure TBDEDataSet.InternalPost;
begin
  inherited;
  if State = dsEdit then
    Check(DbiModifyRecord(FHandle, ActiveBuffer, True)) else
    Check(DbiInsertRecord(FHandle, dbiNoLock, ActiveBuffer));
end;

procedure TBDEDataSet.InternalDelete;
var
  Result: DBIResult;
begin
  Result := DbiDeleteRecord(FHandle, nil);
  if (Result <> DBIERR_NONE) and (ErrCat(Result) <> ERRCAT_NOTFOUND) then
    Check(Result);
end;

function TBDEDataSet.IsSequenced: Boolean;
begin
  Result := (FRecNoStatus = rnParadox) and (not Filtered);
end;

function TBDEDataSet.GetCanModify: Boolean;
begin
  Result := FCanModify or ForceUpdateCallback;
end;

procedure TBDEDataSet.InternalRefresh;
begin
  if (DataSetField <> nil) and (DataSetField.DataType = ftReference) then
    Check(DbiForceRecordReread(FHandle, ActiveBuffer)) else
    Check(DbiForceReread(FHandle));
end;

procedure TBDEDataSet.Post;
begin
  inherited Post;
  if State = dsSetKey then
    PostKeyBuffer(True);
end;

procedure TBDEDataSet.Cancel;
begin
  inherited Cancel;
  if State = dsSetKey then
    PostKeyBuffer(False);
end;

procedure TBDEDataSet.InternalCancel;
begin
  if State = dsEdit then
    DbiRelRecordLock(FHandle, False);
end;

procedure TBDEDataSet.InternalAddRecord(Buffer: TRecordBuffer; Append: Boolean);
begin
  if Append then
    Check(DbiAppendRecord(FHandle, Buffer)) else
    Check(DbiInsertRecord(FHandle, dbiNoLock, Buffer));
end;

procedure TBDEDataSet.InternalGotoBookmark(const Bookmark: TBookmark);
begin
  Check(DbiSetToBookmark(FHandle, Bookmark));
end;

procedure TBDEDataSet.InternalSetToRecord(Buffer: TRecordBuffer);
begin
  InternalGotoBookmark(TRecordBuffer(Longint(Buffer) + FBookmarkOfs));
end;

function TBDEDataSet.GetBookmarkFlag(Buffer: TRecordBuffer): TBookmarkFlag;
begin
  with Marshal do
    Result := TBookmarkFlag(ReadByte(Buffer, FRecInfoOfs + 5)); // TBDERecInfo.BookmarkFlag
end;

procedure TBDEDataSet.SetBookmarkFlag(Buffer: TRecordBuffer; Value: TBookmarkFlag);
begin
  with Marshal do
    WriteByte(Buffer, FRecInfoOfs + 5, Byte(Value)); // TBDERecInfo.BookmarkFlag
end;

procedure TBDEDataSet.GetBookmarkData(Buffer: TRecordBuffer; var Data: TBookmark);
begin
  CopyBuffer(IntPtr(Longint(Buffer.ToInt32 + FBookmarkOfs)), Data, BookmarkSize);
end;

procedure TBDEDataset.SetBookmarkData(Buffer: TRecordBuffer; const Data: TBookmark);
begin
  CopyBuffer(Data, IntPtr(Longint(Buffer.ToInt32 + FBookmarkOfs)), BookmarkSize);
end;

const
  RetCodes: array[Boolean, Boolean] of ShortInt = ((2,CMPLess),(CMPGtr,CMPEql));

function TBDEDataSet.CompareBookmarks(const Bookmark1, Bookmark2: TBookmark): Integer;
begin
  { Check for uninitialized bookmarks }
  Result := RetCodes[Bookmark1 = nil, Bookmark2 = nil];
  if Result = 2 then
  begin
    if Handle <> nil then
      DbiCompareBookmarks(Handle, Bookmark1, Bookmark2, Result);
    if Result = CMPKeyEql then Result := CMPEql;
  end;
end;

function TBDEDataSet.BookmarkValid(const Bookmark: TBookmark): Boolean;
begin
  Result := Handle <> nil;
  if Result then
  begin
    CursorPosChanged;
    Result := (DbiSetToBookmark(FHandle, Bookmark) = DBIERR_NONE) and
      (DbiGetRecord(FHandle, dbiNOLOCK, nil, nil) = DBIERR_NONE)
  end;
end;

const
  DEFBLOCKSIZE  = 64 * 1024;

procedure TBDEDataSet.SetBlockReadSize(Value: Integer);

  function CanBlockRead: Boolean;
  var
    i: Integer;
  begin
    Result := (BufferCount <= 1) and (DataSetField = nil);
    if Result then
      for i := 0 to FieldCount - 1 do
        if (Fields[i].DataType in [ftDataSet, ftReference]) then
        begin
          Result := False;
          break;
        end;
  end;

  procedure FreeBuffer;
  begin
    if FBlockReadBuf <> nil then
    begin
      BDEBuffers.FreeHGlobal(FBlockReadBuf);
      FBlockReadBuf := nil;
    end;
  end;

var
  Size: Integer;
begin
  if Value <> BlockReadSize then
  begin
    if Value > 0 then
    begin
      if EOF or not CanBlockRead then Exit;
      FreeBuffer;
      UpdateCursorPos;
      DbiSetProp(HDBIObj(FHandle), curMAKECRACK, 0);
      if Value = MaxInt then
        Size := DEFBLOCKSIZE else
        Size := Value * FRecordSize;
      FBlockReadBuf := BDEBuffers.AllocHGlobal(Size);
      FBlockBufSize := Size div FRecordSize;
      FBlockBufOfs := FBlockBufSize; { Force read of data }
      FBlockBufCount := FBlockBufSize;
      FBlockReadCount := 0;
      inherited;
      BlockReadNext;
    end else
    begin
      inherited;
                           
//      CursorPosChanged;
//      Resync([]);
      FreeBuffer;
    end;
  end;
end;

procedure TBDEDataSet.BlockReadNext;
var
  Status: DbiResult;
begin
  if FBlockBufOfs >= FBlockBufCount - 1 then
  begin
    if FBlockBufCount < FBlockBufSize then Last else
    begin
      Status := DbiReadBlock(FHandle, FBlockBufCount, FBlockReadBuf);
      if (Status <> DBIERR_NONE) and (Status <> DBIERR_EOF) then
        Check(Status);
      if (FBlockBufCount = 0) and (Status = DBIERR_EOF) then Last;
      Inc(FBlockReadCount, FBlockBufCount);
      FBlockBufOfs := 0;
    end
  end else
    Inc(FBlockBufOfs);
  if CalcFieldsSize > 0 then
    GetCalcFields(TempBuffer);
  DataEvent(deDataSetScroll, TObject(Integer(-1)));
end;

{ Index / Ranges }

procedure TBDEDataSet.GetIndexInfo;
var
  IndexDesc: IDXDesc;
begin
  if DbiGetIndexDesc(FHandle, 0, IndexDesc) = DBIERR_NONE then
  begin
    FExpIndex := IndexDesc.bExpIdx;
    FCaseInsIndex := IndexDesc.bCaseInsensitive;
    if not ExpIndex then
    begin
      FIndexFieldCount := IndexDesc.iFldsInKey;
      FIndexFieldMap := IndexDesc.aiKeyFld;
    end;
    FKeySize := IndexDesc.iKeyLen;
  end;
end;

procedure TBDEDataSet.SwitchToIndex(const IndexName, TagName: string);
var
  Status: DBIResult;
begin
  ResetCursorRange;
  UpdateCursorPos;
  Status := DbiSwitchToIndex(FHandle, IndexName, TagName, 0, True);
  if Status = DBIERR_NOCURRREC then
    Status := DbiSwitchToIndex(FHandle, IndexName, TagName, 0, False);
  Check(Status);
  FKeySize := 0;
  FExpIndex := False;
  FCaseInsIndex := False;
  FIndexFieldCount := 0;
  SetBufListSize(0);
  InitBufferPointers(True);
  try
    SetBufListSize(BufferCount + 1);
  except
    SetState(dsInactive);
    CloseCursor;
    raise;
  end;
  GetIndexInfo;
end;

function TBDEDataSet.GetIndexField(Index: Integer): TField;
var
  FieldNo: Integer;
begin
  if (Index < 0) or (Index >= FIndexFieldCount) then
    DatabaseError(SFieldIndexError, Self);
  FieldNo := FIndexFieldMap[Index];
  Result := FieldByNumber(FieldNo);
  if Result = nil then
    DatabaseErrorFmt(SIndexFieldMissing, [FieldDefs[FieldNo - 1].Name], Self);
end;

procedure TBDEDataSet.SetIndexField(Index: Integer; Value: TField);
begin
  GetIndexField(Index).Assign(Value);
end;

function TBDEDataSet.GetIndexFieldCount: Integer;
begin
  Result := FIndexFieldCount;
end;

procedure TBDEDataSet.AllocKeyBuffers;
var
  KeyIndex: TKeyIndex;
begin
  try
    for KeyIndex := Low(TKeyIndex) to High(TKeyIndex) do
      FKeyBuffers[KeyIndex] := InitKeyBuffer(
        BDEBuffers.AllocHGlobal(Marshal.SizeOf(TypeOf(TBDEKeyBuffer)) + FRecordSize));
  except
    FreeKeyBuffers;
    raise;
  end;
end;

procedure TBDEDataSet.FreeKeyBuffers;
var
  KeyIndex: TKeyIndex;
begin
  for KeyIndex := Low(TKeyIndex) to High(TKeyIndex) do
    BDEBuffers.FreeHGlobal(FKeyBuffers[KeyIndex]);
end;

function TBDEDataSet.InitKeyBuffer(Buffer: PKeyBuffer): PKeyBuffer;
begin
  InitializeBuffer(Buffer, Marshal.SizeOf(TypeOf(TBDEKeyBuffer)) + FRecordSize, 0);
  DbiInitRecord(FHandle, PKeyBuffer(Longint(Buffer) + Marshal.SizeOf(TypeOf(TBDEKeyBuffer))));
  Result := Buffer;
end;

procedure TBDEDataSet.CheckSetKeyMode;
begin
  if State <> dsSetKey then DatabaseError(SNotEditing, Self);
end;

function TBDEDataSet.SetCursorRange: Boolean;
var
  RangeStart, RangeEnd: PKeyBuffer;
  StartKey, EndKey: IntPtr;
  IndexBuffer: IntPtr;
  UseStartKey, UseEndKey, UseKey: Boolean;
begin
  Result := False;
  if not (
    BuffersEqual(FKeyBuffers[kiRangeStart], FKeyBuffers[kiCurRangeStart],
      Marshal.SizeOf(TypeOf(TBDEKeyBuffer)) + FRecordSize) and
    BuffersEqual(FKeyBuffers[kiRangeEnd], FKeyBuffers[kiCurRangeEnd],
      Marshal.SizeOf(TypeOf(TBDEKeyBuffer)) + FRecordSize)) then
  begin
    IndexBuffer := Marshal.AllocHGlobal(KeySize * 2);
    try
      UseStartKey := True;
      UseEndKey := True;
      RangeStart := FKeyBuffers[kiRangeStart];
      if Boolean(Marshal.ReadByte(RangeStart)) then
      begin
        StartKey := IntPtr(Longint(RangeStart.ToInt32 + Marshal.SizeOf(TypeOf(TBDEKeyBuffer))));
        UseStartKey := DbiExtractKey(Handle, StartKey, IndexBuffer) = 0;
      end
      else StartKey := nil;
      RangeEnd := FKeyBuffers[kiRangeEnd];
      if Boolean(Marshal.ReadByte(RangeEnd)) then
      begin
        EndKey := IntPtr(Longint(RangeEnd.ToInt32 + Marshal.SizeOf(TypeOf(TBDEKeyBuffer))));
        UseEndKey := DbiExtractKey(Handle, EndKey,
          IntPtr(Longint(IndexBuffer.ToInt32 + KeySize))) = 0;
      end
      else EndKey := nil;
      UseKey := UseStartKey and UseEndKey;
      if UseKey then
      begin
        if StartKey <> nil then StartKey := IndexBuffer;
        if EndKey <> nil then EndKey := IntPtr(Longint(IndexBuffer.ToInt32 + KeySize));
      end;
      with Marshal do
        Check(DbiSetRange(FHandle, UseKey, ReadInt32(RangeStart, 2), 0, StartKey,
          not Boolean(ReadByte(RangeStart, 1)), ReadInt32(RangeEnd, 2), 0, EndKey,
          not Boolean(ReadByte(RangeEnd, 1))));

      CopyBuffer(FKeyBuffers[kiRangeStart], FKeyBuffers[kiCurRangeStart],
        Marshal.SizeOf(TypeOf(TBDEKeyBuffer)) + FRecordSize);
      CopyBuffer(FKeyBuffers[kiRangeEnd], FKeyBuffers[kiCurRangeEnd],
        Marshal.SizeOf(TypeOf(TBDEKeyBuffer)) + FRecordSize);
      DestroyLookupCursor;
      Result := True;
    finally
      Marshal.FreeHGlobal(IndexBuffer);
    end;
  end;
end;

function TBDEDataSet.ResetCursorRange: Boolean;
begin
  Result := False;
  if Boolean(Marshal.ReadByte(FKeyBuffers[kiCurRangeStart])) or
    Boolean(Marshal.ReadByte(FKeyBuffers[kiCurRangeEnd])) then
  begin
    Check(DbiResetRange(FHandle));
    InitKeyBuffer(FKeyBuffers[kiCurRangeStart]);
    InitKeyBuffer(FKeyBuffers[kiCurRangeEnd]);
    DestroyLookupCursor;
    Result := True;
  end;
end;

procedure TBDEDataSet.SetLinkRanges(MasterFields: TList);
var
  I: Integer;
  SaveState: TDataSetState;
begin
  SaveState := SetTempState(dsSetKey);
  try
    FKeyBuffer := InitKeyBuffer(FKeyBuffers[kiRangeStart]);
    Marshal.WriteByte(FKeyBuffer, Byte(True));
    for I := 0 to MasterFields.Count - 1 do
      GetIndexField(I).Assign(TField(MasterFields[I]));
    Marshal.WriteInt32(FKeyBuffer, 2, MasterFields.Count);
  finally
    RestoreState(SaveState);
  end;
  CopyBuffer(FKeyBuffers[kiRangeStart], FKeyBuffers[kiRangeEnd],
    Marshal.SizeOf(TypeOf(TBDEKeyBuffer)) + FRecordSize);
end;

function TBDEDataSet.GetKeyBuffer(KeyIndex: TKeyIndex): PKeyBuffer;
begin
  Result := FKeyBuffers[KeyIndex];
end;

procedure TBDEDataSet.SetKeyBuffer(KeyIndex: TKeyIndex; Clear: Boolean);
begin
  CheckBrowseMode;
  FKeyBuffer := FKeyBuffers[KeyIndex];
  CopyBuffer(FKeyBuffer, FKeyBuffers[kiSave], Marshal.SizeOf(TypeOf(TBDEKeyBuffer)) + FRecordSize);
  if Clear then InitKeyBuffer(FKeyBuffer);
  SetState(dsSetKey);
  SetModified(Boolean(Marshal.REadByte(FKeyBuffer)));
  DataEvent(deDataSetChange, TObject(Integer(0)));
end;

procedure TBDEDataSet.PostKeyBuffer(Commit: Boolean);
begin
  DataEvent(deCheckBrowseMode, nil);
  if Commit then
    Marshal.WriteByte(FKeyBuffer, Byte(Modified))
  else
    CopyBuffer(FKeyBuffers[kiSave], FKeyBuffer,
      Marshal.SizeOf(TypeOf(TBDEKeyBuffer)) + FRecordSize);
  SetState(dsBrowse);
  DataEvent(deDataSetChange, TObject(Integer(0)));
end;

function TBDEDataSet.GetKeyExclusive: Boolean;
begin
  CheckSetKeyMode;
  Result := Boolean(Marshal.ReadByte(FKeyBuffer, 1));
end;

procedure TBDEDataSet.SetKeyExclusive(Value: Boolean);
begin
  CheckSetKeyMode;
  Marshal.WriteByte(FKeyBuffer, 1, Byte(Value));
end;

function TBDEDataSet.GetKeyFieldCount: Integer;
begin
  CheckSetKeyMode;
  Result := Marshal.ReadInt32(FKeyBuffer, 2);
end;

procedure TBDEDataSet.SetKeyFieldCount(Value: Integer);
begin
  CheckSetKeyMode;
  Marshal.WriteInt32(FKeyBuffer, 2, Value);
end;

procedure TBDEDataSet.SetKeyFields(KeyIndex: TKeyIndex;
  const Values: array of const);
var
  I: Integer;
  SaveState: TDataSetState;
begin
  if ExpIndex then DatabaseError(SCompositeIndexError, Self);
  if FIndexFieldCount = 0 then DatabaseError(SNoFieldIndexes, Self);
  SaveState := SetTempState(dsSetKey);
  try
    FKeyBuffer := InitKeyBuffer(FKeyBuffers[KeyIndex]);
    for I := 0 to High(Values) do
      GetIndexField(I).AssignValue(Variant(Values[I]));
    with Marshal do
    begin
      WriteInt32(FKeyBuffer, 2, High(Values) + 1);
      WriteByte(FKeyBuffer, Byte(Modified));
    end;
  finally
    RestoreState(SaveState);
  end;
end;

function TBDEDataSet.GetIsIndexField(Field: TField): Boolean;
var
  I: Integer;
begin
  if (State = dsSetKey) and (FIndexFieldCount = 0) and FExpIndex then
    Result := True else
  begin
    Result := False;
    with Field do
      if FieldNo > 0 then
        for I := 0 to FIndexFieldCount - 1 do
         if FIndexFieldMap[I] = FieldNo then
          begin
            Result := True;
            Exit;
          end;
  end;
end;

function TBDEDataSet.MapsToIndex(Fields: TList;
  CaseInsensitive: Boolean): Boolean;
var
  I: Integer;
  HasStr: Boolean;
begin
  Result := False;
  HasStr := False;
  for I := 0 to Fields.Count - 1 do
  begin
    HasStr := TField(Fields[I]).DataType in [ftString, ftFixedChar, ftWideString];
    if HasStr then break;
  end;
  if (CaseInsensitive <> FCaseInsIndex) and HasStr then Exit;
  if Fields.Count > FIndexFieldCount then Exit;
  for I := 0 to Fields.Count - 1 do
    if TField(Fields[I]).FieldNo <> FIndexFieldMap[I] then Exit;
  Result := True;
end;

{ Filters }

procedure TBDEDataSet.ActivateFilters;
begin
  if FExprFilter <> nil then
  begin
    if DbiActivateFilter(FHandle, FExprFilter) <> DBIERR_NONE then
    begin
      DbiDropFilter(FHandle, FExprFilter);
      FExprFilter := CreateExprFilter(Filter, FilterOptions, 0);
      Check(DbiActivateFilter(FHandle, FExprFilter));
    end;
  end;
  if FFuncFilter <> nil then
  begin
    if DbiActivateFilter(FHandle, FFuncFilter) <> DBIERR_NONE then
    begin
      DbiDropFilter(FHandle, FFuncFilter);
      FFuncFilterDelegate := RecordFilter;
      FFuncFilter := CreateFuncFilter(FFuncFilterDelegate, 1);
      Check(DbiActivateFilter(FHandle, FFuncFilter));
    end;
  end;
end;

procedure TBDEDataSet.DeactivateFilters;
begin
  if FFuncFilter <> nil then Check(DbiDeactivateFilter(FHandle, FFuncFilter));
  if FExprFilter <> nil then Check(DbiDeactivateFilter(FHandle, FExprFilter));
end;

function TBDEDataSet.CreateExprFilter(const Expr: string;
  Options: TFilterOptions; Priority: Integer): HDBIFilter;
var
  Parser: TExprParser;
begin
  Parser := TExprParser.Create(Self, Expr, Options, [], '', nil, FldTypeMap);
  try
    Check(DbiAddFilter(FHandle, 0, Priority, False, Parser.FilterData,
      nil, Result));
  finally
    Parser.Free;
  end;
end;

function TBDEDataSet.CreateFuncFilter(FilterFunc: pfGENFilter;
  Priority: Integer): HDBIFilter;
begin
  Check(DbiAddFilter(FHandle, 0, Priority, False, nil,
    FilterFunc, Result));
end;

{$WARNINGS OFF}
function TBDEDataSet.CreateLookupFilter(Fields: TList; const Values: Variant;
  Options: TLocateOptions; Priority: Integer): HDBIFilter;
var
  I: Integer;
  Filter: TFilterExpr;
  Expr, Node: TExprNode;
  FilterOptions: TFilterOptions;
begin
  if loCaseInsensitive in Options then
    FilterOptions := [foNoPartialCompare, foCaseInsensitive] else
    FilterOptions := [foNoPartialCompare];
  Filter := TFilterExpr.Create(Self, FilterOptions, [], '', nil, FldTypeMap);
  try
    if Fields.Count = 1 then
    begin
      Node := Filter.NewCompareNode(TField(Fields[0]), coEQ, Values);
      Expr := Node;
    end else
      for I := 0 to Fields.Count - 1 do
      begin
        Node := Filter.NewCompareNode(TField(Fields[I]), coEQ, Values[I]);
        if I = 0 then
          Expr := Node else
          Expr := Filter.NewNode(enOperator, coAND, Unassigned, Expr, Node);
      end;
    if loPartialKey in Options then Node.FPartial := True;
    Check(DbiAddFilter(FHandle, 0, Priority, False,
      Filter.GetFilterData(Expr), nil, Result));
  finally
    Filter.Free;
  end;    
end;
{$WARNINGS ON}

procedure TBDEDataSet.SetFilterHandle(var Filter: HDBIFilter;
  Value: HDBIFilter);
begin
  if Filtered then
  begin
    CursorPosChanged;
    DestroyLookupCursor;
    DbiSetToBegin(FHandle);
    if Filter <> nil then DbiDropFilter(FHandle, Filter);
    Filter := Value;
    if Filter <> nil then DbiActivateFilter(FHandle, Filter);
  end else
  begin
    if Filter <> nil then DbiDropFilter(FHandle, Filter);
    Filter := Value;
  end;
end;

procedure TBDEDataSet.SetFilterData(const Text: string; Options: TFilterOptions);
var
  HFilter: HDBIFilter;
begin
  if Active then
  begin
    CheckBrowseMode;
    if (Filter <> Text) or (FilterOptions <> Options) then
    begin
      if Text <> '' then
        HFilter := CreateExprFilter(Text, Options, 0) else
        HFilter := nil;
      SetFilterHandle(FExprFilter, HFilter);
    end;
  end;
  inherited SetFilterText(Text);
  inherited SetFilterOptions(Options);
  if Active and Filtered then First;
end;

procedure TBDEDataSet.SetFilterText(const Value: string);
begin
  SetFilterData(Value, FilterOptions);
end;

procedure TBDEDataSet.SetFiltered(Value: Boolean);
begin
  if Active then
  begin
    CheckBrowseMode;
    if Filtered <> Value then
    begin
      DestroyLookupCursor;
      DbiSetToBegin(FHandle);
      if Value then ActivateFilters else DeactivateFilters;
      inherited SetFiltered(Value);
    end;
    First;
  end else
    inherited SetFiltered(Value);
end;

procedure TBDEDataSet.SetFilterOptions(Value: TFilterOptions);
begin
  SetFilterData(Filter, Value);
end;

procedure TBDEDataSet.SetOnFilterRecord(const Value: TFilterRecordEvent);
var
  Filter: HDBIFilter;
begin
  if Active then
  begin
    CheckBrowseMode;
    if Assigned(OnFilterRecord) <> Assigned(Value) then
    begin
      if Assigned(Value) then
      begin
        FFuncFilterDelegate := RecordFilter;
        Filter := CreateFuncFilter(FFuncFilterDelegate, 1);
      end
      else
        Filter := nil;
      SetFilterHandle(FFuncFilter, Filter);
    end;
    inherited SetOnFilterRecord(Value);
    if Filtered then First;
  end else
    inherited SetOnFilterRecord(Value);
end;

function TBDEDataSet.FindRecord(Restart, GoForward: Boolean): Boolean;
var
  Status: DBIResult;
begin
  CheckBrowseMode;
  DoBeforeScroll;
  SetFound(False);
  UpdateCursorPos;
  CursorPosChanged;
  if not Filtered then ActivateFilters;
  try
    if GoForward then
    begin
      if Restart then Check(DbiSetToBegin(FHandle));
      Status := DbiGetNextRecord(FHandle, dbiNoLock, IntPtr.Zero, nil);
    end else
    begin
      if Restart then Check(DbiSetToEnd(FHandle));
      Status := DbiGetPriorRecord(FHandle, dbiNoLock, nil, nil);
    end;
  finally
    if not Filtered then DeactivateFilters;
  end;
  if Status = DBIERR_NONE then
  begin
    Resync([rmExact, rmCenter]);
    SetFound(True);
  end;
  Result := Found;
  if Result then DoAfterScroll;
end;

function TBDEDataSet.RecordFilter(ulClientData: Longint;
  RecBuf: TRecordBuffer; RecNo: Integer): Smallint;
var
  Accept: Boolean;
  SaveState: TDataSetState;
begin
  SaveState := SetTempState(dsFilter);
  FFilterBuffer := RecBuf;
  try
    Accept := True;
    OnFilterRecord(Self, Accept);
  except
    ApplicationHandleException(Self);
  end;
  RestoreState(SaveState);
  Result := Ord(Accept);
end;

function TBDEDataSet.LocateRecord(const KeyFields: string;
  const KeyValues: Variant; Options: TLocateOptions;
  SyncCursor: Boolean): Boolean;
var
  I, FieldCount, PartialLength: Integer;
  Buffer: TRecordBuffer;
  Fields: TObjectList;
  LookupCursor: HDBICur;
  Filter: HDBIFilter;
  Status: DBIResult;
  CaseInsensitive: Boolean;
begin
  CheckBrowseMode;
  CursorPosChanged;
  Buffer := TempBuffer;
  Fields := TObjectList.Create(False);
  try
    GetFieldList(Fields, KeyFields);
    CaseInsensitive := loCaseInsensitive in Options;
    if CachedUpdates then
      LookupCursor := nil
    else
      if MapsToIndex(Fields, CaseInsensitive) then
        LookupCursor := FHandle else
        LookupCursor := GetLookupCursor(KeyFields, CaseInsensitive);
    if (LookupCursor <> nil) then
    begin
      SetTempState(dsFilter);
      FFilterBuffer := Buffer;
      try
        DbiInitRecord(LookupCursor, Buffer);
        FieldCount := Fields.Count;
        if FieldCount = 1 then
        begin
          if VarIsArray(KeyValues) then
            TField(Fields.First).Value := KeyValues[0] else
            TField(Fields.First).Value := KeyValues;
        end else
          for I := 0 to FieldCount - 1 do
            TField(Fields[I]).Value := KeyValues[I];
        PartialLength := 0;
        if (loPartialKey in Options) and
          (TField(Fields.Last).DataType = ftString) then
        begin
          Dec(FieldCount);
          PartialLength := Length(TField(Fields.Last).AsString);
        end;
        Status := DbiGetRecordForKey(LookupCursor, False, FieldCount,
          PartialLength, Buffer, Buffer);
      finally
        RestoreState(dsBrowse);
      end;
      if (Status = DBIERR_NONE) and SyncCursor and
        (LookupCursor <> FHandle) then
        Status := DbiSetToCursor(FHandle, LookupCursor);
    end else
    begin
      Check(DbiSetToBegin(FHandle));
      Filter := CreateLookupFilter(Fields, KeyValues, Options, 2);
      DbiActivateFilter(FHandle, Filter);
      Status := DbiGetNextRecord(FHandle, dbiNoLock, Buffer, nil);
      DbiDropFilter(FHandle, Filter);
    end;
  finally
    Fields.Free;
  end;
  Result := Status = DBIERR_NONE;
end;

function TBDEDataSet.Lookup(const KeyFields: string; const KeyValues: Variant;
  const ResultFields: string): Variant;
begin
  Result := Null;
  if LocateRecord(KeyFields, KeyValues, [], False) then
  begin
    SetTempState(dsCalcFields);
    try
      CalculateFields(TempBuffer);
      Result := FieldValues[ResultFields];
    finally
      RestoreState(dsBrowse);
    end;
  end;
end;

function TBDEDataSet.Locate(const KeyFields: string;
  const KeyValues: Variant; Options: TLocateOptions): Boolean;
begin
  DoBeforeScroll;
  Result := LocateRecord(KeyFields, KeyValues, Options, True);
  if Result then
  begin
    Resync([rmExact, rmCenter]);
    DoAfterScroll;
  end;
end;

function TBDEDataSet.GetLookupCursor(const KeyFields: string;
  CaseInsensitive: Boolean): HDBICur;
begin
  Result := nil;
end;

procedure TBDEDataSet.DestroyLookupCursor;
begin
end;

function TBDEDataSet.HasConstraints: Boolean;
var
  I: Integer;
begin
  Result := True;
  if Constraints.Count > 0 then Exit;
  for I := 0 to FieldCount - 1 do
    if Fields[I].HasConstraints then Exit;
  Result := False;
end;

function TBDEDataSet.ConstraintsDisabled: Boolean;
begin
  Result := FConstDisableCount > 0;
end;

procedure TBDEDataSet.DisableConstraints;
begin
  if FConstDisableCount = 0 then
    SetBoolProp(Handle, curCONSTSTATE, False);
  Inc(FConstDisableCount);
end;

procedure TBDEDataSet.EnableConstraints;
begin
  if FConstDisableCount <> 0 then
  begin
    Dec(FConstDisableCount);
    if FConstDisableCount = 0 then
      SetBoolProp(Handle, curCONSTSTATE, True);
  end;
end;

function TBDEDataSet.ConstraintCallBack(lUserVal: Integer; Req: DsInfoReq;
  var ADataSources: DataSources): DBIResult;

  function GetFieldConstraint: Boolean;
  var
    Field: TField;
  begin
    Result := False;
    Field := FindField(ADataSources.szSourceFldName);
    if (Field <> nil) and (Field.Required or (Field.ImportedConstraint <> '') or
      (Field.CustomConstraint <> '')) then
    begin
      ADataSources.szSQLExprImport := Field.ImportedConstraint;
      ADataSources.szSQLExprCustom := Field.CustomConstraint;
      ADataSources.szErrStrCustom := Field.ConstraintErrorMessage;
      ADataSources.szErrStrImport := Field.ConstraintErrorMessage;
      ADataSources.bRequired := Field.Required;
      Result := True;
    end;
  end;

  procedure GetTableConstraint;
  begin
    with ADataSources, Constraints[iNumElem - 1] do
    begin
      szSQLExprImport := ImportedConstraint;
      szSQLExprCustom := CustomConstraint;
      szErrStrCustom := ErrorMessage;
      szErrStrImport := ErrorMessage;
    end;
  end;

  function GetDefaultExpression: Boolean;
  var
    Field: TField;
  begin
    Result := False;
    Field := FindField(ADataSources.szSourceFldName);
    if (Field <> nil) and (Field.DefaultExpression <> '') then
    begin
      ADataSources.szSQLExprImport := Field.DefaultExpression;
      Result := True;
    end;
  end;

begin
  Result := DBIERR_NA;
  try
    case Req of
      dsFieldSource: if GetFieldSource(Self, ADataSources) then Result := DBIERR_NONE;
      dsFieldDomainExpr: if GetFieldConstraint then Result := DBIERR_NONE;
      dsFieldDefault: if GetDefaultExpression then Result := DBIERR_NONE;
      dsNumTblConstraint:
        begin
          ADataSources.iNumElem := Constraints.Count;
          Result := DBIERR_NONE;
        end;
      dsTblConstraint:
        begin
          GetTableConstraint;
          Result := DBIERR_NONE;
        end;
    end;
  except
  end;
end;

{ Cached Updates }

procedure TBDEDataSet.AllocCachedUpdateBuffers(Allocate: Boolean);
begin
  if Allocate then
  begin
    FUpdateCBBuf.pNewRecBuf := BDEBuffers.AllocHGlobal(FRecBufSize);
    FUpdateCBBuf.pOldRecBuf := BDEBuffers.AllocHGlobal(FRecBufSize);
    FUpdateCBBuf.iRecBufSize := FRecordSize;
  end else
  begin
    if Assigned(FUpdateCBBuf.pNewRecBuf) then
      BDEBuffers.FreeHGlobal(FUpdateCBBuf.pNewRecBuf);
    if Assigned(FUpdateCBBuf.pOldRecBuf) then
      BDEBuffers.FreeHGlobal(FUpdateCBBuf.pOldRecBuf);
  end;
end;

procedure TBDEDataSet.CheckCachedUpdateMode;
begin
  if not CachedUpdates then DatabaseError(SNoCachedUpdates, Self);
end;

function TBDEDataSet.UpdateCallbackRequired: Boolean;
begin
  Result := FCachedUpdates and (Assigned(FOnUpdateError) or
    Assigned(FOnUpdateRecord) or Assigned(FUpdateObject));
end;

function TBDEDataSet.ForceUpdateCallback: Boolean;
begin
  Result := FCachedUpdates and (Assigned(FOnUpdateRecord) or
    Assigned(FUpdateObject));
end;

procedure TBDEDataSet.SetCachedUpdates(Value: Boolean);

  procedure ReAllocBuffers;
  begin
    FreeFieldBuffers;
    FreeKeyBuffers;
    SetBufListSize(0);
    try
      InitBufferPointers(True);
      SetBufListSize(BufferCount + 1);
      AllocKeyBuffers;
    except
      SetState(dsInactive);
      CloseCursor;
      raise;
    end;
  end;

begin
  if (State = dsInActive) or (csDesigning in ComponentState) then
    FCachedUpdates := Value
  else if FCachedUpdates <> Value then
  begin
    CheckBrowseMode;
    UpdateCursorPos;
    if FConstraintLayer then DbiEndConstraintLayer(FHandle);
    if FCachedUpdates then
      Check(DbiEndDelayedUpdates(FHandle)) else
      Check(DbiBeginDelayedUpdates(FHandle));
    if FConstraintLayer then
    begin
      FConstraintCBDelegate := ConstraintCallBack;
      Check(DbiBeginConstraintLayer(nil, FHandle, FConstraintCBDelegate, 0));
    end;
    FCachedUpdates := Value;
    ReAllocBuffers;
    AllocCachedUpdateBuffers(Value);
    SetupCallBack(UpdateCallBackRequired);
    Resync([]);
  end;
end;

procedure TBDEDataSet.SetupCallBack(Value: Boolean);
var
  Buf: IntPtr;
begin
  if Value then
  begin
    if (csDesigning in ComponentState) then Exit;
    if not Assigned(FUpdateCallback) then
    begin
      FCachedUpdateCBDelegate := CachedUpdateCallBack;
      Buf := BDEBuffers.AllocHGlobal(Marshal.SizeOf(TypeOf(DELAYUPDCbDesc)));
      Marshal.StructureToPtr(TObject(FUpdateCBBuf), Buf, False);
      FUpdateCallback := TBDECallback.Create(Self, Self.Handle, cbDELAYEDUPD,
        Buf, Marshal.SizeOf(TypeOf(DELAYUPDCbDesc)), FCachedUpdateCBDelegate, True);
    end;
  end
  else
  begin
    if Assigned(FUpdateCallback) then
    begin
      FUpdateCallback.Free;
      FUpdateCallback := nil;
    end;
  end;
end;

function TBDEDataSet.ProcessUpdates(UpdCmd: DBIDelayedUpdCmd): DBIResult;
begin
  CheckCachedUpdateMode;
  UpdateCursorPos;
  Result := DbiApplyDelayedUpdates(Handle, UpdCmd);
end;

procedure TBDEDataSet.ApplyUpdates;
var
  Status: DBIResult;
begin
  if State <> dsBrowse then Post;
  Status := ProcessUpdates(dbiDelayedUpdPrepare);
  if Status <> DBIERR_NONE then
    if Status = DBIERR_UPDATEABORT then SysUtils.Abort
    else DbiError(Status);
end;

procedure TBDEDataSet.CommitUpdates;
begin
  Check(ProcessUpdates(dbiDelayedUpdCommit));
  Resync([]);
end;

procedure TBDEDataSet.CancelUpdates;
begin
  Cancel;
  ProcessUpdates(dbiDelayedUpdCancel);
  if Active then
    Resync([]);
end;

procedure TBDEDataSet.RevertRecord;
var
  Status: DBIResult;
begin
  if State in dsEditModes then Cancel;
  Status := ProcessUpdates(dbiDelayedUpdCancelCurrent);
  if not ((Status = DBIERR_NONE) or (Status = DBIERR_NOTSUPPORTED)) then
    Check(Status);
  Resync([]);
end;

function TBDEDataSet.UpdateStatus: TUpdateStatus;
var
  BufPtr: TRecordBuffer;
begin
  if CachedUpdates then
  begin
    if State = dsCalcFields then
      BufPtr := CalcBuffer
    else
      BufPtr := ActiveBuffer;
    Result := TUpdateStatus(Marshal.ReadByte(BufPtr, FRecInfoOfs + 4));
  end
  else
    Result := usUnModified;
end;

const
  CBRetCode: array[TUpdateAction] of CBRType = (cbrAbort, cbrAbort,
    cbrSkip, cbrRetry, cbrPartialAssist);

function TBDEDataSet.CachedUpdateCallBack(CBInfo: IntPtr): CBRType;
var
  UpdateAction: TUpdateAction;
  UpdateKind: TUpdateKind;
begin
  FInUpdateCallBack := True;
  UpdateAction := uaFail;
  FUpdateCBBuf := DELAYUPDCbDesc(Marshal.PtrToStructure(CBInfo, TypeOf(DELAYUPDCbDesc)));
  UpdateKind := TUpdateKind(ord(FUpdateCBBuf.eDelayUpdOpType)-1);
  try
    if Assigned(FOnUpdateRecord) then
      FOnUpdateRecord(Self, UpdateKind, UpdateAction)
    else
      if Assigned(FUpdateObject) then
      begin
        FUpdateObject.Apply(UpdateKind);
        UpdateAction := uaApplied;
      end
    else
      DbiError(FUpdateCBBuf.iErrCode);
  except
    on E: Exception do
    begin
      if E is EDBEngineError then
        FUpdateCBBuf.iErrCode := EDBEngineError(E).Errors[0].ErrorCode;
      if (E is EDatabaseError) and Assigned(FOnUpdateError) then
        FOnUpdateError(Self, EDatabaseError(E), UpdateKind, UpdateAction)
      else
      begin
        ApplicationHandleException(Self);
        UpdateAction := uaAbort;
      end;
    end;
  end;
  Result := CBRetCode[UpdateAction];
  if UpdateAction = uaAbort then
    FUpdateCBBuf.iErrCode := DBIERR_UPDATEABORT;
  FInUpdateCallBack := False;
  Marshal.StructureToPtr(TObject(FUpdateCBBuf), CBInfo, True);
end;

function TBDEDataSet.GetUpdateRecordSet: TUpdateRecordTypes;
begin
  if Active then
  begin
    CheckCachedUpdateMode;
    Result := TUpdateRecordTypes(Byte(GetIntProp(FHandle, curDELAYUPDDISPLAYOPT)));
  end
  else
    Result := [];
end;

procedure TBDEDataSet.SetUpdateRecordSet(RecordTypes: TUpdateRecordTypes);
begin
  CheckCachedUpdateMode;
  CheckBrowseMode;
  UpdateCursorPos;
  Check(DbiSetProp(hDbiObj(Handle), curDELAYUPDDISPLAYOPT, Longint(Byte(RecordTypes))));
  Resync([]);
end;

procedure TBDEDataSet.SetUpdateObject(Value: TDataSetUpdateObject);
begin
  if Value <> FUpdateObject then
  begin
    if Assigned(FUpdateObject) and (FUpdateObject.DataSet = Self) then
      FUpdateObject.DataSet := nil;
    FUpdateObject := Value;
    if Assigned(FUpdateObject) then
    begin
      { If another dataset already references this updateobject, then
        remove the reference }
      if Assigned(FUpdateObject.DataSet) and
        (FUpdateObject.Dataset is TBDEDataset) and 
        (FUpdateObject.DataSet <> Self) then
        TBDEDataset(FUpdateObject.DataSet).UpdateObject := nil; 
      FUpdateObject.DataSet := Self;
    end;
  end;
end;

procedure TBDEDataSet.SetOnUpdateError(UpdateEvent: TUpdateErrorEvent);
begin
  if Active then SetupCallback(UpdateCallBackRequired);
  FOnUpdateError := UpdateEvent;
end;

function TBDEDataSet.GetUpdatesPending: Boolean;
begin
  Result := GetIntProp(FHandle, curDELAYUPDNUMUPDATES) > 0;
end;

procedure TBDEDataSet.DataEvent(Event: TDataEvent; Info: TObject);

  procedure CheckIfParentScrolled;
  var
    ParentPosition, I: Integer;
  begin
    ParentPosition := 0;
    with FParentDataSet do
      if not IsEmpty then
        for I := 0 to BookmarkSize - 1 do
          ParentPosition := ParentPosition +
            Marshal.ReadByte(ActiveBuffer, FBookmarkOfs + I);
    if (FLastParentPos = 0) or (ParentPosition <> FLastParentPos) then
    begin
      First;
      FLastParentPos := ParentPosition;
    end else
    begin
      UpdateCursorPos;
      Resync([]);
    end;
  end;

begin
  if Event = deParentScroll then CheckIfParentScrolled;
  inherited DataEvent(Event, Info);
end;

{ TBDEDataSet.IProviderSupport}

function TBDEDataSet.PSGetUpdateException(E: Exception; Prev: EUpdateError): EUpdateError;
var
  PrevErr: Integer;
begin
  if E is EDBEngineError then
  begin
    if Prev <> nil then
      PrevErr := Prev.ErrorCode else
      PrevErr := 0;
    with EDBEngineError(E).Errors[0] do
      Result := EUpdateError.Create(E.Message, '', ErrorCode, PrevErr, E);
  end else
    Result := inherited PSGetUpdateException(E, Prev);
end;

function TBDEDataSet.PSIsSQLSupported: Boolean;
begin
  Result := True;
end;

procedure TBDEDataSet.PSReset;
begin
  inherited PSReset;
  if Handle <> nil then
    DbiForceReread(Handle);
end;

function TBDEDataSet.PSUpdateRecord(UpdateKind: TUpdateKind; Delta: TDataSet): Boolean;
var
  UpdateAction: TUpdateAction;
begin
  Result := False;
  if Assigned(OnUpdateRecord) then
  begin
    UpdateAction := uaFail;
    if Assigned(FOnUpdateRecord) then
    begin
      FOnUpdateRecord(Delta, UpdateKind, UpdateAction);
      Result := UpdateAction = uaApplied;
    end;
  end;
end;

{ TNestedTable }

constructor TNestedTable.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ObjectView := True;
end;

function TNestedTable.CreateHandle: HDBICur;
var
  PHandle: HDBICur;
begin
  if not Assigned(DataSetField) then DatabaseError(SNoDataSetField, Self);
  FParentDataSet := (DataSetField.DataSet as TBDEDataSet);
  OpenParentDataSet(FParentDataSet);
  PHandle := FParentDataSet.Handle;
  with DataSetField do
    if DataType = ftDataSet then
      Check(DbiOpenNestedTable(PHandle, FieldNo, ReadOnly, False, Result)) else
      Check(DbiOpenRef(PHandle, FieldNo, ReadOnly, False, Result));
  FieldDefs.HiddenFields := FParentDataSet.FieldDefs.HiddenFields;
  if DataSetField.IncludeObjectField then
    FieldNoOfs := 1 else
    FieldNoOfs := 2;
end;

procedure TNestedTable.DoAfterPost;
var
  RefSize: Word;
  RefBuffer: TBytes;
begin
  { Assign the reference ID to the DataSetField }
  if DataSetField.DataType = ftReference then
  begin
    SetLength(RefBuffer, 256);
    Check(DbiGetProp(hDBIObj(FHandle), curGETREF, RefBuffer,
      Length(RefBuffer), RefSize));
    if RefSize <= DataSetField.DataSize then
    begin
      SetLength(RefBuffer, RefSize);
      DataSetField.AsVariant := RefBuffer;
    end;
  end;
  inherited;
end;

procedure TNestedTable.DoBeforeInsert;
begin
  inherited DoBeforeInsert;
  if (DataSetField.DataType = ftDataSet) and (FParentDataSet.State = dsInsert) then
    FParentDataSet.Post;
end;

procedure TNestedTable.InternalPost;
begin
  inherited;
  if (DataSetField.DataType = ftReference) and (State = dsInsert) then
  begin
    if TReferenceField(DataSetField).ReferenceTableName = '' then
      DatabaseErrorFmt(SNoReferenceTableName, [DataSetField.DisplayName]);
    Check(DbiSetProp(hDBIObj(FHandle), curREFINSERTTABLENAME,
      TReferenceField(DataSetField).ReferenceTableName));
  end;
  inherited;
end;

{ TDBDataSet }

constructor TDBDataSet.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  if AOwner is TDatabase then
  begin
    DatabaseName := TDatabase(AOwner).DatabaseName;
    SessionName := TDatabase(AOwner).SessionName;
  end;
  FAutoRefresh := False;
end;

procedure TDBDataSet.SetHandle(Value: HDBICur);
begin
  Close;
  FHandle := Value;
  if Assigned(Value) then
  try
    Open;
  except
    FHandle := nil;
    raise;
  end;
end;

procedure TDBDataSet.OpenCursor(InfoQuery: Boolean);
begin
  SetDBFlag(dbfOpened, True);
  inherited OpenCursor(InfoQuery);
  SetUpdateMode(FUpdateMode);
  if Database.IsSQLBased then
    SetupAutoRefresh
end;

procedure TDBDataSet.CloseCursor;
begin
  inherited CloseCursor;
  SetDBFlag(dbfOpened, False);
end;

procedure TDBDataSet.CheckDBSessionName;
var
  S: TSession;
  Database: TDatabase;
begin
  if (SessionName <> '') and (DatabaseName <> '') then
  begin
    S := Sessions.FindSession(SessionName);
    if Assigned(S) and not Assigned(S.DoFindDatabase(DatabaseName, Self)) then
    begin
      Database := DefaultSession.DoFindDatabase(DatabaseName, Self);
      if Assigned(Database) then Database.CheckSessionName(True);
    end;
  end;
end;

function TDBDataSet.CheckOpen(Status: DBIResult): Boolean;
begin
  case Status of
    DBIERR_NONE:
      Result := True;
    DBIERR_NOTSUFFTABLERIGHTS:
      begin
        if not DBSession.GetPassword then DbiError(Status);
        Result := False;
      end;
  else
    DbiError(Status);
    Result := False;
  end;
end;

function TDBDataSet.ConstraintsStored: Boolean;
begin
  Result := Constraints.Count > 0;
end;

procedure TDBDataSet.Disconnect;
begin
  Close;
end;

function TDBDataSet.GetDBHandle: HDBIDB;
begin
  if FDatabase <> nil then
    Result := FDatabase.Handle else
    Result := nil;
end;

function TDBDataSet.GetDBLocale: TLocale;
begin
  if Database <> nil then
    Result := Database.Locale else
    Result := nil;
end;

function TDBDataSet.GetDBSession: TSession;
begin
  if (FDatabase <> nil) then
    Result := FDatabase.Session else
    Result := Sessions.FindSession(SessionName);
  if Result = nil then Result := DefaultSession;
end;

function TDBDataSet.OpenDatabase: TDatabase;
begin
  with Sessions.List[FSessionName] do
    Result := DoOpenDatabase(FDatabasename, Self.Owner);
end;

procedure TDBDataSet.CloseDatabase(Database: TDatabase);
begin
  if Assigned(Database) then
    Database.Session.CloseDatabase(Database);
end;

procedure TDBDataSet.SetDatabaseName(const Value: string);
begin
  if csReading in ComponentState then
    FDatabaseName := Value
  else if FDatabaseName <> Value then
  begin
    CheckInactive;
    if FDatabase <> nil then DatabaseError(SDatabaseOpen, Self);
    FDatabaseName := Value;
    DataEvent(dePropertyChange, nil);
  end;
end;

function TDBDataSet.SetDBFlag(Flag: Integer; Value: Boolean): Boolean;
begin
  Result := Flag in DBFlags;
  if Value then
  begin
    if not Result then
    begin
      if FDBFlags = [] then
      begin
        CheckDBSessionName;
        FDatabase := OpenDatabase;
        FDatabase.RegisterClient(Self);
        SetLocale(FDatabase.Locale);
        if FDatabase.Temporary and (csDesigning in ComponentState) then
          FDatabase.Session.LoadSMClient(True);
      end;
      Include(FDBFlags, Flag);
    end;
  end else
  begin
    if Result then
    begin
      Exclude(FDBFlags, Flag);
      if FDBFlags = [] then
      begin
        SetLocale(DBLocale);
        FDatabase.UnregisterClient(Self);
        FDatabase.Session.CloseDatabase(FDatabase);
        FDatabase := nil;
      end;
    end;
  end;
end;

procedure TDBDataSet.SetSessionName(const Value: string);
begin
  CheckInactive;
  FSessionName := Value;
  DataEvent(dePropertyChange, nil);
end;

procedure TDBDataSet.SetUpdateMode(const Value: TUpdateMode);
begin
  if (FHandle <> nil) and Database.IsSQLBased and CanModify then
    Check(DbiSetProp(hDbiObj(FHandle), curUPDLOCKMODE, Longint(Value)));
  FUpdateMode := Value;
end;

{ AutoRefresh }
procedure TDBDataSet.SetAutoRefresh(const Value: Boolean);
begin
  CheckInactive;
  FAutoRefresh := Value;
end;

const
  PropFlags: array[TAutoRefreshFlag] of LongInt = (0, curFIELDISAUTOINCR, curFIELDISDEFAULT);

procedure TDBDataSet.SetupAutoRefresh;
var
  I: Integer;
  ColDesc: ServerColDesc;
begin
  if AutoRefresh then
    Check(DbiSetProp(hDbiObj(FHandle), curAUTOREFETCH, Longint(True)));

  for I := 0 to Fields.Count - 1 do
    with Fields[I] do
      if AutoGenerateValue <> arNone then
      begin
        ColDesc.iFldNum := I + 1;
        ColDesc.bServerCol := True;
        Check(DbiSetProp(hDbiObj(FHandle), PropFlags[AutoGenerateValue], ColDesc));
      end;
end;

{ TDBDataSet.IProviderSupport }

procedure TDBDataSet.PSGetAttributes(List: TList);
var
  Ofs: Integer;
  Attr: TPacketAttribute;
begin
  inherited PSGetAttributes(List);
  if Locale <> nil then
  begin
    with Attr do
    begin
      Name := 'LCID';
      Ofs := Integer(Marshal.OffsetOf(TypeOf(TOSBLObj), 'LdLCID'));
      Value := Marshal.ReadInt32(Locale, Ofs); // TOSBLObj(Locale).LdLCID
      IncludeInDelta := False;
    end;
    List.Add(TObject(Attr));
  end;
end;

function TDBDataSet.PSIsSQLBased: Boolean;
var
  InProvider: Boolean;
begin
  InProvider := SetDBFlag(dbfProvider, True);
  try
    Result := Database.IsSQLBased;
  finally
    SetDBFlag(dbfProvider, InProvider);
  end;
end;

function TDBDataSet.PSGetQuoteChar: string;
var
  Q: Char;
  Len: Word;
  InProvider: Boolean;
begin
  InProvider := SetDBFlag(dbfProvider, True);
  try
    Result := '';
    if PSIsSQLBased then
    begin
      Q := #0;
      DbiGetProp(HDBIObj(Database.Handle), dbQUOTECHAR, Q, SizeOf(Q), Len);
      if Q <> #0 then
        Result := Q;
    end else
      Result := '"';
  finally
    SetDBFlag(dbfProvider, InProvider);
  end;
end;

function TDBDataSet.PSInTransaction: Boolean;
var
  Database: TDatabase;
begin
  Result := False;
  if Assigned(Sessions.List[SessionName]) then
  begin
    Database := Sessions.List[SessionName].DoFindDatabase(DatabaseName, Owner);
    Result := Assigned(Database) and Database.InTransaction;
  end;
end;

procedure TDBDataSet.PSStartTransaction;
begin
  SetDBFlag(dbfProvider, True);
  try
    if not PSIsSQLBased then
      Database.TransIsolation := tiDirtyRead;
    Database.StartTransaction;
  except
    SetDBFlag(dbfProvider, False);
    raise;
  end;
end;

const
  EndType: array[Boolean] of eXEnd = (xendABORT, xendCOMMIT);

procedure TDBDataSet.PSEndTransaction(Commit: Boolean);
begin
  try
    Database.ClearStatements;
    Database.EndTransaction(EndType[Commit]);
  finally
    SetDBFlag(dbfProvider, False);
  end;
end;

function TDBDataSet.PSExecuteStatement(const ASQL: string; AParams: TParams;
  var ResultSet: TObject): Integer;
var
  InProvider: Boolean;
  Cursor: hDBICur;
begin
  InProvider := SetDBFlag(dbfProvider, True);
  try
    Result := Database.Execute(ASQL, AParams, True, Cursor);
    ResultSet := TDBDataSet.Create(nil);
    TDBDataSet(ResultSet).SetHandle(Cursor);
  finally
    SetDBFlag(dbfProvider, InProvider);
  end;
end;

function TDBDataSet.PSUpdateRecord(UpdateKind: TUpdateKind; Delta: TDataSet): Boolean;

  procedure AssignParams(DataSet: TDataSet; Params: TParams);
  var
    I: Integer;
    Old: Boolean;
    Param: TParam;
    PName: string;
    Field: TField;
    Value: Variant;
  begin
    for I := 0 to Params.Count - 1 do
    begin
      Param := Params[I];
      PName := Param.Name;
      Old := CompareText(Copy(PName, 1, 4), 'OLD_') = 0;
      if Old then Borland.Delphi.System.Delete(PName, 1, 4);
      Field := DataSet.FindField(PName);
      if not Assigned(Field) then Continue;
      if Old then Param.AssignFieldValue(Field, Field.OldValue) else
      begin
        Value := Field.NewValue;
        if VarIsClear(Value) then Value := Field.OldValue;
        Param.AssignFieldValue(Field, Value);
      end;
    end;
  end;

{var
  SQL: string;
  Params: TParams;}
begin
  Result := inherited PSUpdateRecord(UpdateKind, Delta);
  if not Result and Assigned(FUpdateObject) and (FUpdateObject is TUpdateSQL) then
  begin
//    TUpdateSQL(FUpdateObject).Dataset := Delta;
    TUpdateSQL(FUpdateObject).DatabaseName := DatabaseName;
    TUpdateSQL(FUpdateObject).SessionName := SessionName;
    TUpdateSQL(FUpdateObject).Apply(Delta, UpdateKind);

    // USQL.Apply calls USQL.ExecSQL, which raises an exception if RowsAffected<>1
    Result := True;
                                 {    SQL := TSQLUpdateObject(FUpdateObject).GetSQL(UpdateKind).Text;
    if SQL <> '' then
    begin
      Params := TParams.Create;
      try
        Params.ParseSQL(SQL, True);
        TSQLUpdateObject(FUpdateObject).Dataset := Delta;
        TSQLUpdateObject(FUpdateObject).DatabaseName := '';
        TSQLUpdateObject(FUpdateObject).SetParams(UpdateKind);
        TSQLUpdateObject(FUpdateObject).ExecSQL;
        if PSExecuteStatement(SQL, Params) = 0 then
          DatabaseError(SRecordChanged);
        Result := True;
      finally
        Params.Free;
      end;
    end;}
  end;
end;

{ TBatchMove }

constructor TBatchMove.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FAbortOnKeyViol := True;
  FAbortOnProblem := True;
  FTransliterate := True;
  FMappings := TStringList.Create;
end;

destructor TBatchMove.Destroy;
begin
  FMappings.Free;
  inherited Destroy;
end;

function TBatchMove.ConvertName(const Name: string): string;
begin
  if Name <> '' then
    Result := AnsiToNative(nil, Name, DBIMAXTBLNAMELEN);
end;

procedure TBatchMove.Execute;
type
  TFieldMap = array of Word;
var
  SourceActive, DestinationActive: Boolean;
  BatchMode: TBatchMode;
  I: Integer;
  FieldCount: Word;
  FieldMap: TFieldMap;
  DestName, SourceName: string;

  procedure GetMappingNames;
  var
    P: Integer;
    Mapping: string;
  begin
    Mapping := FMappings[I];
    P := Pos('=', Mapping);
    if P > 0 then
    begin
      DestName := Copy(Mapping, 1, P - 1);
      SourceName := Copy(Mapping, P + 1, 255);
    end else
    begin
      DestName := Mapping;
      SourceName := Mapping;
    end;
  end;

begin
  if (Destination = nil) or (Source = nil) or (Destination = Source) then
    DatabaseError(SInvalidBatchMove, Self);
  SourceActive := Source.Active;
  DestinationActive := Destination.Active;
  FieldCount := 0;
  FieldMap := nil;
  try
    Source.DisableControls;
    Destination.DisableControls;
    Source.Open;
    Source.CheckBrowseMode;
    Source.UpdateCursorPos;
    BatchMode := FMode;
    if BatchMode = batCopy then
    begin
      Destination.Close;
      if FMappings.Count = 0 then
        Destination.FieldDefs := Source.FieldDefs
      else
      begin
        Destination.FieldDefs.Clear;
        for I := 0 to FMappings.Count - 1 do
        begin
          GetMappingNames;
          with Source.FieldDefs.Find(SourceName) do
            Destination.FieldDefs.Add(DestName, DataType, Size, Required);
        end;
      end;
      Destination.IndexDefs.Clear;
      Destination.CreateTable;
      BatchMode := batAppend;
    end;
    Destination.Open;
    Destination.CheckBrowseMode;
    if FMappings.Count <> 0 then
    begin
      FieldCount := Destination.FieldDefs.Count;
      SetLength(FieldMap, FieldCount);
      for I := 0 to FMappings.Count - 1 do
      begin
        GetMappingNames;
        FieldMap[Destination.FieldDefs.Find(DestName).FieldNo-1] :=
          Source.FieldDefs.Find(SourceName).FieldNo;
      end;
    end;
    if FRecordCount > 0 then
    begin
      Source.UpdateCursorPos;
      FMovedCount := FRecordCount;
    end else
    begin
      Check(DbiSetToBegin(Source.Handle));
      FMovedCount := MaxLongint;
    end;
    Source.CursorPosChanged;
    try
      if CommitCount > 0 then
        Check(DbiSetProp(hDBIObj(Destination.DBHandle), dbBATCHCOUNT, CommitCount));
      Check(DbiBatchMove(nil, Source.Handle, nil, Destination.Handle,
        EBATMode(BatchMode), FieldCount, FieldMap, nil, nil, 0,
        ConvertName(FKeyViolTableName),
        ConvertName(FProblemTableName),
        ConvertName(FChangedTableName),
        FProblemCount, FKeyViolCount, FChangedCount,
        FAbortOnProblem, FAbortOnKeyViol, FMovedCount, FTransliterate));
    finally
      if DestinationActive then Destination.First;
    end;
  finally
    if not DestinationActive then Destination.Close;
    if not SourceActive then Source.Close;
    Destination.EnableControls;
    Source.EnableControls;
  end;
end;

procedure TBatchMove.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if Operation = opRemove then
  begin
    if Destination = AComponent then Destination := nil;
    if Source = AComponent then Source := nil;
  end;
end;

procedure TBatchMove.SetMappings(Value: TStrings);
begin
  FMappings.Assign(Value);
end;

procedure TBatchMove.SetSource(Value: TBDEDataSet);
begin
  FSource := Value;
  if Value <> nil then Value.FreeNotification(Self);
end;

{ TIndexFiles }

constructor TIndexFiles.Create(AOwner: TTable);
begin
  inherited Create;
  FOwner := AOwner;
end;

function TIndexFiles.Add(const S: string): Integer;
begin
  with FOwner do
  begin
    if Active then OpenIndexFile(S);
    IndexDefs.Updated := False;
  end;
  Result := inherited Add(S);
end;

procedure TIndexFiles.Clear;
var
  I: Integer;
begin
  with FOwner do
    if Active then
      for I := 0 to Count - 1 do CloseIndexFile(Strings[I]);
  inherited Clear;
end;

procedure TIndexFiles.Insert(Index: Integer; const S: string);
begin
  inherited Insert(Index, S);
  with FOwner do
  begin
    if Active then OpenIndexFile(S);
    IndexDefs.Updated := False;
  end;
end;

procedure TIndexFiles.Delete(Index: Integer);
begin
  with FOwner do
  begin
    if Active then CloseIndexFile(Strings[Index]);
    IndexDefs.Updated := False;
  end;
  inherited Delete(Index);
end;

{ TTable }

constructor TTable.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FIndexDefs := TIndexDefs.Create(Self);
  FMasterLink := TMasterDataLink.Create(Self);
  FMasterLink.OnMasterChange := MasterChanged;
  FMasterLink.OnMasterDisable := MasterDisabled;
  FIndexFiles := TIndexFiles.Create(Self);
  FDefaultIndex := True;
  FRanged := False;
end;

destructor TTable.Destroy;
begin
  inherited Destroy;
  FIndexFiles.Free;
  FMasterLink.Free;
  FIndexDefs.Free;
end;

function TTable.GetHandle(const IndexName, IndexTag: string): HDBICur;
var
  SIndexName: StringBuilder;
  OpenMode: DbiOpenMode;
  RetCode: DbiResult;
  IndexID: Word;
  I: Integer;
begin
  Result := nil;
  OpenMode := OpenModes[FReadOnly or ForceUpdateCallback];
  if DefaultIndex then
    IndexID := 0 else
    IndexID := NODEFAULTINDEX;
  while True do
  begin
    RetCode := DbiOpenTable(DBHandle, NativeTableName, GetTableTypeName,
      IndexName, IndexTag, IndexID, OpenMode, ShareModes[FExclusive],
      xltField, False, nil, Result);
    if RetCode = DBIERR_TABLEREADONLY then
      OpenMode := dbiReadOnly
    else if CheckOpen(RetCode) then Break;
  end;
  if IsXBaseTable then
    for I := 0 to IndexFiles.Count - 1 do
    begin
      SIndexName := StringBuilder.Create(DBIMAXTBLNAMELEN + 1);
      CharToOemA(IndexFiles[I], SIndexName);
      CheckIndexOpen(DbiOpenIndex(Result, SIndexName.ToString, 0));
    end;
end;

function TTable.CreateHandle: HDBICur;
var
  CursorLocale: TLocale;
  IndexName, IndexTag: string;
begin
  if FTableName = '' then DatabaseError(SNoTableName, Self);
  IndexDefs.Updated := False;
  if Database.IsSQLBased then
  begin
    GetIndexParams(FIndexName, FFieldsIndex, IndexName, IndexTag);
    Result := GetHandle(IndexName, IndexTag);
  end else
  begin
    { For local tables, open the table first then switch the index }
    Result := GetHandle('', '');
    { Set the FHandle & Locale before calling GetIndexParams }
    FHandle := Result;
    if DbiGetLdObj(Result, CursorLocale) = 0 then SetLocale(CursorLocale);
    GetIndexParams(FIndexName, FFieldsIndex, IndexName, IndexTag);
    if (IndexName <> '') and IsProductionIndex(IndexName) then
       Check(DbiSwitchToIndex(Result, IndexName, IndexTag, 0, False));
  end;
end;

function TTable.GetLanguageDriverName: string;
var
  TblName: DBITBLNAME;
  Buffer: StringBuilder;
  //LdName: DBINAME;
  DriverName: string;
  S: string;
  FDb: Boolean;
begin
  FDb := SetDBFlag(dbfDatabase, True);
  try
    Buffer := StringBuilder.Create(DBIMAXTBLNAMELEN + 1);
    if Database.IsSQLBased then
    begin
      DriverName := DBSession.GetAliasDriverName(DatabaseName);
      FmtStr(S, ':%s:%s', [DatabaseName, TableName]);
      TblName := AnsiToNative(DBLocale, S, DBIMAXTBLNAMELEN);
    end
    else
    begin
      DbiFormFullName(Database.Handle, NativeTableName, nil, Buffer);
      TblName := Buffer.ToString;
      DriverName := GetTableTypeName;
    end;
    { If the table does not exist, get the language driver for the driver }
    if Buffer.Length > 0 then
      Buffer.Length := 0;
    Buffer.Capacity := DBIMAXNAMELEN + 1;
    if DbiGetLdName(DriverName, TblName, Buffer) <> 0 then
      DbiGetLdName(DriverName, nil, Buffer);
  finally
    SetDBFlag(dbfDatabase, FDb);
  end;
  Result := Buffer.ToString;
end;

function TTable.SetTempLocale(ActiveCheck: Boolean): TLocale;
var
  LName: string;
  TempLocale: TLocale;
begin
  if not ActiveCheck or (FHandle = nil) then
  begin
    Result := Locale;
    LName := GetLanguageDriverName;
    if (LName <> '') and (OsLdLoadBySymbName(LName, TempLocale) = 0) then
      if TempLocale <> Locale then
        SetLocale(TempLocale) else
        OsLdUnloadObj(TempLocale);
  end else
  begin
    if DbiGetLdObj(FHandle, TempLocale) = 0 then SetLocale(TempLocale);
    Result := TempLocale;
  end;
end;

procedure TTable.RestoreLocale(LocaleSave: TLocale);
begin
  if (LocaleSave <> Locale) and (Locale <> nil) then
  begin
    OsLdUnloadObj(FLocale);
    SetLocale(LocaleSave);
  end;
end;

procedure TTable.PrepareCursor;
var
  IndexName, IndexTag: string;
begin
  if IsXBaseTable then
  begin
    GetIndexParams(FIndexName, FFieldsIndex, IndexName, IndexTag);
    if not IsProductionIndex(IndexName) then SwitchToIndex(IndexName, IndexTag);
  end;
  CheckMasterRange;
end;

procedure TTable.DefChanged(Sender: TObject);
begin
  StoreDefs := True;
end;

procedure TTable.InitFieldDefs;
var
  I, FieldID, FldDescCount: Integer;
  FieldDescs: TFieldDescList;
  FCursor, VCursor: HDBICur;
  RequiredFields: TBits;
  ValCheckDesc: VCHKDesc;
  LocaleSave: TLocale;
begin
  if (FHandle <> nil) then InternalInitFieldDefs else
  begin
    SetDBFlag(dbfFieldList, True);
    try
      if FTableName = '' then DatabaseError(SNoTableName, Self);
      LocaleSave := SetTempLocale(True);
      try
        while not CheckOpen(DbiOpenFieldList(DBHandle, NativeTableName,
          GetTableTypeName, False, FCursor)) do {Retry};
        try
          Check(DbiGetRecordCount(FCursor, FldDescCount));
          SetLength(FieldDescs, FldDescCount);
          { Create an array of field descriptors }
          for I := 0 to FldDescCount - 1 do
            Check(DbiGetNextRecord(FCursor, dbiNoLock, FieldDescs[I], nil));
          { Initialize list of required fields }
          RequiredFields := TBits.Create;
          try
            if FieldDescs[FldDescCount-1].iFldNum > FldDescCount then
              RequiredFields.Size := FieldDescs[FldDescCount-1].iFldNum + 1 else
              RequiredFields.Size := FldDescCount + 1;
            if DbiOpenVChkList(DBHandle, NativeTableName, GetTableTypeName,
              VCursor) = 0 then
            try
              while DbiGetNextRecord(VCursor, dbiNoLock, ValCheckDesc, nil) = 0 do
                if ValCheckDesc.bRequired and not ValCheckDesc.bHasDefVal then
                begin
                  { Grow the RequiredFields bits if needed for array fields }
                  if ValCheckDesc.iFldNum > (RequiredFields.Size - 1) then
                    RequiredFields.Size := RequiredFields.Size + 100;
                  RequiredFields[ValCheckDesc.iFldNum] := True;
                end;
            finally
              DbiCloseCursor(VCursor);
            end;
            { Initialize the FieldDefs }
            FieldDefs.BeginUpdate;
            try
              FieldDefs.Clear;
              I := 0;
              FieldID := 1;
              while I < FldDescCount do
                AddFieldDesc(FieldDescs, I, FieldID, RequiredFields, FieldDefs);
            finally
              FieldDefs.EndUpdate;
            end;
          finally
            RequiredFields.Free;
          end;
        finally
          DbiCloseCursor(FCursor);
        end;
      finally
        RestoreLocale(LocaleSave);
      end;
    finally
      SetDBFlag(dbfFieldList, False);
    end;
  end;
end;

procedure TTable.DestroyHandle;
begin
  DestroyLookupCursor;
  inherited DestroyHandle;
end;

{ Index / Ranges / Keys }

procedure TTable.DecodeIndexDesc(const IndexDesc: IDXDesc;
  var Source, Name, FieldExpression, DescFields: string;
  var Options: TIndexOptions);

  procedure ConcatField(var FieldList: string; const FieldName: string);
  begin
    if FieldList = '' then
      FieldList := FieldName else
      FieldList := Format('%s;%s', [FieldList, FieldName]);
  end;

var
  IndexOptions: TIndexOptions;
  I: Integer;
  SSource, SName: string;
  FieldName: string;
begin
  with IndexDesc do
  begin
    if Length(szTagName) = 0 then
    begin
      SName := szName;
      Source := '';
    end
    else begin
      SSource := szName;
      SName := szTagName;
      NativeToAnsi(nil, SSource, Source);
    end;
    NativeToAnsi(Locale, SName, Name);
    Name := ExtractFileName(Name);
    Source := ExtractFileName(Source);
    IndexOptions := [];
    if bPrimary then Include(IndexOptions, ixPrimary);
    if bUnique then Include(IndexOptions, ixUnique);
    if bDescending then Include(IndexOptions, ixDescending);
    if bCaseInsensitive then Include(IndexOptions, ixCaseInsensitive);
    if not bMaintained then Include(IndexOptions, ixNonMaintained);
    if bExpIdx then
    begin
      NativeToAnsi(Locale, szKeyExp, FieldExpression);
      Include(IndexOptions, ixExpression);
    end else
    begin
      FieldExpression := '';
      DescFields := '';
      for I := 0 to iFldsInKey - 1 do
      begin
        FieldName := FieldDefList[aiKeyFld[I] - 1].Name;
        ConcatField(FieldExpression, FieldName);
        if WordBool(abDescending[I]) then
          ConcatField(DescFields, FieldName);
      end;
      if bDescending and (DescFields = FieldExpression) then
        DescFields := '';
    end;
    Options := IndexOptions;
  end;
end;

procedure TTable.EncodeIndexDesc(var IndexDesc: IDXDesc;
  const Name, FieldExpression: string; Options: TIndexOptions;
  const DescFields: string);

  function IndexFieldOfs(const FieldName: string): Integer;
  var
    FieldNo: Integer;
  begin
    FieldNo := FieldDefs.Find(FieldName).FieldNo;
    for Result := 0 to IndexDesc.iFldsInKey - 1 do
      if IndexDesc.aiKeyFld[Result] = FieldNo then Exit;
    DatabaseErrorFmt(SIndexFieldMissing, [FieldName], Self);
    Result := -1;
  end;

var
  Pos: Integer;
begin
  with IndexDesc do
  begin
    bPrimary := ixPrimary in Options;
    bUnique := ixUnique in Options;
    bDescending := (ixDescending in Options) and (DescFields = '');
    bMaintained := not (ixNonMaintained in Options);
    { -1 for True is ignored in the Paradox driver }
    bCaseInsensitive := WordBool(ixCaseInsensitive in Options);
    if IsXBaseTable then
    begin
      if bMaintained then
        szTagName := AnsiToNative(Locale, Name, DBIMAXNAMELEN) else
        szName := AnsiToNative(Locale, Name, DBIMAXTBLNAMELEN);
    end else
      szName := AnsiToNative(Locale, Name, DBIMAXTBLNAMELEN);
    if ixExpression in Options then
    begin
      bExpIdx := True;
      szKeyExp := AnsiToNative(Locale, FieldExpression, DBIMAXKEYEXPLEN);
    end else
    begin
      Pos := 1;
      while (Pos <= Length(FieldExpression)) and (iFldsInKey < DBIMAXFLDSINKEY) do
      begin
        aiKeyFld[iFldsInKey] :=
          FieldDefs.Find(ExtractFieldName(FieldExpression, Pos)).FieldNo;
        abDescending[iFldsInKey] := Word(bDescending);
        Inc(iFldsInKey);
      end;
      if (DescFields <> '') then
      begin
        bDescending := True;
        Pos := 1;
        while Pos <= Length(DescFields) do
          abDescending[IndexFieldOfs(ExtractFieldName(DescFields, Pos))] := Word(True);
      end;
    end;
  end;
end;

procedure TTable.AddIndex(const Name, Fields: string; Options: TIndexOptions;
  const DescFields: string);
var
  IndexDesc: IDXDesc;
  LocaleSave: TLocale;
begin
  FieldDefs.Update;
  if Active then
  begin
    EncodeIndexDesc(IndexDesc, Name, Fields, Options, DescFields);
    CheckBrowseMode;
    CursorPosChanged;
    Check(DbiAddIndex(DBHandle, Handle, nil, nil, IndexDesc, nil));
  end else
  begin
    LocaleSave := SetTempLocale(False);
    try
      EncodeIndexDesc(IndexDesc, Name, Fields, Options, DescFields);
    finally
      RestoreLocale(LocaleSave);
    end;
    SetDBFlag(dbfTable, True);
    try
      Check(DbiAddIndex(DBHandle, nil, NativeTableName, GetTableTypeName,
        IndexDesc, nil));
    finally
      SetDBFlag(dbfTable, False);
    end;
  end;
  IndexDefs.Updated := False;
end;

procedure TTable.DeleteIndex(const Name: string);
var
  IndexName, IndexTag: string;
begin
  if Active then
  begin
    GetIndexParams(Name, False, IndexName, IndexTag);
    CheckBrowseMode;
    Check(DbiDeleteIndex(DBHandle, Handle, nil, nil, IndexName, IndexTag, 0));
  end else
  begin
    GetIndexParams(Name, False, IndexName, IndexTag);
    SetDBFlag(dbfTable, True);
    try
      Check(DbiDeleteIndex(DBHandle, nil, NativeTableName, GetTableTypeName,
        IndexName, IndexTag, 0));
    finally
      SetDBFlag(dbfTable, False);
    end;
  end;
  IndexDefs.Updated := False;
end;

function TTable.GetIndexFieldNames: string;
begin
  if FFieldsIndex then Result := FIndexName else Result := '';
end;

function TTable.GetIndexName: string;
begin
  if FFieldsIndex then Result := '' else Result := FIndexName;
end;

procedure TTable.GetIndexNames(List: TStrings);
begin
  IndexDefs.Update;
  IndexDefs.GetItemNames(List);
end;

procedure TTable.GetIndexParams(const IndexName: string;
  FieldsIndex: Boolean; var IndexedName, IndexTag: string);
var
  I: Integer;
  IndexStr: TIndexName;
  SIndexName: DBIMSG;
  SIndexTag: DBINAME;
  LocaleSave: TLocale;
begin
  SIndexName := '';
  SIndexTag := '';
  if IndexName <> '' then
  begin
    IndexDefs.Update;
    IndexStr := IndexName;
    LocaleSave := SetTempLocale(True);
    try
      if FieldsIndex then
        if Database.FPseudoIndexes then
        begin
          for I := 1 to Length(IndexStr) do
            if IndexStr[I] = ';' then IndexStr[I] := '@';
          IndexStr := '@' + IndexStr;
        end else
          IndexStr := IndexDefs.FindIndexForFields(IndexName).Name;
      if IsXBaseTable and (UpperCase(ExtractFileExt(IndexStr)) <> '.NDX') then
      begin
        SIndexTag := AnsiToNative(Locale, IndexStr, DBIMAXNAMELEN);
        with IndexDefs do
        begin
          I := IndexOf(IndexStr);
          if I <> -1 then
            IndexStr := Items[I].Source else
            DatabaseErrorFmt(SIndexDoesNotExist, [IndexName], Self);
          SIndexName := AnsiToNative(nil, IndexStr, DBIMAXMSGLEN);
        end;
      end else
        SIndexName := AnsiToNative(Locale, IndexStr, DBIMAXMSGLEN);
    finally
      RestoreLocale(LocaleSave);
    end;
  end;
  IndexedName := SIndexName;
  IndexTag := SIndexTag;
end;

procedure TTable.SetIndexDefs(Value: TIndexDefs);
begin
  IndexDefs.Assign(Value);
end;

procedure TTable.SetIndex(const Value: string; FieldsIndex: Boolean);
var
  IndexName, IndexTag: string;
begin
  if Active then CheckBrowseMode;
  if (FIndexName <> Value) or (FFieldsIndex <> FieldsIndex) then
  begin
    if Active then
    begin
      GetIndexParams(Value, FieldsIndex, IndexName, IndexTag);
      SwitchToIndex(IndexName, IndexTag);
      CheckMasterRange;
    end;
    FIndexName := Value;
    FFieldsIndex := FieldsIndex;
    if Active then Resync([]);
  end;
end;

procedure TTable.SetIndexFieldNames(const Value: string);
begin
  SetIndex(Value, Value <> '');
end;

procedure TTable.SetIndexName(const Value: string);
begin
  SetIndex(Value, False);
end;

procedure TTable.SetIndexFiles(Value: TStrings);
begin
  FIndexFiles.Assign(Value);
end;

procedure TTable.OpenIndexFile(const IndexName: string);
begin
  CheckIndexOpen(DbiOpenIndex(Handle,
    AnsiToNative(Locale, IndexName, DBIMAXNAMELEN), 0));
end;

procedure TTable.CloseIndexFile(const IndexFileName: string);
var
  IndexName, IndexTag: string;
begin
  GetIndexParams(FIndexName, FFieldsIndex, IndexName, IndexTag);
  if AnsiUpperCaseFileName(IndexName) = AnsiUpperCaseFileName(IndexFileName) then
    Self.IndexName := '';
  Check(DbiCloseIndex(Handle,
    AnsiToNative(Locale, IndexFileName, DBIMAXNAMELEN), 0));
end;

procedure TTable.UpdateIndexDefs;
var
  Opts: TIndexOptions;
  IdxName, Src, Flds, DescFlds: string;

  procedure UpdateFromCursor;
  var
    I: Integer;
    Size: Cardinal;
    Cursor: HDBICur;
    CursorProps: CurProps;
    IndexDescs: TIndexDescList;
    IndexDescsBuf: IntPtr;
    OldLocale, CursorLocale: TLocale;
  begin
    OldLocale := Locale;
    if Handle = nil then
    begin
      Cursor := GetHandle('', '');
      { For Local tables (i.e. Paradox & dBase) we need to get the locale
        from the actual Table }
      if DbiGetLdObj(Cursor, CursorLocale) = 0 then SetLocale(CursorLocale);
    end else
      Cursor := Handle;
    try
      DbiGetCursorProps(Cursor, CursorProps);
      if CursorProps.iIndexes > 0 then
      begin
        SetLength(IndexDescs, CursorProps.iIndexes);
        with Marshal do
        begin
          Size := Sizeof(TypeOf(IDXDesc));
          IndexDescsBuf := AllocHGlobal(CursorProps.iIndexes * Size);
          try
            DbiGetIndexDescs(Cursor, IndexDescsBuf);
            IndexDescs := TIndexDescList(NativeBufToArray(IndexDescsBuf, IndexDescs));
          finally
            FreeHGlobal(IndexDescsBuf);
          end;
        end;

        for I := 0 to CursorProps.iIndexes - 1 do
        begin
          DecodeIndexDesc(IndexDescs[I], Src, IdxName, Flds, DescFlds, Opts);
          with IndexDefs.AddIndexDef do
          begin
            Name := IdxName;
            Fields := Flds;
            DescFields := DescFlds;
            Options := Opts;
            if Src <> '' then
              Source := Src;
          end;
        end;
      end;
    finally
      if (Cursor <> nil) and (Cursor <> Handle) then DbiCloseCursor(Cursor);
      if Locale <> OldLocale then SetLocale(OldLocale);
    end;
  end;

  procedure UpdateFromIndexList;
  var
    FCursor: HDBICur;
    IndexDesc: IDXDesc;
  begin
    while not CheckOpen(DbiOpenIndexList(DBHandle, NativeTableName,
      GetTableTypeName, FCursor)) do {Retry};
    try
      while DbiGetNextRecord(FCursor, dbiNoLock, IndexDesc, nil) = 0 do
        if IndexDesc.bMaintained then
        begin
          DecodeIndexDesc(IndexDesc, Src, IdxName, Flds, DescFlds, Opts);
          with IndexDefs.AddIndexDef do
          begin
            Name := IdxName;
            Fields := Flds;
            DescFields := DescFlds;
            Options := Opts;
          end;
        end;
    finally
      DbiCloseCursor(FCursor);
    end;
  end;

begin
  SetDBFlag(dbfIndexList, True);
  try
    FieldDefs.Update;
    IndexDefs.Clear;
    if IsCursorOpen or not Database.IsSQLBased then
      UpdateFromCursor else
      UpdateFromIndexList;
  finally
    SetDBFlag(dbfIndexList, False);
  end;
end;

function TTable.IsProductionIndex(const IndexName: string): Boolean;
begin
  Result := True;
  if IsXBaseTable and (IndexName <> '') then
    if AnsiUpperCase(ExtractFileExt(IndexName)) = '.NDX' then
      Result := False
    else Result := AnsiUpperCaseFileName(ChangeFileExt(NativeTableName, '')) =
      AnsiUpperCaseFileName(ChangeFileExt(IndexName, ''));
end;

function TTable.GetExists: Boolean;
var
  H: HDBICur;
  E: DBIResult;
begin
  Result := Active;
  if Result or (TableName = '') then Exit;
  SetDBFlag(dbfTable, True);
  try
    if Database.IsSQLBased then
    begin
      { Assume (get fields) faster than (get tables & find this table) }
      E := DbiOpenFieldList(DBHandle, NativeTableName, nil, False, H);
      Result := E = DBIERR_NONE;
      if Result then DbiCloseCursor(H)
      else if (E <> DBIERR_NOSUCHTABLE) and (E <> DBIERR_OBJNOTFOUND) then DbiError(E);
    end else Result := FileExists(GetFileName);
  finally
    SetDBFlag(dbfTable, False);
  end;
end;

function TTable.FindKey(const KeyValues: array of const): Boolean;
begin
  CheckBrowseMode;
  SetKeyFields(kiLookup, KeyValues);
  Result := GotoKey;
end;

procedure TTable.FindNearest(const KeyValues: array of const);
begin
  CheckBrowseMode;
  SetKeyFields(kiLookup, KeyValues);
  GotoNearest;
end;

function TTable.GotoKey: Boolean;
var
  KeyBuffer: PKeyBuffer;
  IndexBuffer, RecBuffer: TRecordBuffer;
  UseKey: Boolean;
begin
  CheckBrowseMode;
  DoBeforeScroll;
  CursorPosChanged;
  KeyBuffer := GetKeyBuffer(kiLookup);
  IndexBuffer := Marshal.AllocHGlobal(KeySize);
  try
    RecBuffer := TRecordBuffer(Longint(KeyBuffer) + Marshal.SizeOf(TypeOf(TBDEKeyBuffer)));
    UseKey := DbiExtractKey(Handle, RecBuffer, IndexBuffer) = 0;
    if UseKey then RecBuffer := IndexBuffer;
    Result := DbiGetRecordForKey(Handle, UseKey,
      Marshal.ReadInt32(KeyBuffer, 2), 0, RecBuffer, nil) = 0;
    if Result then Resync([rmExact, rmCenter]);
    if Result then DoAfterScroll;
  finally
    Marshal.FreeHGlobal(IndexBuffer);
  end;
end;

procedure TTable.GotoNearest;
var
  SearchCond: DBISearchCond;
  KeyBuffer: PKeyBuffer;
  IndexBuffer, RecBuffer: TRecordBuffer;
  UseKey: Boolean;
begin
  CheckBrowseMode;
  CursorPosChanged;
  KeyBuffer := GetKeyBuffer(kiLookup);
  if Boolean(Marshal.ReadByte(KeyBuffer, 1)) then
    SearchCond := keySEARCHGT else
    SearchCond := keySEARCHGEQ;
  IndexBuffer := Marshal.AllocHGlobal(KeySize);
  try
    RecBuffer := TRecordBuffer(Longint(KeyBuffer) + Marshal.SizeOf(TypeOf(TBDEKeyBuffer)));
    UseKey := DbiExtractKey(Handle, RecBuffer, IndexBuffer) = 0;
    if UseKey then RecBuffer := IndexBuffer;
    Check(DbiSetToKey(Handle, SearchCond, UseKey,
      Marshal.ReadInt32(KeyBuffer, 2), 0, RecBuffer));
    Resync([rmCenter]);
  finally
    Marshal.FreeHGlobal(IndexBuffer);
  end;
end;

procedure TTable.SetKey;
begin
  SetKeyBuffer(kiLookup, True);
end;

procedure TTable.EditKey;
begin
  SetKeyBuffer(kiLookup, False);
end;

procedure TTable.ApplyRange;
begin
  CheckBrowseMode;
  if SetCursorRange then First;
  FRanged := True;
end;

procedure TTable.CancelRange;
begin
  CheckBrowseMode;
  UpdateCursorPos;
  if ResetCursorRange then Resync([]);
  FRanged := False;
end;

procedure TTable.SetRange(const StartValues, EndValues: array of const);
begin
  CheckBrowseMode;
  SetKeyFields(kiRangeStart, StartValues);
  SetKeyFields(kiRangeEnd, EndValues);
  ApplyRange;
end;

procedure TTable.SetRangeEnd;
begin
  SetKeyBuffer(kiRangeEnd, True);
end;

procedure TTable.SetRangeStart;
begin
  SetKeyBuffer(kiRangeStart, True);
end;

procedure TTable.EditRangeEnd;
begin
  SetKeyBuffer(kiRangeEnd, False);
end;

procedure TTable.EditRangeStart;
begin
  SetKeyBuffer(kiRangeStart, False);
end;

procedure TTable.UpdateRange;
begin
  SetLinkRanges(FMasterLink.Fields);
end;

function TTable.GetLookupCursor(const KeyFields: string;
  CaseInsensitive: Boolean): HDBICur;
var
  IndexFound, FieldsIndex: Boolean;
  KeyIndexName, IndexName, IndexTag: string;
  KeyIndex: TIndexDef;
begin
  if (KeyFields <> FLookupKeyFields) or
     (CaseInsensitive <> FLookupCaseIns) then
  begin
    DestroyLookupCursor;
    IndexFound := False;
    FieldsIndex := False;
    { If a range is active, don't use a lookup cursor }
    with Marshal do
      if not Boolean(ReadByte(FKeyBuffers[kiCurRangeStart])) and
         not Boolean(ReadByte(FKeyBuffers[kiCurRangeEnd])) then
      begin
        if Database.FPseudoIndexes then
        begin
          if not CaseInsensitive then
          begin
            KeyIndexName := KeyFields;
            FieldsIndex := True;
            IndexFound := True;
          end;
        end else
        begin
          KeyIndex := IndexDefs.GetIndexForFields(KeyFields, CaseInsensitive);
          if (KeyIndex <> nil) and
             (CaseInsensitive = (ixCaseInsensitive in KeyIndex.Options)) then
          begin
            KeyIndexName := KeyIndex.Name;
            FieldsIndex := False;
            IndexFound := True;
          end;
        end;
      if IndexFound and (Length(KeyFields) < DBIMAXMSGLEN) then
      begin
        Check(DbiCloneCursor(Handle, True, False, FLookupHandle));
        GetIndexParams(KeyIndexName, FieldsIndex, IndexName, IndexTag);
        Check(DbiSwitchToIndex(FLookupHandle, IndexName, IndexTag, 0, False));
      end;
      FLookupKeyFields := KeyFields;
      FLookupCaseIns := CaseInsensitive;
    end;
  end;
  Result := FLookupHandle;
end;

procedure TTable.DestroyLookupCursor;
begin
  if FLookupHandle <> nil then
  begin
    DbiCloseCursor(FLookupHandle);
    FLookupHandle := nil;
    FLookupKeyFields := '';
  end;
end;

procedure TTable.GotoCurrent(Table: TTable);
begin
  CheckBrowseMode;
  Table.CheckBrowseMode;
  if (WideCompareText(DatabaseName, Table.DatabaseName) <> 0) or
    (WideCompareText(TableName, Table.TableName) <> 0) then
    DatabaseError(STableMismatch, Self);
  Table.UpdateCursorPos;
  Check(DbiSetToCursor(Handle, Table.Handle));
  DoBeforeScroll;
  Resync([rmExact, rmCenter]);
  DoAfterScroll;
end;

procedure TTable.GetDetailLinkFields(MasterFields, DetailFields: TObjectList);
var
  i: Integer;
  Idx: TIndexDef;
begin
  MasterFields.Clear;
  DetailFields.Clear;
  if (MasterSource <> nil) and (MasterSource.DataSet <> nil) and
     (Self.MasterFields <> '') then
  begin
    Idx := nil;
    MasterSource.DataSet.GetFieldList(MasterFields, Self.MasterFields);
    UpdateIndexDefs;
    if IndexName <> '' then
      Idx := IndexDefs.Find(IndexName)
    else if IndexFieldNames <> '' then
      Idx := IndexDefs.GetIndexForFields(IndexFieldNames, False)
    else
      for i := 0 to IndexDefs.Count - 1 do
        if ixPrimary in IndexDefs[i].Options then
        begin
          Idx := IndexDefs[i];
          break;
        end;
    if Idx <> nil then
      GetFieldList(DetailFields, Idx.Fields);
  end;
end;

{ Master / Detail }

procedure TTable.CheckMasterRange;
begin
  if FMasterLink.Active and (FMasterLink.Fields.Count > 0) then
  begin
    SetLinkRanges(FMasterLink.Fields);
    SetCursorRange;
  end;
end;

procedure TTable.MasterChanged(Sender: TObject);
begin
  CheckBrowseMode;
  UpdateRange;
  ApplyRange;
end;

procedure TTable.MasterDisabled(Sender: TObject);
begin
  CancelRange;
end;

function TTable.GetDataSource: TDataSource;
begin
  Result := FMasterLink.DataSource;
end;

procedure TTable.SetDataSource(Value: TDataSource);
begin
  if IsLinkedTo(Value) then DatabaseError(SCircularDataLink, Self);
  FMasterLink.DataSource := Value;
end;

function TTable.GetMasterFields: string;
begin
  Result := FMasterLink.FieldNames;
end;

procedure TTable.SetMasterFields(const Value: string);
begin
  FMasterLink.FieldNames := Value;
end;

procedure TTable.DoOnNewRecord;
var
  I: Integer;
begin
  if FMasterLink.Active and (FMasterLink.Fields.Count > 0) then
    for I := 0 to FMasterLink.Fields.Count - 1 do
      IndexFields[I] := TField(FMasterLink.Fields[I]);
  inherited DoOnNewRecord;
end;

{ Table Manipulation }

function TTable.BatchMove(ASource: TBDEDataSet; AMode: TBatchMode): Longint;
begin
  with TBatchMove.Create(nil) do
  try
    Destination := Self;
    Source := ASource;
    Mode := AMode;
    Execute;
    Result := MovedCount;
  finally
    Free;
  end;
end;

procedure TTable.CreateTable;
var
  LocaleSave: TLocale;
  IndexDescs: TIndexDescList;
  TableDesc: CRTblDesc;
  ValChecks: TValCheckList;
  SQLLName: StringBuilder;
  LvlFldDesc: BDEFLDDesc;
  Level: DBINAME;

  procedure InitTableSettings;
  begin
    with TableDesc do
    begin
      szTblName := AnsiToNative(Locale, TableName, DBIMAXTBLNAMELEN);
      szTblType := GetTableTypeName;
      if FTableLevel > 0 then
      begin
        iOptParams := 1;
        Level := IntToStr(FTableLevel);
        pOptData := Marshal.StringToHGlobalAnsi(Level);
        LvlFldDesc.szName := szCFGDRVLEVEL;
        LvlFldDesc.iLen := Length(Level) + 1;
        LvlFldDesc.iOffset := 0;
        with Marshal do
        begin
          pfldOptParams := AllocHGlobal(SizeOf(TypeOf(BDEFLDDesc)));
          StructureToPtr(TObject(LvlFldDesc), pfldOptParams, False);
        end;
      end;
    end;
  end;

  procedure InitFieldDescriptors;
  var
    I: Integer;
    TempFieldDescs: TFieldDescList;
  begin
    with TableDesc do
    begin
      InitFieldDefsFromFields;
      iFldCount := FieldDefs.Count;
      SetLength(TempFieldDescs, iFldCount);
      for I := 0 to FieldDefs.Count - 1 do
      with FieldDefs[I] do
      begin
        EncodeFieldDesc(TempFieldDescs[I], Name, DataType, Size, Precision);
        if Required then Inc(iValChkCount);
      end;
      with Marshal do
        pFldDesc := AllocHGlobal(SizeOf(TypeOf(BDEFLDDesc)) * iFldCount);
      if Database.IsSQLBased then
      begin
        SQLLName := StringBuilder.Create(DBIMAXNAMELEN + 1);
        if DbiGetLdNameFromDB(DBHandle, nil, SQLLName) <> 0 then
        begin
          SQLLName.Free;
          SQLLName := nil;
        end;
      end;
      Check(DbiTranslateRecordStructure(nil, iFldCount, TempFieldDescs,
        GetDriverTypeName, SQLLName, pFLDDesc, False));
    end;
  end;

  procedure InitIndexDescriptors;
  var
    I: Integer;
  begin
    TableDesc.iIdxCount := IndexDefs.Count;
    SetLength(IndexDescs, TableDesc.iIdxCount);
    for I := 0 to IndexDefs.Count - 1 do
    with IndexDefs[I] do
      EncodeIndexDesc(IndexDescs[I], Name, FieldExpression, Options, DescFields);
    TableDesc.pIdxDesc := ArrayToNativeBuf(IndexDescs);
  end;

  procedure InitValChecks;
  var
    I, ValCheckNo: Integer;
  begin
    with TableDesc do
    if iValChkCount > 0 then
    begin
      SetLength(ValChecks, iValChkCount);
      ValCheckNo := 0;
      for I := 0 to FieldDefs.Count - 1 do
        if FieldDefs[I].Required then
        begin
          ValChecks[ValCheckNo].iFldNum := I + 1;
          ValChecks[ValCheckNo].bRequired := True;
          Inc(ValCheckNo);
        end;
      pvchkDesc := ArrayToNativeBuf(ValChecks);
    end;
  end;

begin
  CheckInactive;
  SetDBFlag(dbfTable, True);
  try
    InitTableSettings;
    try
      LocaleSave := SetTempLocale(False);
      try
        InitFieldDescriptors;
        InitIndexDescriptors;
        InitValChecks;
        try
          Check(DbiCreateTable(DBHandle, True, TableDesc));
        finally
          with TableDesc, Marshal do
          begin
            FreeHGlobal(pIdxDesc);
            FreeHGlobal(pvchkDesc);
          end;
        end;
      finally
        RestoreLocale(LocaleSave);
      end;
    finally
      with TableDesc, Marshal do
      begin
        FreeHGlobal(pOptData);
        FreeHGlobal(pfldOptParams);
      end;
    end;
  finally
    SetDBFlag(dbfTable, False);
  end;
end;

procedure TTable.DeleteTable;
begin
  CheckInactive;
  SetDBFlag(dbfTable, True);
  try
    Check(DbiDeleteTable(DBHandle, NativeTableName, GetTableTypeName));
  finally
    SetDBFlag(dbfTable, False);
  end;
end;

procedure TTable.EmptyTable;
begin
  if Active then
  begin
    CheckBrowseMode;
    Check(DbiEmptyTable(DBHandle, Handle, nil, nil));
    ClearBuffers;
    DataEvent(deDataSetChange, TObject(Integer(0)));
  end else
  begin
    SetDBFlag(dbfTable, True);
    try
      Check(DbiEmptyTable(DBHandle, nil, NativeTableName, GetTableTypeName));
    finally
      SetDBFlag(dbfTable, False);
    end;
  end;
end;

procedure TTable.LockTable(LockType: TLockType);
begin
  SetTableLock(LockType, True);
end;

procedure TTable.SetTableLock(LockType: TLockType; Lock: Boolean);
var
  L: DBILockType;
begin
  CheckActive;
  if LockType = ltReadLock then L := dbiREADLOCK else L := dbiWRITELOCK;
  if Lock then
    Check(DbiAcqTableLock(Handle, L)) else
    Check(DbiRelTableLock(Handle, False, L));
end;

procedure TTable.UnlockTable(LockType: TLockType);
begin
  SetTableLock(LockType, False);
end;

procedure TTable.RenameTable(const NewTableName: string);
begin
  CheckInactive;
  SetDBFlag(dbfTable, True);
  try
    Check(DbiRenameTable(DBHandle, NativeTableName, GetTableTypeName,
      AnsiToNative(DBLocale, NewTableName, DBIMAXTBLNAMELEN)));
  finally
    SetDBFlag(dbfTable, False);
  end;
  TableName := NewTableName;
end;

procedure TTable.EncodeFieldDesc(var FieldDesc: BDEFLDDesc;
  const Name: string; DataType: TFieldType; Size, Precision: Integer);
begin
  with FieldDesc do
  begin
    szName := AnsiToNative(Locale, Name, DBIMAXNAMELEN);
    iFldType := FldTypeMap[DataType];
    iSubType := FldSubTypeMap[DataType];
    case DataType of
      ftString, ftFixedChar, ftBytes, ftVarBytes, ftBlob..ftTypedBinary:
        iUnits1 := Size;
      ftBCD:
        begin
          { Default precision is 32, Size = Scale }
          if (Precision > 0) and (Precision <= 32) then
            iUnits1 := Precision else
            iUnits1 := 32;
          iUnits2 := Size;  {Scale}
        end;
    end;
  end;
end;

procedure TTable.DataEvent(Event: TDataEvent; Info: TObject);
begin
  if (Event = dePropertyChange) and Assigned(IndexDefs) then IndexDefs.Updated := False;
  inherited DataEvent(Event, Info);
end;

{ Informational & Property }

function TTable.GetCanModify: Boolean;
begin
  Result := inherited GetCanModify and not ReadOnly;
end;

function TTable.GetDriverTypeName: string;
var
  Length: Word;
  Buffer: StringBuilder;
begin
  Buffer := StringBuilder.Create(DBIMAXNAMELEN + 1);
  Check(DbiGetProp(HDBIOBJ(DBHandle), dbDATABASETYPE, Buffer,
    Buffer.Capacity, Length));
  Result := Buffer.ToString;
  if CompareText(Result, szCFGDBSTANDARD) = 0 then
    Result := GetTableTypeName;
end;

function TTable.GetTableTypeName: string;
begin
  if Database.IsSQLBased then Result := ''
  else Result := TableTypeDriverNames[GetTableType];
end;

function TTable.GetTableLevel: Integer;
begin
  if Handle <> nil then
    Result := GetIntProp(Handle, curTABLELEVEL) else
    Result := FTableLevel;
end;

function TTable.FieldDefsStored: Boolean;
begin
  Result := StoreDefs and (FieldDefs.Count > 0);
end;

function TTable.IndexDefsStored: Boolean;
begin
  Result := StoreDefs and (IndexDefs.Count > 0);
end;

function TTable.IsXBaseTable: Boolean;
begin
  Result := (TableType in [ttDBase, ttFoxPro]) or
    (CompareText(ExtractFileExt(TableName), '.DBF') = 0);
end;

const
  Exts: array [TTableType] of string = ('.DB', '.DB', '.DBF', '.DBF', '.TXT');

function TTable.GetFileName: string;
var
  FDb: Boolean;
begin
  FDb := SetDBFlag(dbfDatabase, True);
  try
    Result := Database.Directory;
    if (Result <> '') and (not IsPathDelimiter(Result, Length(Result))) then
      Result := Result + '\';
    if ExtractFileExt(TableName) = '' then
      Result := Result + ChangeFileExt(TableName, Exts[TableType]) else
      Result := Result + TableName;
  finally
    SetDBFlag(dbfDatabase, FDb);
  end;
end;

function TTable.GetTableType: TTableType;
var
  Name, Extension: string;
  FDb: Boolean;
begin
  Result := ttDefault;
  FDb := SetDBFlag(dbfDatabase, True);
  try
    if not Database.IsSQLBased then
      if TableType = ttDefault then
      begin
        Extension := ExtractFileExt(TableName);
        if CompareText(Extension, '.DB') = 0 then Result := ttParadox
        else if CompareText(Extension, '.DBF') = 0 then
        begin
          Name := GetFileName;
          if FileExists(ChangeFileExt(Name, '.FPT')) or
             FileExists(ChangeFileExt(Name, '.CDX')) then
            Result := ttFoxPro else
            Result := ttDBase;
        end
        else if CompareText(Extension, '.TXT') = 0 then Result := ttASCII
      end else Result := TableType;
  finally
    if not FDb then SetDBFlag(dbfDatabase, False);
  end;
end;

function TTable.NativeTableName: string;
begin
  if Length(FNativeTableName) = 0 then
    FNativeTableName := AnsiToNative(DBLocale, FTableName, DBIMAXTBLNAMELEN);
  Result := FNativeTableName;
end;

procedure TTable.SetExclusive(Value: Boolean);
begin
  CheckInactive;
  FExclusive := Value;
end;

procedure TTable.SetReadOnly(Value: Boolean);
begin
  CheckInactive;
  FReadOnly := Value;
end;

procedure TTable.SetTableName(const Value: TFileName);
begin
  if csReading in ComponentState then
    FTableName := Value
  else if (FTableName <> Value) then
  begin
    CheckInactive;
    IndexFiles.Clear;
    FTableName := Value;
    SetLength(FNativeTableName, 0);
    DataEvent(dePropertyChange, nil);
  end;
end;

procedure TTable.SetTableType(Value: TTableType);
begin
  CheckInactive;
  FTableType := Value;
end;

{ TTable.IProviderSupport }

function TTable.PSGetCommandText: string;
begin
  Result := TableName;
end;

function TTable.PSGetCommandType: TPSCommandType;
begin
  Result := ctTable;
end;

function TTable.PSGetDefaultOrder: TIndexDef;

  function GetIdx(IdxType: TIndexOption): TIndexDef;
  var
    i: Integer;
  begin
    Result := nil;
    for i := 0 to IndexDefs.Count - 1 do
      if IdxType in IndexDefs[i].Options then
      try
        Result := IndexDefs[i];
        GetFieldList(nil, Result.Fields);
        break;
      except
        Result := nil;
      end;
  end;

var
  DefIdx: TIndexDef;
begin
  DefIdx := nil;
  IndexDefs.Update;
  try
    if IndexName <> '' then
      DefIdx := IndexDefs.Find(IndexName)
    else if IndexFieldNames <> '' then
      DefIdx := IndexDefs.FindIndexForFields(IndexFieldNames);
    if Assigned(DefIdx) then
      GetFieldList(nil, DefIdx.Fields);
  except
    DefIdx := nil;
  end;
  if not Assigned(DefIdx) then
    DefIdx := GetIdx(ixPrimary);
  if not Assigned(DefIdx) then
    DefIdx := GetIdx(ixUnique);
  if Assigned(DefIdx) then
  begin
    Result := TIndexDef.Create(nil);
    Result.Assign(DefIdx);
  end else
    Result := nil;
end;

function TTable.PSGetIndexDefs(IndexTypes: TIndexOptions): TIndexDefs;
begin
  Result := GetIndexDefs(IndexDefs, IndexTypes);
end;

function TTable.PSGetTableName: string;
begin
  Result := TableName;
end;

procedure TTable.PSSetParams(AParams: TParams);

  procedure AssignFields;
  var
    I: Integer;
  begin
    for I := 0 to AParams.Count - 1 do
      if AParams[I].Name <> '' then
        FieldByName(AParams[I].Name).Value := AParams[I].Value else
        IndexFields[I].Value := AParams[I].Value;
  end;

begin
  if AParams.Count > 0 then
  begin
    Open;
    SetRangeStart;
    AssignFields;
    SetRangeEnd;
    AssignFields;
    ApplyRange;
  end else
    if Active then CancelRange;
  PSReset;
end;

procedure TTable.PSSetCommandText(const CommandText: string);
begin
  if CommandText <> '' then
    TableName := CommandText;
end;

function TTable.PSGetKeyFields: string;
var
  i, Pos: Integer;
  IndexFound: Boolean;
begin
  Result := inherited PSGetKeyFields;
  if Result = '' then
  begin
    if not Exists then Exit;
    IndexFound := False;
    IndexDefs.Update;
    for i := 0 to IndexDefs.Count - 1 do
      if ixUnique in IndexDefs[I].Options then
      begin
        Result := IndexDefs[I].Fields;
        IndexFound := (FieldCount = 0);
        if not IndexFound then
        begin
          Pos := 1;
          while Pos <= Length(Result) do
          begin
            IndexFound := FindField(ExtractFieldName(Result, Pos)) <> nil;
            if not IndexFound then Break;
          end;
        end;
        if IndexFound then Break;
      end;
    if not IndexFound then
      Result := '';
  end;
end;

{ TQueryDataLink }

constructor TQueryDataLink.Create(AQuery: TQuery);
begin
  inherited Create;
  FQuery := AQuery;
end;

procedure TQueryDataLink.ActiveChanged;
begin
  if FQuery.Active then FQuery.RefreshParams;
end;

function TQueryDataLink.GetDetailDataSet: TDataSet;
begin
  Result := FQuery;
end;

procedure TQueryDataLink.RecordChanged(Field: TField);
begin
  if (Field = nil) and FQuery.Active then FQuery.RefreshParams;
end;

procedure TQueryDataLink.CheckBrowseMode;
begin
  if FQuery.Active then FQuery.CheckBrowseMode;
end;

{ TStoredProc }

constructor TStoredProc.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FParams := TParams.Create(Self);
end;

destructor TStoredProc.Destroy;
begin
  Destroying;
  Disconnect;
  FParams.Free;
  inherited Destroy;
end;

procedure TStoredProc.DefineProperties(Filer: TFiler);

  function WriteData: Boolean;
  begin
    if Filer.Ancestor <> nil then
      Result := not FParams.IsEqual(TStoredProc(Filer.Ancestor).FParams) else
      Result := FParams.Count > 0;
  end;

begin
  inherited DefineProperties(Filer);
  Filer.DefineProperty('ParamData', ReadParamData, WriteParamData, WriteData);
end;

procedure TStoredProc.WriteParamData(Writer: TWriter);
begin
  Writer.WriteCollection(Params);
end;

procedure TStoredProc.ReadParamData(Reader: TReader);
begin
  Reader.ReadValue;
  Reader.ReadCollection(Params);
end;

procedure TStoredProc.Disconnect;
begin
  Close;
  UnPrepare;
end;

function TStoredProc.CreateCursor(GenHandle: Boolean): HDBICur;
begin
  if StoredProcName <> '' then
  begin
    SetPrepared(True);
    Result := GetCursor(GenHandle);
  end else
    Result := nil;
end;

function TStoredProc.CreateHandle: HDBICur;
begin
  Result := CreateCursor(True);
end;

function TStoredProc.GetCursor(GenHandle: Boolean): HDBICur;
var
  PCursor: phDBICur;
begin
  Result := nil;
  if GenHandle then
    PCursor := Result
  else
    PCursor := nil;
  BindParams;
  Check(DbiQExec(StmtHandle, PCursor));
  GetResults;
end;

procedure TStoredProc.ExecProc;
begin
  CheckInActive;
  SetDBFlag(dbfExecProc, True);
  try
    CreateCursor(False);
  finally
    SetDBFlag(dbfExecProc, False);
  end;
end;

procedure TStoredProc.SetProcName(const Value: string);
begin
  if not (csReading in ComponentState) then
  begin
    CheckInactive;
    if Value <> FProcName then
    begin
      FProcName := Value;
      FreeStatement;
      FParams.Clear;
    end;
  end else
    FProcName := Value;
end;

procedure TStoredProc.SetOverLoad(Value: Word);
begin
  if not (csReading in ComponentState) then
  begin
    CheckInactive;
    if Value <> OverLoad then
    begin
      FOverLoad := Value;
      FreeStatement;
      FParams.Clear;
    end
  end else
    FOverLoad := Value;
end;

function TStoredProc.GetParamsCount: Word;
begin
  Result := FParams.Count;
end;

procedure TStoredProc.CreateParamDesc;
var
  Desc: BDESPParamDesc;
  Cursor: HDBICur;
  Buffer: DBISPNAME;
  ParamName: string;
  ParamDataType: TFieldType;
begin
  Buffer := AnsiToNative(DBLocale, StoredProcName, DBIMAXSPNAMELEN);
  if DbiOpenSPParamList(DBHandle, Buffer, False, OverLoad, Cursor) = 0 then
  try
    while DbiGetNextRecord(Cursor, dbiNOLOCK, Desc, nil) = 0 do
      with Desc do
      begin
        NativeToAnsi(DBLocale, szName, ParamName);
        if (TParamType(eParamType) = ptResult) and (ParamName = '') then
          ParamName := SResultName;
        if uFldType < MAXLOGFLDTYPES then ParamDataType := DataTypeMap[uFldType]
        else ParamDataType := ftUnknown;
        case uFldtype of
          fldFloat:
             if uSubType = fldstMONEY then ParamDataType := ftCurrency;
          fldBlob:
             if (uSubType >= fldstMEMO) and (uSubType <= fldstBFILE) then
               ParamDataType := BlobTypeMap[uSubType];
        end;
        with TParam(FParams.Add) do
        begin
          ParamType := TParamType(eParamType);
          DataType := ParamDataType;
          Name := ParamName;
        end;
      end;
    SetServerParams;
  finally
    DbiCloseCursor(Cursor);
  end;
end;

procedure TStoredProc.SetServerParams;
var
  I: Integer;
begin
  SetLength(FServerDescs, Params.Count);
  for I := 0 to Params.Count - 1 do
    with TParam(Params[I]), FServerDescs[I] do
    begin
      ParamName := Name;
      BindType := DataType;
    end;
end;

function TStoredProc.CheckServerParams: Boolean;
var
  Low, I, J: Integer;
begin
  if FServerDescs = nil then
  begin
    SetServerParams;
    Result := False;
  end else
  begin
    Low := 0;
    for I := 0 to High(FServerDescs) do
    begin
      for J := Low to Params.Count - 1 do
        with TParam(Params[J]), FServerDescs[I] do
          if Name = ParamName then
            if (DataType <> BindType) then
            begin
              Result := False;
              Exit;
            end else
            begin
              if J = Low then inc(Low);
              Break;
            end;
    end;
    Result := True;
  end;
end;

function TStoredProc.DescriptionsAvailable: Boolean;
var
  Cursor: HDBICur;
  Buffer: DBISPNAME;
begin
  SetDBFlag(dbfProcDesc, True);
  try
    Buffer := AnsiToNative(DBLocale, StoredProcName, DBIMAXSPNAMELEN);
    Result := DbiOpenSPParamList(DBHandle, Buffer, False, OverLoad, Cursor) = 0;
    if Result then
      DbiCloseCursor(Cursor);
  finally
    SetDBFlag(dbfProcDesc, False);
  end;
end;

procedure TStoredProc.PrepareProc;
var
  I: Integer;
  Offset: Word;
  Buffer: string;
begin
  SetLength(FParamDescs, FParams.Count);
  FRecBufSize := 0;
  for I := 0 to FParams.Count - 1 do
    with Params[I] do
      if DataType in [ftString, ftFixedChar] then
        Inc(FRecBufSize, 255 + 2)
      else
        Inc(FRecBufSize, GetParamDataSize(Params[I]) + 2);
  FRecordBuffer := BDEBuffers.AllocHGlobal(FRecBufSize);
  Offset := 0;
  for I := 0 to FParams.Count - 1 do
  begin
    with Params[I], FParamDescs[I] do
    begin
      if DataType = ftUnknown then
        DatabaseErrorFmt(SNoParameterValue, [Name], Self);
      if ParamType = ptUnknown then
        DatabaseErrorFmt(SNoParameterType, [Name], Self);
      if FBindMode = pbByName then
        szName := AnsiToNative(Locale, Name, DBIMAXNAMELEN)
      else
        uParamNum := I + 1;
      eParamType := STMTParamType(ParamType);
      uFldType := FldTypeMap[DataType];
      uSubType := FldSubTypeMap[DataType];
      if uFldType = fldZString then
      begin
        uLen := 255;
        iUnits1 := 255;
      end
      else
        if uFldType = fldADT then
        begin
          iUnits1 := Value;
          iUnits2 := Value;
          szName := AnsiToNative(Locale, Name, DBIMAXNAMELEN);
        end
        else
          uLen := GetParamDataSize(Params[I]);
      uOffset := Offset;
      Inc(Offset, uLen);
      uNullOffset := FRecBufSize - 2 * (I + 1);
      if ParamType in [ptInput, ptInputOutput] then
        Marshal.WriteInt16(FRecordBuffer, FRecBufSize - 2 * (I + 1), IndNull);
    end;
  end;
  Buffer := AnsiToNative(Locale, StoredProcName, DBIMAXSPNAMELEN);
  Check(DbiQPrepareProc(DBHandle, Buffer, High(FParamDescs) + 1,
    FParamDescs, nil, FStmtHandle));
end;

procedure TStoredProc.GetResults;
var
  I, Len: Integer;
  CurPtr: TRecordBuffer;
  Ptr: IntPtr;
  Int: SmallInt;
begin
  if FRecordBuffer <> nil then
  begin
    CurPtr := FRecordBuffer;
    for I := 0 to FParams.Count - 1 do
      with Params[I] do
      begin
        if ParamType in [ptOutput, ptInputOutput, ptResult] then
        begin
          if DataType in [ftString, ftFixedChar] then
          begin
            Len := 0;
            while Marshal.ReadByte(CurPtr, Len) <> 0 do
              Inc(Len);
            NativeToAnsiBuf(Locale, CurPtr, CurPtr, Len);
          end;
          Ptr := IntPtr(Longint(FRecordBuffer.ToInt32 + FRecBufSize - 2 * (I + 1)));
          Int := Marshal.ReadInt16(Ptr);
          if Int = IndNull then
            Value := NULL
          else
            if Int = IndTrunc then
              DatabaseErrorFmt(STruncationError, [Name])
            else
              SetData(CurPtr);
        end;
        if DataType in [ftString, ftFixedChar] then
          CurPtr := IntPtr(Longint(CurPtr.ToInt32 + 255))
        else
          CurPtr := IntPtr(Longint(CurPtr.ToInt32 + GetParamDataSize(Params[I])));
      end;
  end;
end;

procedure TStoredProc.BindParams;
var
  I: Integer;
  CurPtr: TRecordBuffer;
  DrvLocale: TLocale;
begin
  if FRecordBuffer = nil then Exit;
  if not CheckServerParams then
  begin
    SetPrepared(False);
    SetPrepared(True);
  end;
  CurPtr := FRecordBuffer;
  DrvLocale := GetStatementLocale(StmtHandle);
  try
    for I := 0 to FParams.Count - 1 do
    begin
      with Params[I] do
      begin
        if ParamType in [ptInput, ptInputOutput] then
        begin
          GetParamData(Params[i], CurPtr, DrvLocale);
          if IsNull then
            Marshal.WriteInt16(FRecordBuffer, FRecBufSize - 2 * (I + 1), IndNull)
          else
            Marshal.WriteInt16(FRecordBuffer, FRecBufSize - 2 * (I + 1), 0);
        end;
        if DataType in [ftString, ftFixedChar] then
        begin
          CurPtr := IntPtr(Longint(CurPtr.ToInt32 + 255));
          { Adjust param descriptor for string pseudo blobs }
          if ParamType = ptInput then
            with FParamDescs[I] do
            begin
              uLen := GetParamDataSize(Params[I]);
              if uFldType = fldZString then
                iUnits1 := GetDataSize - 1 {Do not include null terminator} else
                iUnits1 := GetDataSize;
            end
        end
        else
          CurPtr := IntPtr(Longint(CurPtr.ToInt32 + GetParamDataSize(Params[I])));
      end;
    end;
    Check(DbiQSetProcParams(StmtHandle, High(FParamDescs) + 1,
      FParamDescs, FRecordBuffer));
  finally
    FreeStatementLocale(DrvLocale);
  end;
end;

procedure TStoredProc.SetPrepared(Value: Boolean);
begin
  if Handle <> nil then DatabaseError(SDataSetOpen, Self);
  if Prepared <> Value then
  begin
    if Value then
      try
        if FParams.Count = 0 then CreateParamDesc
        else SetServerParams;
        if not FQueryMode then PrepareProc;
        FPrepared := True;
      except
        FreeStatement;
        raise;
      end
    else FreeStatement;
  end;
end;

procedure TStoredProc.Prepare;
begin
  SetDBFlag(dbfStoredProc, True);
  SetPrepared(True);
end;

procedure TStoredProc.UnPrepare;
begin
  SetPrepared(False);
  SetDBFlag(dbfStoredProc, False);
end;

procedure TStoredProc.FreeStatement;
begin
  if StmtHandle <> nil then DbiQFree(FStmtHandle);
  FParamDescs := nil;
  FServerDescs := nil;
  if FRecordBuffer <> nil then
    BDEBuffers.FreeHGlobal(FRecordBuffer);
  FRecordBuffer := nil;
  FPrepared := False;
end;

procedure TStoredProc.SetPrepare(Value: Boolean);
begin
  if Value then Prepare
  else UnPrepare;
end;

function TStoredProc.SetDBFlag(Flag: Integer; Value: Boolean): Boolean;
begin
  if not Value and (DBFlags - [Flag] = []) then SetPrepared(False);
  Result := inherited SetDBFlag(Flag, Value);
end;

procedure TStoredProc.CopyParams(Value: TParams);
begin
  if not Prepared and (FParams.Count = 0) then
  try
    FQueryMode := True;
    Prepare;
    Value.Assign(FParams);
  finally
    UnPrepare;
    FQueryMode := False;
  end else
    Value.Assign(FParams);
end;

procedure TStoredProc.SetParamsList(Value: TParams);
begin
  CheckInactive;
  if Prepared then
  begin
    SetPrepared(False);
    FParams.Assign(Value);
    SetPrepared(True);
  end else
    FParams.Assign(Value);
end;

function TStoredProc.ParamByName(const Value: string): TParam;
begin
  Result := FParams.ParamByName(Value);
end;

{ TStoredProc.IProviderSupport }

function TStoredProc.PSGetCommandText: string;
begin
  Result := FProcName;
end;

function TStoredProc.PSGetCommandType: TPSCommandType;
begin
  Result := ctStoredProc;
end;

function TStoredProc.PSGetParams: TParams;
begin
  Result := Params;
end;

procedure TStoredProc.PSSetParams(AParams: TParams);
begin
  if AParams.Count > 0 then
    Params.Assign(AParams);
  Close;
end;

function TStoredProc.PSGetTableName: string;
begin
  Result := inherited PSGetTableName;
end;

procedure TStoredProc.PSExecute;
begin
  ExecProc;
end;

procedure TStoredProc.PSSetCommandText(const CommandText: string);
begin
  if CommandText <> '' then
    StoredProcName := CommandText;
end;

{ TQuery }

constructor TQuery.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FSQL := TStringList.Create;
  TStringList(SQL).OnChange := QueryChanged;
  FParams := TParams.Create(Self);
  FDataLink := TQueryDataLink.Create(Self);
  RequestLive := False;
  ParamCheck := True;
  FRowsAffected := -1;
end;

destructor TQuery.Destroy;
begin
  Destroying;
  Disconnect;
  SQL.Free;
  FParams.Free;
  FDataLink.Free;
  inherited Destroy;
end;

procedure TQuery.Disconnect;
begin
  Close;
  UnPrepare;
end;

procedure TQuery.SetPrepare(Value: Boolean);
begin
  if Value then Prepare
  else UnPrepare;
end;

procedure TQuery.Prepare;
begin
  SetDBFlag(dbfPrepared, True);
  SetPrepared(True);
end;

procedure TQuery.UnPrepare;
begin
  SetPrepared(False);
  SetDBFlag(dbfPrepared, False);
end;

procedure TQuery.SetDataSource(Value: TDataSource);
begin
  if IsLinkedTo(Value) then DatabaseError(SCircularDataLink, Self);
  FDataLink.DataSource := Value;
end;

function TQuery.GetDataSource: TDataSource;
begin
  Result := FDataLink.DataSource;
end;

procedure TQuery.SetQuery(Value: TStrings);
begin
  if SQL.Text <> Value.Text then
  begin
    Disconnect;
    SQL.BeginUpdate;
    try
      SQL.Assign(Value);
    finally
      SQL.EndUpdate;
    end;
  end;
end;

procedure TQuery.QueryChanged(Sender: TObject);
var
  List: TParams;
begin
  if not (csReading in ComponentState) then
  begin
    Disconnect;
    SetLength(FSQLBinary, 0);
    if ParamCheck or (csDesigning in ComponentState) then
    begin
      List := TParams.Create(Self);
      try
        FText := List.ParseSQL(SQL.Text, True);
        List.AssignValues(FParams);
        FParams.Clear;
        FParams.Assign(List);
      finally
        List.Free;
      end;
    end else
      FText := SQL.Text;
    DataEvent(dePropertyChange, nil);
  end else
    FText := FParams.ParseSQL(SQL.Text, False);
end;

procedure TQuery.SetParamsList(Value: TParams);
begin
  FParams.AssignValues(Value);
end;

function TQuery.GetParamsCount: Word;
begin
  Result := FParams.Count;
end;

procedure TQuery.DefineProperties(Filer: TFiler);

  function WriteData: Boolean;
  begin
    if Filer.Ancestor <> nil then
      Result := not FParams.IsEqual(TQuery(Filer.Ancestor).FParams) else
      Result := FParams.Count > 0;
  end;

begin
  inherited DefineProperties(Filer);
  Filer.DefineBinaryProperty('Data', ReadBinaryData, WriteBinaryData,
    Length(SQLBinary) <> 0);
  Filer.DefineProperty('ParamData', ReadParamData, WriteParamData, WriteData);
end;

procedure TQuery.ReadParamData(Reader: TReader);
begin
  Reader.ReadValue;
  Reader.ReadCollection(FParams);
end;

procedure TQuery.WriteParamData(Writer: TWriter);
begin
  Writer.WriteCollection(Params);
end;

procedure TQuery.ReadBinaryData(Stream: TStream);
begin
  SetLength(FSQLBinary, Stream.Size);
  Stream.ReadBuffer(SQLBinary, Stream.Size);
end;

procedure TQuery.WriteBinaryData(Stream: TStream);
begin
  Stream.WriteBuffer(SQLBinary, Length(SQLBinary));
end;

procedure TQuery.SetPrepared(Value: Boolean);
begin
  if Handle <> nil then DatabaseError(SDataSetOpen, Self);
  if Value <> Prepared then
  begin
    if Value then
    begin
      FRowsAffected := -1;
      FCheckRowsAffected := True;
      if Length(Text) > 1 then PrepareSQL(Text)
      else DatabaseError(SEmptySQLStatement, Self);
    end
    else
    begin
      if FCheckRowsAffected then
        FRowsAffected := RowsAffected;
      FreeStatement;
    end;
    FPrepared := Value;
  end;
end;

procedure TQuery.FreeStatement;
var
  Result: DbiResult;
begin
  if StmtHandle <> nil then
  begin
    Result := DbiQFree(FStmtHandle);
    if not (csDestroying in ComponentState) then
      Check(Result);
  end;
end;

procedure TQuery.SetParamsFromCursor;
var
  I: Integer;
  DataSet: TDataSet;
begin
  if FDataLink.DataSource <> nil then
  begin
    DataSet := FDataLink.DataSource.DataSet;
    if DataSet <> nil then
    begin
      DataSet.FieldDefs.Update;
      for I := 0 to FParams.Count - 1 do
        with FParams[I] do
          if not Bound then
          begin
            AssignField(DataSet.FieldByName(Name));
            Bound := False;
          end;
    end;
  end;
end;

procedure TQuery.RefreshParams;
var
  DataSet: TDataSet;
begin
  DisableControls;
  try
    if FDataLink.DataSource <> nil then
    begin
      DataSet := FDataLink.DataSource.DataSet;
      if DataSet <> nil then
        if DataSet.Active and (DataSet.State <> dsSetKey) then
        begin
          Close;
          Open;
        end;
    end;
  finally
    EnableControls;
  end;
end;

function TQuery.ParamByName(const Value: string): TParam;
begin
  Result := FParams.ParamByName(Value);
end;

function TQuery.CreateCursor(GenHandle: Boolean): HDBICur;
begin
  if SQL.Count > 0 then
  begin
    FExecSQL := not GenHandle;
    try
      SetPrepared(True);
    finally
      FExecSQL := False;
    end;
    if FDataLink.DataSource <> nil then SetParamsFromCursor;
    Result := GetQueryCursor(GenHandle);
  end else
  begin
    DatabaseError(SEmptySQLStatement, Self);
    Result := nil;
  end;
  FCheckRowsAffected := (Result = nil);
end;

function TQuery.CreateHandle: HDBICur;
begin
  Result := CreateCursor(True)
end;

procedure TQuery.ExecSQL;
begin
  CheckInActive;
  SetDBFlag(dbfExecSQL, True);
  try
    CreateCursor(False);
  finally
    SetDBFlag(dbfExecSQL, False);
  end;
end;

function TQuery.GetQueryCursor(GenHandle: Boolean): HDBICur;
begin
  Result := nil;
  if FParams.Count > 0 then SetQueryParams(Self, StmtHandle, Params);
  if GenHandle then
    Check(DbiQExec(StmtHandle, Result))
  else
    Check(DbiQExec(StmtHandle));
end;

function TQuery.SetDBFlag(Flag: Integer; Value: Boolean): Boolean;
var
  NewConnection: Boolean;
begin
  if Value then
  begin
    NewConnection := DBFlags = [];
    Result := inherited SetDBFlag(Flag, Value);
    if not (csReading in ComponentState) and NewConnection then
      FLocal := not Database.IsSQLBased;
  end
  else begin
    if DBFlags - [Flag] = [] then SetPrepared(False);
    Result := inherited SetDBFlag(Flag, Value);
  end;
end;

procedure TQuery.PrepareSQL(Value: string);
begin
  GetStatementHandle(Value);
  if not Local then
    SetBoolProp(StmtHandle, stmtUNIDIRECTIONAL, FUniDirectional);
end;

const
  DataType: array[Boolean] of LongInt = (Ord(wantCanned), Ord(wantLive));

procedure TQuery.GetStatementHandle(SQLText: string);
begin
  Check(DbiQAlloc(DBHandle, qrylangSQL, FStmtHandle));
  try
    if not FExecSQL then
      Check(DBiSetProp(hDbiObj(StmtHandle), stmtLIVENESS,
        DataType[RequestLive and not ForceUpdateCallback]));
    if Local then
    begin
      SetBoolProp(StmtHandle, stmtAUXTBLS, False);
      if RequestLive and Constrained then
        SetBoolProp(StmtHandle, stmtCONSTRAINED, True);
      SetBoolProp(StmtHandle, stmtCANNEDREADONLY, True);
    end;
    while not CheckOpen(DbiQPrepare(FStmtHandle, SQLText)) do
      {Retry};
  except
    DbiQFree(FStmtHandle);
    FStmtHandle := nil;
    raise;
  end;
end;

function TQuery.GetRowsAffected: Integer;
var
  Length: Word;
begin
  if Prepared then
    if DbiGetProp(hDBIObj(StmtHandle), stmtROWCOUNT, Result, SizeOf(Result),
      Length) <> 0 then
      Result := -1
    else
  else Result := FRowsAffected;
end;

procedure TQuery.GetDetailLinkFields(MasterFields, DetailFields: TObjectList);

  function AddFieldToList(const FieldName: string; DataSet: TDataSet;
    List: TList): Boolean;
  var
    Field: TField;
  begin
    Field := DataSet.FindField(FieldName);
    if (Field <> nil) then
      List.Add(Field);
    Result := Field <> nil;
  end;

var
  i: Integer;
begin
  MasterFields.Clear;
  DetailFields.Clear;
  if (DataSource <> nil) and (DataSource.DataSet <> nil) then
    for i := 0 to Params.Count - 1 do
      if AddFieldToList(Params[i].Name, DataSource.DataSet, MasterFields) then
        AddFieldToList(Params[i].Name, Self, DetailFields);
end;

{ TQuery.IProviderSupport }

function TQuery.PSGetCommandText: string;
begin
  Result := SQL.Text;
end;

function TQuery.PSGetCommandType: TPSCommandType;
begin
  Result := ctQuery;
end;

function TQuery.PSGetDefaultOrder: TIndexDef;
begin
  Result := inherited PSGetDefaultOrder;
  if not Assigned(Result) then
    Result := GetIndexForOrderBy(SQL.Text, Self);
end;

function TQuery.PSGetParams: TParams;
begin
  Result := Params;
end;

procedure TQuery.PSSetParams(AParams: TParams);
begin
  if AParams.Count <> 0 then
    Params.Assign(AParams);
  Close;
end;

function TQuery.PSGetTableName: string;
begin
  Result := GetTableNameFromSQL(SQL.Text);
end;

procedure TQuery.PSExecute;
begin
  ExecSQL;
end;

procedure TQuery.PSSetCommandText(const CommandText: string);
begin
  if CommandText <> '' then
    SQL.Text := CommandText;
end;

{ TUpdateSQL }

constructor TUpdateSQL.Create(AOwner: TComponent);
var
  UpdateKind: TUpdateKind;
begin
  inherited Create(AOwner);
  for UpdateKind := Low(TUpdateKind) to High(TUpdateKind) do
  begin
    FSQLText[UpdateKind] := TStringList.Create;
    TStringList(FSQLText[UpdateKind]).OnChange := SQLChanged;
  end;
end;

destructor TUpdateSQL.Destroy;
var
  UpdateKind: TUpdateKind;
begin
  if Assigned(FDataSet) and (FDataset is TBDEDataset) and
    (TBDEDataset(FDataSet).UpdateObject = Self) then 
    TBDEDataset(FDataSet).UpdateObject := nil;
  for UpdateKind := Low(TUpdateKind) to High(TUpdateKind) do
    FSQLText[UpdateKind].Free;
  inherited Destroy;
end;

procedure TUpdateSQL.ExecSQL(UpdateKind: TUpdateKind);
begin
  with Query[UpdateKind] do
  begin
    Prepare;
    ExecSQL;
    if RowsAffected <> 1 then DatabaseError(SUpdateFailed);
  end;
end;

function TUpdateSQL.GetQuery(UpdateKind: TUpdateKind): TQuery;
begin
  if not Assigned(FQueries[UpdateKind]) then
  begin
    FQueries[UpdateKind] := TQuery.Create(Self);
    FQueries[UpdateKind].SQL.Assign(FSQLText[UpdateKind]);
    if (FDataSet is TDBDataSet) then
    begin
      FQueries[UpdateKind].SessionName := TDBDataSet(FDataSet).SessionName;
      FQueries[UpdateKind].DatabaseName := TDBDataSet(FDataSet).DataBaseName;
    end
    else 
    begin
      FQueries[UpdateKind].SessionName := Self.SessionName; 
      FQueries[UpdateKind].DatabaseName := Self.DataBaseName;
    end; 
  end;
  Result := FQueries[UpdateKind];
end;

function TUpdateSQL.GetSQL(UpdateKind: TUpdateKind): TStrings;
begin
  Result := FSQLText[UpdateKind];
end;

function TUpdateSQL.GetSQLIndex(Index: Integer): TStrings;
begin
  Result := FSQLText[TUpdateKind(Index)];
end;

function TUpdateSQL.GetDataSet: TDataSet;
begin
  Result := FDataSet;
end;

procedure TUpdateSQL.SetDataSet(ADataSet: TDataSet);
begin
  FDataSet := ADataSet;
end;

procedure TUpdateSQL.SetSQL(UpdateKind: TUpdateKind; Value: TStrings);
begin
  FSQLText[UpdateKind].Assign(Value);
end;

procedure TUpdateSQL.SetSQLIndex(Index: Integer; Value: TStrings);
begin
  SetSQL(TUpdateKind(Index), Value);
end;

procedure TUpdateSQL.SQLChanged(Sender: TObject);
var
  UpdateKind: TUpdateKind;
begin
  for UpdateKind := Low(TUpdateKind) to High(TUpdateKind) do
    if Sender = FSQLText[UpdateKind] then
    begin
      if Assigned(FQueries[UpdateKind]) then
      begin
        FQueries[UpdateKind].Params.Clear;
        FQueries[UpdateKind].SQL.Assign(FSQLText[UpdateKind]);
      end;
      Break;
    end;
end;

procedure TUpdateSQL.Apply(UpdateKind: TUpdateKind);
begin
  Apply(FDataset, UpdateKind);
end;

procedure TUpdateSQL.Apply(ADataset: TDataset; UpdateKind: TUpdateKind);
begin
  SetParams(ADataset, UpdateKind);
  ExecSQL(UpdateKind);
end;

procedure TUpdateSQL.SetParams(UpdateKind: TUpdateKind);
begin
  SetParams(FDataset, UpdateKind);
end;

procedure TUpdateSQL.SetParams(ADataset: TDataset; UpdateKind: TUpdateKind);
var
  I: Integer;
  Old: Boolean;
  Param: TParam;
  PName: string;
  Field: TField;
  Value: Variant;
begin
  if not Assigned(ADataSet) then Exit;
  with Query[UpdateKind] do
  begin
    for I := 0 to Params.Count - 1 do
    begin
      Param := Params[I];
      PName := Param.Name;
      Old := CompareText(Copy(PName, 1, 4), 'OLD_') = 0;
      if Old then Borland.Delphi.System.Delete(PName, 1, 4);
      Field := ADataSet.FindField(PName);
      if not Assigned(Field) then Continue;
      if Old then Param.AssignFieldValue(Field, Field.OldValue) else
      begin
        Value := Field.NewValue;
        if VarIsClear(Value) then Value := Field.OldValue;
        Param.AssignFieldValue(Field, Value);
      end;
    end;
  end;
end;

{ TBlobStream }

constructor TBlobStream.Create(Field: TBlobField; Mode: TBlobStreamMode);
var
  OpenMode: DbiOpenMode;
begin
  inherited Create;
  FMode := Mode;
  FField := Field;
  FDataSet := FField.DataSet as TBDEDataSet;
  FFieldNo := FField.FieldNo;
  if not FDataSet.GetActiveRecBuf(FBuffer) then Exit;
  if FDataSet.State = dsFilter then
    DatabaseErrorFmt(SNoFieldAccess, [FField.DisplayName], FDataSet);
  if not FField.Modified then
  begin
    if Mode = bmRead then
    begin
      FCached := FDataSet.FCacheBlobs and (FBuffer = FDataSet.ActiveBuffer) and
        (FField.IsNull or FDataSet.IsBlobDataCached(FField, FBuffer));
      OpenMode := dbiReadOnly;
    end else
    begin
      FDataSet.SetBlobData(FField, FBuffer, nil);
      if FField.ReadOnly then DatabaseErrorFmt(SFieldReadOnly,
        [FField.DisplayName], FDataSet);
      if not (FDataSet.State in [dsEdit, dsInsert]) then
        DatabaseError(SNotEditing, FDataSet);
      OpenMode := dbiReadWrite;
    end;
    if not FCached then
    begin
      if FDataSet.State = dsBrowse then
        FDataSet.GetCurrentRecord(FDataSet.ActiveBuffer);
      Check(DbiOpenBlob(FDataSet.Handle, FBuffer, FFieldNo, OpenMode));
    end;
  end;
  FOpened := True;
  if Mode = bmWrite then Truncate;
end;

destructor TBlobStream.Destroy;
begin
  if FOpened then
  begin
    if FModified then FField.Modified := True;
    if not FField.Modified and not FCached then
      DbiFreeBlob(FDataSet.Handle, FBuffer, FFieldNo);
  end;
  if FModified then
  try
    FDataSet.DataEvent(deFieldChange, FField);
  except
    ApplicationHandleException(Self);
  end;
end;

function TBlobStream.Read(var Buffer: array of Byte; Offset, Count: Longint): Longint;
var
  Status: DBIResult;
begin
  if Offset <> 0 then
    raise Exception.Create(SInvalidStreamOffset);
  Result := 0;
  if FOpened then
  begin
    if FCached then
    begin
      if Count > Size - FPosition then
        Result := Size - FPosition else
        Result := Count;
      if Result > 0 then
      begin
        System.Array.Copy(FDataSet.GetBlobData(FField, FBuffer), FPosition,
          Buffer, 0, Result);
        Inc(FPosition, Result);
      end;
    end else
    begin
      Status := DbiGetBlob(FDataSet.Handle, FBuffer, FFieldNo, FPosition,
        Count, Buffer, Result);
      case Status of
        DBIERR_NONE, DBIERR_ENDOFBLOB:
          begin
            if FField.Transliterate then
              NativeToAnsiBuf(FDataSet.Locale, Buffer, Buffer, Result);
            if FDataset.FCacheBlobs and (FBuffer = FDataSet.ActiveBuffer) and
              (FMode = bmRead) and not FField.Modified and (FPosition = FCacheSize) then
            begin
              FCacheSize := FPosition + Result;
              SetLength(FBlobData, FCacheSize);
              System.Array.Copy(Buffer, 0, FBlobData, FPosition, Result);
              if FCacheSize = Size then
              begin
                FDataSet.SetBlobData(FField, FBuffer, FBlobData);
                FBlobData := nil;
                FCached := True;
                DbiFreeBlob(FDataSet.Handle, FBuffer, FFieldNo);
              end;
            end;
            Inc(FPosition, Result);
          end;
        DBIERR_INVALIDBLOBOFFSET:
          {Nothing};
      else
        DbiError(Status);
      end;
    end;
  end;
end;

function TBlobStream.Write(const Buffer: array of Byte; Offset, Count: Longint): Longint; 
var
  Temp: TBytes;
begin
  if Offset <> 0 then
    raise Exception.Create(SInvalidStreamOffset);
  Result := 0;
  if FOpened then
  begin
    if FField.Transliterate then
    begin
      SetLength(Temp, Count);
      AnsiToNativeBuf(FDataSet.Locale, Buffer, Temp, Count);
      Check(DbiPutBlob(FDataSet.Handle, FBuffer, FFieldNo, FPosition,
        Count, Temp));
    end else
      Check(DbiPutBlob(FDataSet.Handle, FBuffer, FFieldNo, FPosition,
        Count, Buffer));
    Inc(FPosition, Count);
    Result := Count;
    FModified := True;
    FDataSet.SetBlobData(FField, FBuffer, nil);
  end;
end;

function TBlobStream.Seek(const Offset: Int64; Origin: TSeekOrigin): Int64;
begin
  case Origin of
    soBeginning: FPosition := Offset;
    soCurrent: Inc(FPosition, Offset);
    soEnd: FPosition := GetBlobSize + Offset;
  end;
  Result := FPosition;
end;

procedure TBlobStream.SetSize(NewSize: Int64);
begin
  { Do nothing }
end;

procedure TBlobStream.Truncate;
begin
  if FOpened then
  begin
    Check(DbiTruncateBlob(FDataSet.Handle, FBuffer, FFieldNo, FPosition));
    FModified := True;
    FDataSet.SetBlobData(FField, FBuffer, nil);
  end;
end;

function TBlobStream.GetBlobSize: Longint;
begin
  Result := 0;
  if FOpened then
    if FCached then
      Result := FDataSet.GetBlobDataSize(FField, FBuffer) else
      Check(DbiGetBlobSize(FDataSet.Handle, FBuffer, FFieldNo, Result));
end;

{var
  SaveInitProc: Pointer;
  NeedToUninitialize: Boolean;

procedure InitDBTables;
begin
  if SaveInitProc <> nil then TProcedure(SaveInitProc);
  NeedToUninitialize := Succeeded(CoInitialize(nil));
end;}

initialization
  {if not IsLibrary then
  begin
    SaveInitProc := InitProc;
    InitProc := @InitDBTables;
  end;}
  Sessions := TSessionList.Create;
  BDEBuffers := TBDEBufferList.Create(Sessions);
  Session := TSession.Create(nil);
  Session.SessionName := 'Default'; { Do not localize }
  CSNativeToAnsi := TObject.Create;
  CSAnsiToNative := TObject.Create;
// Finalization section may not execute on all platforms
finalization
  CSAnsiToNative.Free;
  CSNativeToAnsi.Free;
  Sessions.Free;
  Sessions := nil;
  FreeAndNil(BDEInitProcs);
  FreeTimer(False, True); // Don't reset cursor as it may already be finalized
  BDEBuffers.Free;
  //if NeedToUninitialize then CoUninitialize;
end.
